/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.FS;
import org.makagiga.commons.Gettext;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTab;
import org.makagiga.commons.MTabbedPane;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.about.License;
import org.makagiga.commons.fx.Blend;
import org.makagiga.commons.fx.Reflection;
import org.makagiga.commons.mods.Mods;

public final class MAboutDialog
extends MDialog {
    private boolean aboutApplication;
    private LinkedList<JComponent> blendList = new LinkedList();
    private MLabel copyright;
    private MLabel descriptionLabel;
    private MPanel credits;
    private MScrollPane creditsScrollPane;
    private MTab licenseTab;
    private MTab systemTab;
    private MTabbedPane<?> tabs;
    private MTimer blendTimer;
    private MURLButton bugs;
    private MURLButton licenseButton;
    private URI licenseURI;

    public MAboutDialog(Window window) {
        this(window, MApplication.getLogo() == null ? null : new MIcon(MApplication.getLogo()), MApplication.getTitle(), MApplication.getDescription());
        this.aboutApplication = true;
        this.setCopyright(MApplication.getCopyright());
        this.setHomePage(MApplication.getHomePage());
        this.setLicense(null, null);
        this.creditsScrollPane = new MScrollPane(2);
        this.systemTab = new MTab(UI._("System"));
        this.tabs.addTab(UI._("Credits"), this.creditsScrollPane);
        this.tabs.addTab(this.systemTab);
    }

    public MAboutDialog(Window window, Icon icon, String string, String string2) {
        super(window, string, icon, 52);
        UI.changeFontSize(this.getURLButton(), 5);
        this.tabs = new MTabbedPane();
        this.tabs.addTab(this.initGeneralTab());
        this.addCenter(this.tabs);
        this.setBugs(null);
        this.setDescription(string2);
    }

    public void addCredit(String string, String string2, String string3) {
        this.addCredit(string, string2, string3, null, null);
    }

    public void addCredit(String string, String string2, String string3, License license) {
        this.addCredit(string, string2, string3, license.getName(), license.getURI().toString());
    }

    @Deprecated
    public void addCredit(String string, String string2, String string3, String string4, String string5) {
        JComponent jComponent;
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            jComponent = this.credits.addHeader(string);
            jComponent.setForeground(Color.WHITE);
            this.blendList.add(jComponent);
        }
        if (string2 != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" - ");
            }
            stringBuilder.append(string2);
            this.addCreditsLabel(string2);
        }
        if (string3 != null) {
            jComponent = new MURLButton();
            ((MButton)jComponent).setStyle("margin: 2 2 2 10");
            ((MURLButton)jComponent).setURLAndText(string3);
            if (stringBuilder.length() > 0) {
                ((MURLButton)jComponent).setTitle(stringBuilder.toString());
            }
            this.credits.add(jComponent);
        }
        if (string4 != null) {
            if (string5 == null) {
                this.addCreditsLabel(UI._("License: {0}", string4));
            } else {
                jComponent = new MURLButton();
                ((MButton)jComponent).setStyle("margin: 2 2 2 10");
                ((AbstractButton)jComponent).setText(UI._("License: {0}", string4));
                ((MURLButton)jComponent).setURL(string5);
                this.credits.add(jComponent);
            }
        }
    }

    @Deprecated
    public void addCredit(String string, String string2, String string3, String string4) {
        this.addCredit(string, string2, "mailto:" + string4 + "@" + string3);
    }

    @Override
    public boolean exec() {
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = MAboutDialog.this.tabs.getSelectedIndex();
                if (MAboutDialog.this.aboutApplication && n == 1 && MAboutDialog.this.credits == null) {
                    MAboutDialog.this.initCreditsTab();
                } else if (MAboutDialog.this.aboutApplication && n == 2 && MAboutDialog.this.systemTab.getComponentCount() == 0) {
                    MAboutDialog.this.initSystemTab();
                } else if (MAboutDialog.this.tabs.getSelectedComponent() == MAboutDialog.this.licenseTab) {
                    MAboutDialog.this.initLicenseTab();
                }
            }
        });
        this.setSize(UI.WindowSize.MEDIUM);
        this.setResizable(false);
        return super.exec();
    }

    public MTabbedPane<?> getTabs() {
        return this.tabs;
    }

    public boolean isAboutApplication() {
        return this.aboutApplication;
    }

    public void setBugs(String string) {
        if (TK.isEmpty(string)) {
            this.bugs.setVisible(false);
        } else {
            this.bugs.setURL(string);
            this.bugs.setVisible(true);
        }
    }

    public void setCopyright(String string) {
        MAboutDialog.setMultilineText(this.copyright, string);
    }

    public void setDescription(String string) {
        MAboutDialog.setMultilineText(this.descriptionLabel, string);
    }

    public void setHomePage(String string) {
        this.setHomePage(string, string);
    }

    @Deprecated
    public void setHomePage(String string, String string2) {
        MURLButton mURLButton = this.getURLButton();
        if (TK.isEmpty(string2)) {
            mURLButton.setText(null);
            mURLButton.setURL(null);
            mURLButton.setToolTipText(null);
            mURLButton.setVisible(false);
        } else {
            mURLButton.setText(string == null ? UI._("Home Page") : string);
            mURLButton.setURL(string2);
            mURLButton.setToolTipText(UI._("More Info..."));
            mURLButton.setVisible(true);
        }
    }

    public void setLicense(String string, String string2) {
        if (TK.isEmpty(string) && TK.isEmpty(string2)) {
            String string3 = MApplication.getResourceString("Application.x.licenseURL", null);
            if (string3 == null) {
                this.licenseButton.setText(null);
                this.licenseButton.setURL(null);
                this.licenseButton.setVisible(false);
            } else {
                String string4 = MApplication.getResourceString("Application.x.licenseName", null);
                if (string4 == null) {
                    string4 = "?";
                }
                this.licenseButton.setText(UI._("License: {0}", string4));
                this.licenseButton.setURL(string3);
                this.licenseButton.setVisible(this.licenseURI == null);
            }
        } else {
            this.licenseButton.setText(UI._("License: {0}", string));
            this.licenseButton.setURL(string2);
            this.licenseButton.setVisible(this.licenseURI == null);
        }
    }

    public void setLicenseURI(URI uRI) {
        this.licenseURI = TK.checkNull(uRI);
        if (this.licenseTab == null) {
            this.licenseButton.setVisible(false);
            this.licenseTab = new MTab(UI._("License"));
            this.tabs.addTab(this.licenseTab);
        }
    }

    @Deprecated
    public void setReleaseNotes(String string) {
    }

    @Deprecated
    public void setShortDescription(String string) {
        this.setDescription(string);
    }

    @Override
    protected void onClose() {
        super.onClose();
        if (this.blendList != null) {
            this.blendList.clear();
            this.blendList = null;
        }
        if (this.blendTimer != null) {
            this.blendTimer.stop();
            this.blendTimer = null;
        }
    }

    private void addCreditsLabel(String string) {
        MLabel mLabel = new MLabel(string);
        mLabel.setForeground(Color.WHITE);
        mLabel.setStyle("margin: 0 0 0 10");
        this.blendList.add(mLabel);
        this.credits.add(mLabel);
    }

    private void initCreditsTab() {
        this.blendTimer = new MTimer(70){

            @Override
            protected boolean onTimeout() {
                if (MAboutDialog.this.blendList.isEmpty()) {
                    return false;
                }
                JComponent jComponent = (JComponent)MAboutDialog.this.blendList.pollFirst();
                Blend.animateForeground(jComponent, Color.WHITE, Color.BLACK);
                return true;
            }
        };
        this.credits = MPanel.createVBoxPanel();
        this.credits.setContentMargin();
        this.credits.setBackground(Color.WHITE);
        String string = Gettext.getMetaInfo("Last-Translator");
        if (!TK.isEmpty(string)) {
            this.addCredit(string, UI._("Translation - {0}", Locale.getDefault().getDisplayLanguage()), null);
        }
        License license = new License("Creative Common Attribution-ShareAlike 3.0 license", URI.create("http://creativecommons.org/licenses/by-sa/3.0/"));
        License license2 = new License("GNU Lesser General Public License 2.1", URI.create("http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html"));
        License license3 = new License("MIT License", URI.create("http://en.wikipedia.org/wiki/MIT_License"));
        this.addCredit("Kirill Grouchnikov", "Trident - an animation library", "http://kenai.com/projects/trident/pages/Home", License.BSD);
        this.addCredit("The Oxygen Team", "Oxygen Icon Theme", "http://www.oxygen-icons.org", license);
        this.addCredit("Everaldo Coelho and the KDE Team", "Crystal SVG Icon Theme", "http://www.everaldo.com");
        this.addCredit("SwingLabs SwingX Project Team", "Drop Shadow Border implementation", "http://swinglabs.org/", license2);
        this.addCredit("Jeff Friesen, InformIT.com", "Icon Reader", "http://www.informit.com/articles/article.aspx?p=1186882", License.BSD);
        this.addCredit("Jerry Huxtable", "Image Filters", "http://www.jhlabs.com/ip/index.html", License.APACHE_V2);
        this.addCredit("The Apache Software Foundation", "Apache Commons Codec", "http://commons.apache.org/codec/", License.APACHE_V2);
        this.addCredit("Mikael Grev", "MiGBase64 - A high performance base64 codec", "http://migbase64.sourceforge.net/", License.BSD);
        this.addCredit("Eirik Bjorsnos", "Macify Library", "http://simplericity.com/2007/10/02/1191336060000.html", License.APACHE_V2);
        this.addCredit("Romain Guy", "Java/Swing Special Effects", "http://www.curious-creature.org/");
        this.addCredit("Santhosh Kumar", "Java/Swing Ideas", "http://www.jroller.com/page/santhosh");
        this.addCredit("Scott Violet", "Ocean Gradient Customizer", "http://weblogs.java.net/blog/zixle/archive/2005/09/customizing_oce_1.html");
        this.addCredit("Konrad Twardowski", "Makagiga Platform", "http://makagiga.wiki.sourceforge.net/SDK", License.APACHE_V2);
        this.addCredit("Portland", "Xdg-utils", "http://portland.freedesktop.org/", license3);
        this.addCredit("SourceForge.net", "Project Hosting", "http://sourceforge.net");
        this.addCredit("Yellowicon Studio", "\"Emotion\" Icon Set", "http://www.yellowicon.com");
        MMainWindow mMainWindow = MApplication.getMainWindow();
        if (mMainWindow != null) {
            mMainWindow.onDynamicInit(this);
        }
        Mods.exec(this, "initCredits@org.makagiga.commons.MAboutDialog", new Object[0]);
        Image image = MIcon.getImage("duke.jpg");
        Reflection reflection = new Reflection();
        reflection.setBlur(true);
        MLabel mLabel = new MLabel(reflection.createImage(image));
        mLabel.setStyle("margin: " + this.credits.getContentMargin() * 2);
        mLabel.setToolTipText("Duke");
        this.credits.add(mLabel);
        this.creditsScrollPane.setScrollSpeed(20);
        this.creditsScrollPane.setViewportView(this.credits);
        this.blendTimer.start();
    }

    private MTab initGeneralTab() {
        this.bugs = new MURLButton();
        this.bugs.setText(UI._("Report Bug..."));
        this.copyright = new MLabel();
        this.licenseButton = new MURLButton();
        this.descriptionLabel = new MLabel();
        MTab mTab = new MTab(UI._("General"));
        mTab.setGroupLayout(false);
        mTab.setMargin(mTab.getContentMargin() * 2);
        mTab.getGroupLayout().beginRows().addComponent(this.descriptionLabel).addGap(mTab.getContentMargin() * 2).addComponent(this.copyright).addGap().addComponent(this.licenseButton).addGap().addStretch().addComponent(this.bugs).end();
        return mTab;
    }

    private void initLicenseTab() {
        if (this.licenseTab.getComponentCount() == 0) {
            MHTMLViewer mHTMLViewer = new MHTMLViewer();
            this.licenseTab.addCenter(mHTMLViewer, 2);
            this.licenseTab.validate();
            try {
                File file = new File(this.licenseURI);
                String string = FS.read(file, "UTF8");
                string = TK.escapeXML(string);
                string = string.replace("\n", "<br>");
                string = string.replace(" ", "&nbsp;");
                mHTMLViewer.setHTML("<p>" + string + "</p>");
            }
            catch (IOException iOException) {
                MMessage.error((Window)this, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSystemTab() {
        String string;
        try {
            UI.setWaitCursor(this, true);
            string = OS.getSummary(true);
        }
        finally {
            UI.setWaitCursor(this, false);
        }
        MEditorPane mEditorPane = MEditorPane.newPlainText(string, false);
        this.systemTab.addCenter(mEditorPane, 2);
    }

    private static void setMultilineText(MLabel mLabel, String string) {
        if (TK.isEmpty(string)) {
            mLabel.setText(null);
            mLabel.setVisible(false);
        } else {
            mLabel.setMultilineText(string);
            mLabel.setVisible(true);
        }
    }
}

