/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;

public final class Linkify {
    private Pattern pattern;

    public String apply(CharSequence charSequence) {
        Matcher matcher = this.pattern.matcher(charSequence);
        return matcher.replaceAll("<a href=\"$0\">$0</a>");
    }

    public Set<URI> findAll(CharSequence charSequence) {
        if (TK.isEmpty(charSequence)) {
            return Collections.emptySet();
        }
        Matcher matcher = this.pattern.matcher(charSequence);
        TreeSet<URI> treeSet = null;
        while (matcher.find()) {
            if (treeSet == null) {
                treeSet = new TreeSet<URI>();
            }
            try {
                treeSet.add(new URI(matcher.group()));
            }
            catch (URISyntaxException uRISyntaxException) {
                MLogger.exception(uRISyntaxException);
            }
        }
        return treeSet == null ? Collections.emptySet() : treeSet;
    }

    public static Linkify getInstance() {
        return LazyLinkifyHolder.INSTANCE;
    }

    private Linkify(Pattern pattern) {
        this.pattern = TK.checkNull(pattern);
    }

    private static final class LazyLinkifyHolder {
        private static final Linkify INSTANCE = new Linkify(Pattern.compile("[a-z]+:(/){1,2}([\\w+?\\.\\w+])+([a-zA-Z0-9\\~\\!\\@\\#\\$\\%\\^\\&\\*\\(\\)_\\-\\=\\+\\\\\\/\\?\\.\\:\\;\\'\\,]*)?", 34));

        private LazyLinkifyHolder() {
        }
    }
}

