/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.makagiga.commons.AbstractSelection;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public final class ImageSelection
extends AbstractSelection<Image> {
    private final Color backgroundColor;
    private static DataFlavor bmpImageFlavor = ImageSelection.createDataFlavor("image/bmp", "java.awt.Image");
    private static DataFlavor pngImageFlavor = ImageSelection.createDataFlavor("image/png", "java.awt.Image");

    public ImageSelection(Image image, Color color) {
        super(TK.checkNull(image, "image"), DataFlavor.imageFlavor, pngImageFlavor, bmpImageFlavor);
        this.backgroundColor = color;
    }

    @Override
    public synchronized Object getContents(DataFlavor dataFlavor) {
        boolean bl = dataFlavor.equals(DataFlavor.imageFlavor);
        if (bl && OS.isWindows() || dataFlavor.equals(bmpImageFlavor)) {
            return this.convertToBMP((Image)this.getData());
        }
        return this.getData();
    }

    private BufferedImage convertToBMP(Image image) {
        try {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(n, n2, UI.getTypeForImageFormat("bmp"));
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(this.backgroundColor == null ? Color.WHITE : this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.drawImage(image, 0, 0, null, null);
            graphics2D.dispose();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "bmp", byteArrayOutputStream);
            FS.close(byteArrayOutputStream);
            return ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return null;
        }
    }
}

