/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;

public class CommandOptions
implements Serializable {
    private ErrorMode errorMode = ErrorMode.IGNORE;
    private final MArrayList<Option> registeredOptions = new MArrayList();
    private String[] options = TK.EMPTY_STRING_ARRAY;

    public boolean containsRaw(String string) {
        return this.indexOfRaw(string) != -1;
    }

    public ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public void setErrorMode(ErrorMode errorMode) {
        this.errorMode = TK.checkNull(errorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOption(String string) {
        TK.checkNullOrEmpty(string);
        this.checkError(string);
        CommandOptions commandOptions = this;
        synchronized (commandOptions) {
            for (int i = 0; i < this.options.length; ++i) {
                if (!this.matches(this.options[i], string)) continue;
                if (i < this.options.length - 1) {
                    return this.options[i + 1];
                }
                return null;
            }
        }
        return null;
    }

    public synchronized String getRaw(int n) {
        return this.options[n];
    }

    public synchronized List<Option> getRegisteredOptions() {
        return Collections.unmodifiableList(this.registeredOptions);
    }

    public synchronized int indexOfRaw(String string) {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean isEmpty() {
        return this.options.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet(String string) {
        TK.checkNullOrEmpty(string);
        this.checkError(string);
        if (this.isEmpty()) {
            return false;
        }
        CommandOptions commandOptions = this;
        synchronized (commandOptions) {
            for (String string2 : this.options) {
                if (!this.matches(string2, string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option registerOption(String string, String string2, String string3) {
        Option option = new Option(string, string2, string3);
        CommandOptions commandOptions = this;
        synchronized (commandOptions) {
            this.registeredOptions.add(option);
        }
        return option;
    }

    public synchronized void set(String ... stringArray) {
        this.options = TK.copyOf(stringArray);
    }

    public synchronized int size() {
        return this.options.length;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Option object2 : this.registeredOptions) {
            int n2 = 0;
            if (object2.shortName != null) {
                n2 += object2.shortName.length() + 1;
            }
            if (object2.longName != null) {
                if (n2 > 0) {
                    n2 += 2;
                }
                n2 += object2.longName.length() + 2;
            }
            n = Math.max(n2, n);
        }
        List list = (List)this.registeredOptions.clone();
        Collections.sort(list, null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            stringBuilder.append(option.toString(n)).append('\n');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkError(String string) {
        if (this.errorMode == ErrorMode.IGNORE) {
            return true;
        }
        boolean bl = false;
        CommandOptions commandOptions = this;
        synchronized (commandOptions) {
            for (Option option : this.registeredOptions) {
                if (!string.equals(option.shortName) && !string.equals(option.longName)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            if (this.errorMode == ErrorMode.FATAL) {
                throw new IllegalArgumentException("Unregistered/unknown option name: " + string);
            }
            if (this.errorMode == ErrorMode.WARNING) {
                MLogger.warning("core", "Unregistered/unknown option name: " + string);
            }
        }
        return bl;
    }

    private boolean matches(String string, String string2) {
        return string.equals("-" + string2) || string.equals("--" + string2);
    }

    public static final class Option
    implements Comparable<Option>,
    Serializable {
        private final String description;
        private final String longName;
        private final String shortName;

        public String getDescription() {
            return this.description;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String toString() {
            return this.toString(-1);
        }

        @Override
        public int compareTo(Option option) {
            String string = this.shortName == null ? this.longName : this.shortName;
            String string2 = option.shortName == null ? option.longName : option.shortName;
            return string.compareTo(string2);
        }

        private Option(String string, String string2, String string3) {
            this.shortName = string;
            this.longName = string2;
            this.description = string3;
        }

        private String toString(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.shortName != null) {
                stringBuilder.append('-').append(this.shortName);
            }
            if (this.longName != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("--").append(this.longName);
            }
            if (n == -1) {
                stringBuilder.append("  ");
            } else {
                stringBuilder.append(TK.filler(' ', n - stringBuilder.length() + 2));
            }
            stringBuilder.append(this.description);
            return stringBuilder.toString();
        }
    }

    public static enum ErrorMode {
        IGNORE,
        WARNING,
        FATAL;

    }
}

