/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.Config;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MV;
import org.makagiga.commons.StringList;
import org.makagiga.commons.UI;

public final class ColumnManager<M extends TableModel> {
    private MArrayList<TableColumn> allColumns;
    private MArrayList<TableColumn> defaultColumnOrder;
    private final WeakReference<MTable<M>> tableRef;

    public ColumnManager(MTable<M> mTable) {
        this.tableRef = new WeakReference<MTable<M>>(mTable);
        this.update();
    }

    public JComponent createCornerComponent() {
        MSmallButton mSmallButton = new MSmallButton(MActionInfo.SETTINGS.getSmallIcon(), UI._("Columns")){

            @Override
            protected MMenu onPopupMenu() {
                return ColumnManager.this.createMenu();
            }
        };
        mSmallButton.setEnabled((Boolean)Kiosk.actionSettings.get());
        mSmallButton.setPopupMenuArrowPainted(false);
        mSmallButton.setPopupMenuEnabled(true);
        return mSmallButton;
    }

    public MMenu createMenu() {
        MMenu mMenu = new MMenu(UI._("Columns"), MActionInfo.SETTINGS.getIconName());
        mMenu.setSplitMenu(true);
        MTable mTable = (MTable)this.tableRef.get();
        if (mTable != null && mTable.getRowSorter() != null) {
            this.createSortMenu(mMenu, true);
        }
        if (Kiosk.tableColumnReorderingAllowed.booleanValue()) {
            this.createVisibleMenu(mMenu, true);
        }
        if (mTable != null) {
            mMenu.addSeparator();
            SaveAsDefaultAction saveAsDefaultAction = new SaveAsDefaultAction(mTable);
            saveAsDefaultAction.setEnabled(mTable instanceof Config.GlobalEntry);
            mMenu.add(saveAsDefaultAction);
        }
        return mMenu;
    }

    public MMenu createSortMenu() {
        MMenu mMenu = new MMenu(UI._("Sort by Column"));
        MTable mTable = (MTable)this.tableRef.get();
        if (mTable.getRowSorter() == null) {
            mMenu.setEnabled(false);
            return mMenu;
        }
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                ColumnManager.this.createSortMenu(mMenu, false);
            }
        });
        return mMenu;
    }

    public void createSortMenu(MMenu mMenu, boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        if (bl) {
            mMenu.addTitle(UI._("Sort by Column"));
        }
        SortAction sortAction = new SortAction(-1, UI._("Unsorted"));
        buttonGroup.add(mMenu.addRadioButton(sortAction, true));
        List<TableColumn> list = this.getVisibleColumns();
        if (!list.isEmpty()) {
            mMenu.addSeparator();
        }
        for (TableColumn tableColumn : list) {
            sortAction = new SortAction(tableColumn.getModelIndex(), tableColumn.getHeaderValue().toString());
            buttonGroup.add(mMenu.addRadioButton(sortAction));
            MTable mTable = (MTable)this.tableRef.get();
            int n = mTable.convertColumnIndexToView(tableColumn.getModelIndex());
            sortAction.setSelected(mTable.isSortByColumn(n));
        }
    }

    public MMenu createVisibleMenu() {
        MMenu mMenu = new MMenu(UI._("Visible Columns"));
        mMenu.setEnabled(Kiosk.tableColumnReorderingAllowed.booleanValue());
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                ColumnManager.this.createVisibleMenu(mMenu, false);
            }
        });
        return mMenu;
    }

    public void createVisibleMenu(MMenu mMenu, boolean bl) {
        if (bl) {
            mMenu.addTitle(UI._("Visible Columns"));
        }
        int n = 0;
        MAction mAction = null;
        for (int i = 0; i < this.allColumns.size(); ++i) {
            String string = ((TableColumn)this.allColumns.get(i)).getHeaderValue().toString();
            VisibleAction visibleAction = new VisibleAction(i, string);
            boolean bl2 = this.isVisible(i);
            mMenu.addCheckBox(visibleAction, bl2);
            if (!bl2) continue;
            if (mAction == null) {
                mAction = visibleAction;
            }
            ++n;
        }
        if (n == 1 && mAction != null) {
            mAction.setEnabled(false);
        }
        mMenu.addSeparator();
        mMenu.add(new MAction(MActionInfo.RESTORE_DEFAULT_VALUES){

            @Override
            public void onAction() {
                StringList stringList = new StringList();
                stringList.addAll(ColumnManager.this.getDefaultColumnOrderAsString().split(" "));
                List<TableColumn> list = ColumnManager.this.getAllColumns();
                MTable mTable = (MTable)ColumnManager.this.tableRef.get();
                for (int i = 0; i < list.size(); ++i) {
                    TableColumn tableColumn = list.get(i);
                    if (tableColumn == null) continue;
                    mTable.getColumnModel().removeColumn(tableColumn);
                    Object object = tableColumn.getIdentifier();
                    if (object != null && stringList.contains(object.toString())) {
                        mTable.getColumnModel().addColumn(tableColumn);
                        ColumnManager.this.setVisible(i, true);
                        continue;
                    }
                    ColumnManager.this.setVisible(i, false);
                }
            }
        });
    }

    public List<TableColumn> getAllColumns() {
        return this.allColumns;
    }

    public List<TableColumn> getDefaultColumnOrder() {
        return this.defaultColumnOrder;
    }

    public String getDefaultColumnOrderAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TableColumn tableColumn : this.defaultColumnOrder) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(tableColumn.getIdentifier().toString());
        }
        return stringBuilder.toString();
    }

    public void setDefaultColumnOrder(Enum<?> ... enumArray) {
        this.defaultColumnOrder.clear();
        for (Enum<?> enum_ : enumArray) {
            this.defaultColumnOrder.add((TableColumn)this.allColumns.get(enum_.ordinal()));
        }
    }

    public void setDefaultColumnOrder(int ... nArray) {
        this.defaultColumnOrder.clear();
        for (int n : nArray) {
            this.defaultColumnOrder.add((TableColumn)this.allColumns.get(n));
        }
    }

    public List<TableColumn> getVisibleColumns() {
        MTable mTable = (MTable)this.tableRef.get();
        TableColumnModel tableColumnModel = mTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        MArrayList<TableColumn> mArrayList = new MArrayList<TableColumn>(n);
        for (int i = 0; i < n; ++i) {
            mArrayList.add(tableColumnModel.getColumn(i));
        }
        return mArrayList;
    }

    public boolean isVisible(int n) {
        MTable mTable = (MTable)this.tableRef.get();
        return mTable.convertColumnIndexToView(n) != -1;
    }

    public void setVisible(int n, boolean bl) {
        if (bl == this.isVisible(n)) {
            return;
        }
        MTable mTable = (MTable)this.tableRef.get();
        TableColumn tableColumn = (TableColumn)this.allColumns.get(n);
        if (bl) {
            Rectangle rectangle;
            mTable.addColumn(tableColumn);
            int n2 = mTable.convertColumnIndexToView(n);
            if (n2 != -1 && (rectangle = mTable.getCellRect(mTable.isEmpty(MV.VIEW) ? -1 : 0, n2, true)) != null) {
                mTable.scrollRectToVisible(rectangle);
            }
        } else {
            mTable.removeColumn(tableColumn);
        }
    }

    public void readConfig(Config config, Config config2, Config.GlobalEntry globalEntry) {
        MTable mTable = (MTable)this.tableRef.get();
        if (mTable == null) {
            return;
        }
        if (config2 == null || !mTable.readColumnOrder(config2, globalEntry.getGlobalEntry("columns"), null)) {
            mTable.readColumnOrder(config, globalEntry.getGlobalEntry("columns"), this.getDefaultColumnOrderAsString());
        }
        Config config3 = config2 != null ? config2 : config;
        mTable.readSortOrder(config3, globalEntry.getGlobalEntry("sortMethod"), globalEntry.getGlobalEntry("sortOrder"));
        if (!mTable.isEmpty(MV.MODEL)) {
            int n = config3.readInt(globalEntry.getGlobalEntry("currentRow"), 0);
            try {
                if (n != -1) {
                    n = mTable.convertRowIndexToView(n);
                }
                mTable.selectRow(n != -1 ? n : 0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                mTable.selectRow(0);
            }
        }
        for (TableColumn tableColumn : this.allColumns) {
            int n = tableColumn.getPreferredWidth();
            int n2 = config3.readInt(globalEntry.getGlobalEntry("columnWidth." + tableColumn.getIdentifier()), n, 30);
            tableColumn.setPreferredWidth(n2);
            tableColumn.setWidth(n2);
        }
    }

    public void writeConfig(Config config, Config config2, Config.GlobalEntry globalEntry) {
        MTable mTable = (MTable)this.tableRef.get();
        if (mTable == null) {
            return;
        }
        Config config3 = config2 != null ? config2 : config;
        mTable.writeColumnOrder(config3, globalEntry.getGlobalEntry("columns"));
        mTable.writeSortOrder(config3, globalEntry.getGlobalEntry("sortMethod"), globalEntry.getGlobalEntry("sortOrder"));
        int n = mTable.getSelectedRow();
        config3.write(globalEntry.getGlobalEntry("currentRow"), n == -1 ? 0 : mTable.convertRowIndexToModel(n));
        for (TableColumn tableColumn : this.allColumns) {
            config3.write(globalEntry.getGlobalEntry("columnWidth." + tableColumn.getIdentifier()), tableColumn.getWidth());
        }
    }

    public void update() {
        this.allColumns = (MArrayList)this.getVisibleColumns();
        this.defaultColumnOrder = new MArrayList<TableColumn>((Collection<TableColumn>)this.allColumns);
    }

    public void updateProperties() {
        MTable mTable = (MTable)this.tableRef.get();
        if (mTable == null) {
            return;
        }
        if (!(mTable.getModel() instanceof AbstractListTableModel)) {
            return;
        }
        AbstractListTableModel.ColumnInfo[] columnInfoArray = ((AbstractListTableModel)AbstractListTableModel.class.cast(mTable.getModel())).getColumnInfo();
        if (columnInfoArray.length != this.allColumns.size()) {
            return;
        }
        for (int i = 0; i < columnInfoArray.length; ++i) {
            Object object = columnInfoArray[i].getIdentifier();
            if (object != null) {
                ((TableColumn)this.allColumns.get(i)).setIdentifier(object);
            }
            ((TableColumn)this.allColumns.get(i)).setPreferredWidth(columnInfoArray[i].getPreferredWidth());
        }
    }

    private final class VisibleAction
    extends ColumnAction {
        @Override
        public void onAction() {
            ColumnManager.this.setVisible((Integer)this.getData(), this.isSelected());
        }

        private VisibleAction(int n, String string) {
            super(n, string);
        }
    }

    private final class SortAction
    extends ColumnAction {
        @Override
        public void onAction() {
            MTable mTable = (MTable)ColumnManager.this.tableRef.get();
            mTable.sortBy((Integer)this.getData(), true);
        }

        private SortAction(int n, String string) {
            super(n, string);
        }
    }

    private static final class SaveAsDefaultAction
    extends MDataAction.Weak<MTable<?>> {
        @Override
        public void onAction() {
            MTable mTable = (MTable)this.get();
            Config.GlobalEntry globalEntry = (Config.GlobalEntry)((Object)mTable);
            Config config = Config.getDefault();
            mTable.writeColumnOrder(config, globalEntry.getGlobalEntry("columns"));
            config.sync();
        }

        private SaveAsDefaultAction(MTable<?> mTable) {
            super(mTable, MActionInfo.SAVE_AS_DEFAULT);
        }
    }

    private static abstract class ColumnAction
    extends MDataAction<Integer> {
        protected ColumnAction(int n, String string) {
            super(Integer.valueOf(n), string);
        }
    }
}

