/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.chart;

import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.MGraphics;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;

public class ChartView<M extends ChartModel>
extends MGraphics {
    private ChartPainter<M> painter;

    public ChartView() {
        this(new ChartModel.Sample());
    }

    public ChartView(M m) {
        this(new ChartPainter<M>(m));
    }

    public ChartView(ChartPainter<M> chartPainter) {
        this.setOpaque(true);
        this.setPainter(chartPainter);
        StaticHandler staticHandler = new StaticHandler();
        this.addMouseListener(staticHandler);
        this.addMouseMotionListener(staticHandler);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ChartModel.Item getActiveItem() {
        return this.painter.activeItem;
    }

    public ChartPainter<M> getPainter() {
        return this.painter;
    }

    public void setPainter(ChartPainter<M> chartPainter) {
        TriBoolean triBoolean = TriBoolean.UNDEFINED;
        if (this.painter != null) {
            triBoolean = TriBoolean.from(this.painter.interactive);
            this.removeItem(this.painter);
        }
        this.painter = TK.checkNull(chartPainter, "value");
        if (triBoolean.isDefined()) {
            this.painter.interactive = triBoolean.isTrue();
        }
        this.addItem(this.painter);
        this.repaint();
    }

    public boolean isInteractive() {
        return this.painter.interactive;
    }

    public void setInteractive(boolean bl) {
        this.painter.interactive = bl;
    }

    protected void fireActionPerformed() {
        TK.fireActionPerformed(this, this.getActionListeners());
    }

    private static final class StaticHandler
    extends MMouseAdapter {
        private StaticHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ChartView chartView = (ChartView)mouseEvent.getSource();
            if (((ChartView)chartView).painter.interactive && ((ChartView)chartView).painter.activeItem != null) {
                chartView.fireActionPerformed();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ChartView chartView = (ChartView)mouseEvent.getSource();
            if (((ChartView)chartView).painter.interactive) {
                chartView.repaint();
                int n = !((ChartView)chartView).painter.interactive || ((ChartView)chartView).painter.activeItem == null ? 0 : 12;
                chartView.setCursor(n);
            }
        }
    }
}

