/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.chart;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.makagiga.chart.ChartModel;
import org.makagiga.commons.AbstractListTableModel;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.FloatProperty;
import org.makagiga.commons.FontProperty;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MGraphics;
import org.makagiga.commons.StringProperty;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.painters.Painter;

public class ChartPainter<M extends ChartModel>
extends MGraphics.Item
implements Painter {
    private static final long serialVersionUID = -4303513409081208559L;
    public static final int MINIMUM_OUTLINE_SIZE = 1;
    public static final int MAXIMUM_OUTLINE_SIZE = 20;
    public final ColorProperty backgroundColor = new ColorProperty(Color.WHITE);
    public final IntegerProperty chartSize = new IntegerProperty(200);
    public final BooleanProperty fxShine = new BooleanProperty(true);
    public final BooleanProperty imageScale = new BooleanProperty(true);
    public final BooleanProperty outlineBorder = new BooleanProperty(true);
    public final ColorProperty outlineColor = new ColorProperty(Color.WHITE);
    public final IntegerProperty outlineSize = new IntegerProperty(3);
    public final BooleanProperty outlineVisible = new BooleanProperty(true);
    public final ColorProperty shadowColor = new ColorProperty(Color.GRAY);
    public final IntegerProperty shadowOffset = new IntegerProperty(5);
    public final BooleanProperty shadowVisible = new BooleanProperty(true);
    public final FloatProperty textAlpha = new FloatProperty(0.7f);
    public final ColorProperty textBackground = new ColorProperty(0xFFFFDC);
    public final IntegerProperty textDistance = new IntegerProperty(20);
    public final FontProperty textFont = new FontProperty("Dialog", 1, UI.getDefaultFontSize());
    public final ColorProperty textForeground = new ColorProperty((Color)null);
    public final StringProperty textFormat = new StringProperty();
    public final BooleanProperty textLineAutoColor = new BooleanProperty();
    public final IntegerProperty textLineSize = new IntegerProperty(1);
    public final IntegerProperty textPadding = new IntegerProperty(3);
    public final EnumProperty<TextType> textType = EnumProperty.create(TextType.ROUND_RECT, TextType.class);
    public final BooleanProperty textVisible = new BooleanProperty(true);
    protected transient CacheInfo[] itemCache;
    protected Insets imageArea = UI.createInsets(0);
    protected int chartX;
    protected int chartY;
    protected int height;
    protected int midChartSize;
    protected int midX;
    protected int midY;
    protected int width;
    protected long totalNumber;
    private int lightMargin = 13;
    private int lightSize;
    private int outlineWidth;
    private int shadowSize;
    private M model;
    boolean interactive;
    ChartModel.Item activeItem;

    public ChartPainter(M m) {
        this.model = (ChartModel)TK.checkNull(m, "model");
    }

    @Override
    public void draw(MGraphics mGraphics, Graphics2D graphics2D) {
        this.paint(mGraphics, graphics2D);
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M m) {
        this.model = (ChartModel)TK.checkNull(m, "value");
    }

    public void paint(Graphics2D graphics2D, int n, int n2, Color color, Point point) {
        this.width = n;
        this.height = n2;
        this.midX = n / 2;
        this.midY = n2 / 2;
        int n3 = (Integer)this.chartSize.get();
        this.midChartSize = n3 / 2;
        this.chartX = this.midX - this.midChartSize;
        this.chartY = this.midY - this.midChartSize;
        this.totalNumber = ((ChartModel)this.model).getTotal();
        this.activeItem = null;
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        this.lightSize = n3 - this.lightMargin * 2 / 2;
        int n4 = (Integer)this.shadowOffset.get();
        this.shadowSize = this.lightSize + this.lightMargin + 12;
        this.outlineWidth = (Boolean)this.outlineVisible.get() != false ? (Integer)this.outlineSize.get() : 0;
        this.outlineWidth = Math.max(this.outlineWidth, 1);
        this.outlineWidth = Math.min(this.outlineWidth, 20);
        this.imageArea.left = this.chartX - this.outlineWidth;
        this.imageArea.top = this.chartY - this.outlineWidth;
        this.imageArea.right = this.imageArea.left + n3 + n4 + this.outlineWidth * 2;
        this.imageArea.bottom = this.imageArea.top + n3 + n4 + this.outlineWidth * 2;
        this.drawBackground(graphics2D, color);
        this.setupRenderingHints(graphics2D);
        if (((Boolean)this.shadowVisible.get()).booleanValue()) {
            this.drawShadow(graphics2D);
        }
        this.resetCache();
        int n5 = ((AbstractListTableModel)this.model).getRowCount();
        for (int i = 0; i < n5; ++i) {
            CacheInfo cacheInfo = this.itemCache[i];
            ChartModel.Item item = (ChartModel.Item)((AbstractListTableModel)this.model).getRowAt(i);
            Shape shape2 = this.drawPie(graphics2D, item, cacheInfo, cacheInfo.startAngle, point);
            if (item.getImage() == null) continue;
            this.drawIcon(graphics2D, item, cacheInfo, cacheInfo.startAngle, shape2);
        }
        this.drawTopGradient(graphics2D);
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
        if (this.outlineWidth > 0) {
            this.drawOutline(graphics2D);
        }
        if (((Boolean)this.textVisible.get()).booleanValue()) {
            this.drawText(graphics2D);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public BufferedImage toBufferedImage(Color color) {
        return this.toBufferedImage(this.width, this.height, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage toBufferedImage(int n, int n2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.paint(graphics2D, n, n2, color, null);
        }
        finally {
            graphics2D.dispose();
        }
        return ChartPainter.cutImage(bufferedImage, this.imageArea, n, n2);
    }

    @Override
    public Insets getPainterInsets(Component component) {
        return null;
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D) {
        this.paint(component, graphics2D, 0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.paint(graphics2D, n3, n4, component.isOpaque() ? (Color)this.backgroundColor.get() : null, this.interactive ? component.getMousePosition() : null);
    }

    protected void drawBackground(Graphics2D graphics2D, Color color) {
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.width, this.height);
        }
    }

    protected void drawIcon(Graphics2D graphics2D, ChartModel.Item item, CacheInfo cacheInfo, int n, Shape shape) {
        Point point = new Point((int)((double)this.midX + cacheInfo.cos), (int)((double)this.midY + cacheInfo.sin) + 1);
        Shape shape2 = graphics2D.getClip();
        double d = cacheInfo.labelStart.distance(point) / 2.0;
        graphics2D.clip(shape);
        if (cacheInfo.arcAngle > 190) {
            Image image = item.getImage();
            if (((Boolean)this.imageScale.get()).booleanValue()) {
                graphics2D.drawImage(image, this.chartX, this.chartY, (Integer)this.chartSize.get(), (Integer)this.chartSize.get(), null);
            } else {
                graphics2D.drawImage(image, this.midX - image.getWidth(null) / 2, this.midY - image.getHeight(null) / 2, null);
            }
        } else {
            Image image = item.getImage();
            if (((Boolean)this.imageScale.get()).booleanValue()) {
                Point point2 = new Point((int)((double)this.midX + cacheInfo.cos * (double)this.midChartSize), (int)((double)this.midY + cacheInfo.sin * (double)this.midChartSize));
                double d2 = Math.PI * (double)(-(n + cacheInfo.arcAngle)) / 180.0;
                Point point3 = new Point((int)((double)this.midX + Math.cos(d2) * (double)this.midChartSize), (int)((double)this.midY + Math.sin(d2) * (double)this.midChartSize));
                int n2 = (int)Math.min(point2.distance(point3), d * 2.0);
                graphics2D.drawImage(image, (int)((double)this.midX + cacheInfo.textCos * d) - n2 / 2, (int)((double)this.midY + cacheInfo.textSin * d) - n2 / 2, n2, n2, null);
            } else {
                graphics2D.drawImage(image, (int)((double)this.midX + cacheInfo.textCos * (d + 10.0)) - image.getWidth(null) / 2, (int)((double)this.midY + cacheInfo.textSin * (d + 10.0)) - image.getHeight(null) / 2, null);
            }
        }
        graphics2D.setClip(shape2);
    }

    protected void drawOutline(Graphics2D graphics2D) {
        int n;
        graphics2D.setStroke(new BasicStroke(this.outlineWidth, 1, 1));
        graphics2D.setColor((Color)this.outlineColor.get());
        int n2 = ((AbstractListTableModel)this.model).getRowCount();
        for (n = 0; n < n2; ++n) {
            CacheInfo cacheInfo = this.itemCache[n];
            graphics2D.drawLine((int)((double)this.midX + cacheInfo.cos), (int)((double)this.midY + cacheInfo.sin) + 1, (int)((double)this.midX + cacheInfo.cos * (double)this.midChartSize), (int)((double)this.midY + cacheInfo.sin * (double)this.midChartSize));
        }
        n = (Integer)this.chartSize.get();
        if (this.outlineWidth > 0 && ((Boolean)this.outlineBorder.get()).booleanValue()) {
            graphics2D.drawOval(this.chartX - 1, this.chartY - 1, n + 1, n + 1);
        }
    }

    protected Shape drawPie(Graphics2D graphics2D, ChartModel.Item item, CacheInfo cacheInfo, int n, Point point) {
        Arc2D.Double double_ = new Arc2D.Double(this.chartX, this.chartY, ((Integer)this.chartSize.get()).intValue(), ((Integer)this.chartSize.get()).intValue(), n, cacheInfo.arcAngle, 2);
        if (point != null && double_.contains(point)) {
            this.activeItem = item;
            graphics2D.setColor(MColor.getBrighter((Color)item.getValue()));
        } else {
            graphics2D.setColor((Color)item.getValue());
        }
        graphics2D.fill(double_);
        return double_;
    }

    protected void drawShadow(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        int n = (Integer)this.shadowOffset.get();
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.35f));
        graphics2D.setPaint(new RadialGradientPaint(this.midX + n, (float)(this.midY + n), (float)this.shadowSize / 2.0f, new float[]{0.0f, 0.9f, 1.0f}, new Color[]{Color.WHITE, (Color)this.shadowColor.get(), UI.INVISIBLE}));
        graphics2D.fillOval(this.chartX + n, this.chartY + n, this.shadowSize, this.shadowSize);
        graphics2D.setComposite(composite);
    }

    protected void drawText(Graphics2D graphics2D) {
        int n = ((AbstractListTableModel)this.model).getRowCount();
        int n2 = ((Integer)this.chartSize.get() + (Integer)this.textDistance.get() * 2) / 2;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            CacheInfo cacheInfo = this.itemCache[i];
            ChartModel.Item item = (ChartModel.Item)((AbstractListTableModel)this.model).getRowAt(i);
            if (TK.isEmpty(cacheInfo.text)) continue;
            Point point = new Point((int)((double)this.midX + cacheInfo.textCos * (double)n2), (int)((double)this.midY + cacheInfo.textSin * (double)n2));
            if (n3 != Integer.MIN_VALUE && n4 != Integer.MIN_VALUE) {
                int n5 = this.textFont.get().getSize() + ((Integer)this.textPadding.get() + (Integer)this.textLineSize.get()) * 2;
                if (n3 < this.midX && point.x < this.midX && point.y < n4 + n5) {
                    point.y = n4 + n5;
                } else if (n3 > this.midX && point.x > this.midX && point.y + n5 > n4) {
                    point.y = n4 - n5;
                }
            }
            this.drawText(graphics2D, cacheInfo.labelStart, point, item, cacheInfo.text);
            n3 = point.x;
            n4 = point.y;
        }
    }

    protected void drawText(Graphics2D graphics2D, Point point, Point point2, ChartModel.Item item, String string) {
        Color color = (Color)this.textBackground.get();
        Color color2 = (Color)this.textForeground.get();
        if (color2 == null) {
            color2 = MColor.deriveColor(color, 0.3f);
        }
        Color color3 = null;
        if (((Boolean)this.textLineAutoColor.get()).booleanValue()) {
            color3 = (Color)item.getValue();
        }
        if (color3 == null) {
            color3 = color2;
        }
        graphics2D.setColor(color3);
        Composite composite = graphics2D.getComposite();
        float f = ((Float)this.textAlpha.get()).floatValue();
        f = Math.max(f, 0.0f);
        f = Math.min(f, 1.0f);
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
        boolean bl = (Integer)this.textLineSize.get() > 0;
        Point point3 = new Point();
        point3.x = point2.x < this.midX ? point2.x - (Integer)this.textDistance.get() : point2.x + (Integer)this.textDistance.get();
        point3.y = point2.y;
        if (bl) {
            graphics2D.setStroke(new BasicStroke(((Integer)this.textLineSize.get()).intValue(), 2, 1));
            if ((Integer)this.textDistance.get() > 0) {
                graphics2D.drawPolyline(new int[]{point.x, point2.x, point2.x, point3.x}, new int[]{point.y, point2.y, point2.y, point3.y}, 4);
            }
        }
        graphics2D.setFont(this.textFont.get());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        int n = (Integer)this.textPadding.get();
        int n2 = (int)rectangle2D.getWidth() + n * 2;
        int n3 = (int)rectangle2D.getHeight() + n * 2;
        int n4 = point3.x < this.midX ? point3.x - n2 : point3.x;
        int n5 = point3.y - n3 / 2;
        int n6 = Math.max(1, (Integer)this.textLineSize.get() / 2);
        switch ((TextType)((Object)this.textType.get())) {
            case RECT: {
                if (bl) {
                    graphics2D.setStroke(new BasicStroke(((Integer)this.textLineSize.get()).intValue(), 2, 0));
                    graphics2D.drawRect(n4, n5, n2, n3);
                }
                graphics2D.setColor(color);
                graphics2D.fillRect(n4 + n6, n5 + n6, n2 - n6 * 2 + 1, n3 - n6 * 2 + 1);
                break;
            }
            case ROUND_RECT: {
                int n7 = 7;
                if (bl) {
                    graphics2D.setStroke(new BasicStroke(((Integer)this.textLineSize.get()).intValue(), 1, 1));
                    graphics2D.drawRoundRect(n4, n5, n2, n3, n7, n7);
                }
                graphics2D.setColor(color);
                graphics2D.fillRoundRect(n4 + n6, n5 + n6, n2 - n6 * 2 + 1, n3 - n6 * 2 + 1, n7, n7);
                break;
            }
            default: {
                throw new WTFError((Enum)this.textType.get());
            }
        }
        this.imageArea.left = Math.min(this.imageArea.left, n4 - (Integer)this.textLineSize.get());
        this.imageArea.top = Math.min(this.imageArea.top, n5 - (Integer)this.textLineSize.get());
        this.imageArea.right = Math.max(this.imageArea.right, n4 + n2 + (Integer)this.textLineSize.get() + 1);
        this.imageArea.bottom = Math.max(this.imageArea.bottom, n5 + n3 + (Integer)this.textLineSize.get() + 1);
        graphics2D.setColor(color2);
        graphics2D.drawString(string, n4 += n, n5 += (n3 - (int)rectangle2D.getHeight()) / 2 + fontMetrics.getAscent() - 1);
        graphics2D.setComposite(composite);
    }

    protected void drawTopGradient(Graphics2D graphics2D) {
        int n = (Integer)this.chartSize.get();
        if (((Boolean)this.fxShine.get()).booleanValue()) {
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.35f));
            graphics2D.setPaint(new RadialGradientPaint(this.midX, (float)this.midY, (float)this.lightSize / 2.0f, new float[]{0.0f, 0.7f, 1.0f}, new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 205), new Color(255, 255, 255, 210)}));
            graphics2D.fillOval(this.chartX + this.lightMargin / 2, this.chartY + this.lightMargin / 2, this.lightSize, this.lightSize);
        }
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.4f));
        graphics2D.setClip(new Ellipse2D.Float(this.chartX, this.chartY - 1, n, n - this.outlineWidth * 2));
        graphics2D.setPaint(new LinearGradientPaint(this.chartX + this.midChartSize, this.chartY, this.chartX + this.midChartSize, this.chartY + n, new float[]{0.0f, 0.9f}, new Color[]{Color.WHITE, UI.INVISIBLE}));
        graphics2D.fillRect(this.chartX, this.chartY, n + this.outlineWidth * 2, n);
    }

    protected void setupRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    private static BufferedImage cutImage(BufferedImage bufferedImage, Insets insets, int n, int n2) {
        return bufferedImage.getSubimage(Math.max(insets.left, 0), Math.max(insets.top, 0), Math.min(insets.right - insets.left, n), Math.min(insets.bottom - insets.top, n2));
    }

    private void resetCache() {
        int n = (Integer)this.chartSize.get();
        int n2 = ((AbstractListTableModel)this.model).getRowCount();
        int n3 = 0;
        this.itemCache = new CacheInfo[n2];
        for (int i = 0; i < n2; ++i) {
            CacheInfo cacheInfo;
            this.itemCache[i] = cacheInfo = new CacheInfo();
            ChartModel.Item item = (ChartModel.Item)((AbstractListTableModel)this.model).getRowAt(i);
            cacheInfo.text = ((ChartModel)this.model).formatText((String)this.textFormat.get(), item, this.totalNumber);
            cacheInfo.arcAngle = (int)((float)(item.number * 360L) / (float)this.totalNumber);
            if (i == n2 - 1) {
                cacheInfo.arcAngle = 360 - n3;
            }
            double d = Math.PI * (double)(-n3) / 180.0;
            cacheInfo.cos = Math.cos(d);
            cacheInfo.sin = Math.sin(d);
            d = Math.PI * (double)(-(n3 + (n3 + cacheInfo.arcAngle - n3) / 2)) / 180.0;
            cacheInfo.textCos = Math.cos(d);
            cacheInfo.textSin = Math.sin(d);
            int n4 = (n + this.outlineWidth) / 2;
            cacheInfo.labelStart = new Point((int)((double)this.midX + cacheInfo.textCos * (double)n4), (int)((double)this.midY + cacheInfo.textSin * (double)n4));
            cacheInfo.startAngle = n3;
            n3 += cacheInfo.arcAngle;
        }
    }

    protected static class CacheInfo {
        protected double cos;
        protected double sin;
        protected double textCos;
        protected double textSin;
        protected int arcAngle;
        protected int startAngle;
        protected Point labelStart;
        protected String text;

        protected CacheInfo() {
        }
    }

    public static enum TextType {
        RECT,
        ROUND_RECT;

    }
}

