#ifndef __SMTPSESSION_HPP__
    #define __SMTPSESSION_HPP__

    #include "smtpsession.h"

    class SMTPResponseData
    {
        public:
    
        inline SMTPResponseData()
        {
            initData();
            arsize+=RESP_ARRAY_INCREMENT;
            ra = new char*[arsize];
            if (ra==NULL)
                OutOfMemory();
        }
    
        inline ~SMTPResponseData()
        {
            clearArray();
            delete[] ra;
         }
    
        inline char* lineAt(ULONG idx)
        {
            if ((idx+1)>lc)
                return NULL;
            else
                return ra[idx];
        }
    
        inline char* operator[](ULONG idx)
        {
            return lineAt(idx);
        }
    
        inline void reset()
        {
            clearArray();
        }
    
        inline ULONG lines()
        {
            return lc;
        }
    
        inline BOOL addLine(char *rline)
        {
            if ((lc+1)>arsize)
                {
                if (!expandArray())
                    return FALSE;
                }
    
            ra[lc] = new char[strlen(rline)+1];
            strcpy(ra[lc], rline);
            lc++;
            return TRUE;
        }
    
        private:
    
        inline void clearArray()
        {
            for (ULONG i=0; i<lc; i++)
                {
                delete ra[i];
                }
            lc=0;
        }
    
        inline void initData()
        {
            ra=0;
            lc=0;
            arsize=0;
        }
    
        BOOL expandArray();
    
        char **ra;
        ULONG lc, arsize;
    };
    
    class SMTPCommandResult
    {
        public:
    
        SMTPResponseData responseData;
        USHORT returnValue[5];
        USHORT numReturnValues;
        BOOL noSocketFailure;
    
        inline void reset()
        {
            memset(returnValue, 0, sizeof(returnValue));
            numReturnValues=0;
            noSocketFailure=FALSE;
            responseData.reset();
        }
    };

    class SMTPSession
    {
        public:

        SMTPSession(char *hostname);
        SMTPSession(char *hostname, USHORT port);
        SMTPSession();
        ~SMTPSession();

        void setHost(char *hostname);
        void setHost(char *hostname, USHORT port);
        void setPort(USHORT port);

        BOOL openConnection(void);
        BOOL sendSender(char *sender);
        BOOL sendReceiver(char *receiver);
        BOOL sendMailData(char *maildata, BOOL noDateHeader=FALSE);
        BOOL sendClose(void);

        ULONG failureCause(void);

        void cleanUpSockets(void);

        private:

        SMTPCommandResult* sendCommand(char *cmdstring);
        void setFailureCause(ULONG cause);
        void initData(void);
        void outOfMemory(void);

        char *hostname;
        USHORT smtpPort;
        struct sockaddr_in sa;
        int csock;
        ULONG failCause;
        SMTPCommandResult scr;
    };
#endif
