/* M.DLL Demo Quiz */

/* (c) AD 1997, 2011 */

/* Full-screen textmode ? */

ARG textmode

IF textmode<>'ENVIRCHK' THEN DO
   '@START "M.DLL Demo Quiz" /C /FS /PGM EXAMPLE2.CMD ENVIRCHK'
   EXIT
END

/* Load external functions */

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

CALL RxFuncAdd 'MColdSpot','M','MColdSpot'
CALL RxFuncAdd 'MHotSpot','M','MHotSpot'
CALL RxFuncAdd 'Mouse','M','Mouse'
CALL RxFuncAdd 'MReset','M','MReset'

/* Screen initialization */

CALL SysCurState 'OFF'
CALL SysCls

'@ANSI ON > NUL'

screen.0='[?7h[40m[2J[13C[0;1;44m [34m[0;30;44mĿ [40m'
screen.1='[13C[44m [1;34m                         [0;30;44m[1;34mĿ [0;30;44m [40m'
screen.2='[13C[44m [1;34m [0;44m       Demo of          [30m                      [1;34m [0;30;44m [40m'
screen.3='[13C[44m [1;34m [0;44m                        [30m                      [1;34m [0;30;44m [40m'
screen.4="[13C[44m [1;34m [0;44m    userinterface       [30m                      [1;34m [0;30;44m [40m"
screen.5='[13C[44m [1;34m                         [0;30;44m[1;34m [0;30;44m [40m'
screen.6='[13C[44m [1;34m                         [0;30;44m[1;34mĿ [0;30;44m [40m'
screen.7='[13C[44m [1;34m    [0;44m                     [30m                      [1;34m [0;30;44m [40m'
screen.8='[13C[44m [1;34m    [0;44m                     [30m                      [1;34m [0;30;44m [40m'
screen.9='[13C[44m [1;34m    [0;44m                     [30m                      [1;34m [0;30;44m [40m'
screen.10='[13C[44m [1;34m                         [0;30;44m[1;34m [0;30;44m [40m'
screen.11='[13C[44m [1;34m                         [0;30;44m[1;34mĿ [0;30;44m [40m'
screen.12='[13C[44m [1;34m    [0;44m                     [30m                      [1;34m [0;30;44m [40m'
screen.13='[13C[44m [1;34m    [0;44m                     [30m                      [1;34m [0;30;44m [40m'
screen.14='[13C[44m [1;34m    [0;44m                     [30m                      [1;34m [0;30;44m [40m'
screen.15='[13C[44m [1;34m                         [0;30;44m[1;34m [0;30;44m [40m'
screen.16='[13C[44m [1;34m                         [0;30;44m[1;34mĿ [0;30;44m [40m'
screen.17='[13C[44m [1;34m         [0;44m Score :        [30m                      [1;34m [0;30;44m [40m'
screen.18='[13C[44m [1;34m         [0;44m                [30m                      [1;34m [0;30;44m [40m'
screen.19='[13C[44m [1;34m         [0;44m                [30m                      [1;34m [0;30;44m [40m'
screen.20='[13C[44m [1;34m                         [0;30;44m[1;34m [0;30;44m [40m'
screen.21='[13C[44m [1;34m [0;30;44m[1;34mĿ[0;30;44m[1;34mĿ [0;30;44m [40m'
screen.22='[13C[44m [1;34m [0;30;44m         [0;44mExit         [1;34m[0;30;44m         [0;44mHelp         [1;34m [0;30;44m [40m'
screen.23='[13C[44m [1;34m [0;30;44m[1;34m[0;30;44m[1;34m [0;30;44m [40m'
screen.24='[13C[44m [1;34m[0;30;44m [0m'

DO i=0 TO 23
   SAY screen.i
END i

CALL CharOut '',screen.24

/* General initialization */

question.0=16
score=0

CALL MReset

/* Display initial score */

part1=Copies(' ',11-Length(Score))
part2=' / '||(question.0)*10
CALL SysCurPos 19,16
SAY '[0;44m'||part1||score||part2

/* Assign return value to Answer buttons */

DO i=1 TO 4
   DO y=0 TO 4
      retval=MHotSpot(((i*5)-4)+y,40,((i*5)-4)+y,63,i)
   END y
END i

/* Assign return value to Exit button and Help button */

DO y=21 TO 23
   DO i=5 TO 6
      retval=MHotSpot(y,((i-5)*24)+16,y,((i-5)*24)+39,i)
   END i
END y


/* Definition of answers, question and related values */

/* Question 1 */

answer.1='Dr. No#and#Thunderball##Diamonds are forever#and#Thunderball##From Russia with love#and#Goldfinger##Thunderball#and#Never say never again###'
good.1=4
help.1="Dr. No? No! No!#Thunderball? Yes!###"
pause.1=4
question.1='Which James Bond#movies are based#on one story?###'
wait.1=8
wrong.1="A Thunderball author#had to base his own#movie (Never say#never again) on#Thunderball's story.###"

/* Question 2 */

answer.2='#120 - 0###140 - 0###147 - 0###154 - 0###'
good.2=3
help.2="It's possible that#you had to begin#play!###"
pause.2=5
question.2='What is the maximum#final Snooker score if#you get one turn?###'
wait.2=6
wrong.2='15 red balls with#15 black balls is#120, and 27 for#all the colors.###'

/* Question 3 */

answer.3='#22/7###3.14159624###3.1415962408679###Not given here###'
good.3=4
help.3='Have you ever tried#to calculate it?###'
pause.3=4
question.3='What is the value of#the number "pi"?###'
wait.3=6
wrong.3='The given numbers are#not exactly pi, since#pi is an endless#number.###'

/* Question 4 */

answer.4='#Cheap rate###Expensive rate###No other name for it##Capital market#    #interest rate###'
good.4=4
help.4='...-term?#... name!###'
pause.4=4
question.4="What's the long-term#interest rate also#known as?###"
wait.4=5
wrong.4='     #It is also known as#the capital market#interest rate.###'

/* Question 5 */

answer.5='#Ayrton Senna###Damon Hill###Michael Schumacher###Nigel Mansell###'
good.5=3
help.5='Spraggen ci Doitz?###'
pause.5=3
question.5='Who was the 1994#Formula 1 Racing#world champion?###'
wait.5=5
wrong.5='     #Michael Schumacher.#Damon Hill lost by#just 1 point.###'

/* Question 6 */

answer.6='#Dirty###Disk###Drive###Dynamic###'
good.6=1
help.6="Be glad you aren't#using DOS/2 now!###"
pause.6=4
question.6='In the early days of#DOS, the "D" was?###'
wait.6=4
wrong.6="     #It's name was QDOS,#(Q)uick & (D)irty.###"

/* Question 7 */

answer.7='#Named after a dog##REstructured#eXtended#eXecutor##Real-time#EXecutable#eXtra##Real-time#EXtra#eXecutable###'
good.7=2
help.7='Is there a difference#between Batch and#Real-time?###'
pause.7=5
question.7='#Rexx is ...?###'
wait.7=5
wrong.7="     #Rexx' full name is:#REstructured eXtended#eXecutor.###"

/* Question 8 */

answer.8="#By mistake###It's New Sealand###Maori origin###Dutch origin###"
good.8=4
help.8='The Northsea is also#known as Noordzee#in some countries!####'
pause.8=5
question.8='Why is New Zealand#written with a#"Z"?###'
wait.8=5
wrong.8="     #It's named after a#Dutch province,#(Z)eeland.###"

/* Question 9 */

answer.9='#Casino###Rascas###Loews###Portier###'
good.9=4
help.9='Unknown?###'
pause.9=3
question.9='What is the name of#the corner before the#tunnel in Monaco?###'
wait.9=6
wrong.9='The name of that#corner on the#Monte Carlo circuit#is Portier.###'

/* Question 10 */

answer.10='#6.656###3.328###1.664###0.832###'
good.10=2
help.10='Racing distance is#259.584 km, which#are 78 laps...###'
pause.10=5
question.10='How long is the Monte#Carlo circuit (km)?###'
wait.10=4
wrong.10="     #The circuit's lenght#is 3.328 km.###"

/* Question 11 */

answer.11='#1, 2, 4, etc.###1, 3, 5, etc.###1 + 2 + 4, etc.###1, 2, 3, 5, 7, etc.###'
good.11=2
help.11='Just add it!###'
pause.11=3
question.11='Which numbers are#related to : 1*1,#2*2, 3*3, etc.?###'
wait.11=5
wrong.11='     #3 + 1 =  4 (=2*2)#5 + 4 =  9 (=3*3)#7 + 9 = 16 (=4*4)###'

/* Question 12 */

answer.12='#I have money###Dinner is served###I am hungry###Name of a dance###'
good.12=1
help.12='It has nothing to do#with food!###'
pause.12=4
question.12='In Spain, what does#"Tengo dinero" mean?###'
wait.12=4
wrong.12='     #Tengo means "I have",#dinero means "money".###'

/* Question 13 */

answer.13='#Amsterdam###Antwerp###Helsinki###Melbourne###'
good.13=1
help.13='"Diamonds are forever"#by I. Fleming...###'
pause.13=4
question.13='In 1928, the Olympic#Games visited ...?###'
wait.13=7
wrong.13='Amsterdam. The first#Olympic Games where#the flame burned#during the whole#event.###'

/* Question 14 */

answer.14='#Daughter of###Made by earth###Made by water###Nothing###'
good.14=1
help.14='Men only?#Of course not!###'
pause.14=4
question.14='In Iceland, "dottir"#in a name means ...?###'
wait.14=4
wrong.14='     #Like "son", "dottir"#means "Daughter of".###'

/* Question 15 */

answer.15='#7.1###71###701###1016###'
good.15=4
help.15="Don't add numbers,#add digits!###"
pause.15=4
question.15='2163 -> 379 -> ...?###'
wait.15=7
wrong.15='2 + 1 =  3#1 + 6 =  7#6 + 3 =  9#3 + 7 = 10#7 + 9 = 16###'

/* Question 16 */

answer.16='#Jessica Rabbit###Nobody###Oscar Rabbit###Title of a movie###'
good.16=4
help.16='No Oscar?###'
pause.16=3
question.16='Who framed Roger#Rabbit?###'
wait.16=4
wrong.16="     #It's the title of a#movie.###"


/* Randomize questions */

DO i=1 TO question.0
   order.i=0
END i

order.1=Random(1,question.0)

DO i=2 TO question.0
   seen=1
   DO UNTIL seen=0
      temp=Random(1,question.0)
      DO j=1 to (i-1)
         IF order.j=temp THEN seen=2
      END j
      IF seen=1 THEN seen=0
      IF seen=2 THEN seen=1
   END
   order.i=temp
END i

/* Start the game */

DO i=1 TO question.0

   /* Display question */

   now=order.i

   raw=question.now

   pad=Copies(' ',22)

   DO j=8 to 9
      CALL SysCurPos j,17
      SAY '[0;44m'||pad
   END j

   eol.1=Pos('#',raw)
   eoq.1=Pos('###',raw)
   line.1=SubStr(raw,1,(eol.1)-1)||pad
   CALL SysCurPos 7,17
   SAY '[0;44m'||Left(line.1,22)

   IF eol.1<>eoq.1 THEN DO
      eol.2=Pos('#',raw,(eol.1)+1)
      line.2=SubStr(raw,(eol.1)+1,(eol.2)-(eol.1)-1)||pad
      CALL SysCurPos 8,17
      SAY '[0;44m'||Left(line.2,22)

      IF eol.2<>eoq.1 THEN DO
         eol.3=Pos('#',raw,(eol.2)+1)
         line.3=SubStr(raw,(eol.2)+1,(eol.3)-(eol.2)-1)||pad
         CALL SysCurPos 9,17
         SAY '[0;44m'||Left(line.3,22)
      END

   END

   /* Display answers */

   raw=answer.now

   eoa.1=Pos('##',raw)-1
   eoa.2=Pos('##',raw,(eoa.1)+3)
   eoa.3=Pos('##',raw,(eoa.2)+3)
   eoa.4=Pos('###',raw,(eoa.3)+3)

   soa.1=1
   soa.2=(eoa.1)+3
   soa.3=(eoa.2)+2
   soa.4=(eoa.3)+2

   toa.1=SubStr(raw,soa.1,(eoa.1)-(soa.1)+1)
   toa.2=SubStr(raw,soa.2,(eoa.2)-(soa.2))
   toa.3=SubStr(raw,soa.3,(eoa.3)-(soa.3))
   toa.4=SubStr(raw,soa.4,(eoa.4)-(soa.4))

   DO l=1 TO 4

      number=1
      line.1=''
      line.2=''
      line.3=''

      DO j=1 TO Length(toa.l)

         flag=0

         IF SubStr(toa.l,j,1)='#' THEN DO
            number=number+1
            flag=1
         END

         IF flag=0 THEN DO
            line.number=line.number||SubStr(toa.l,j,1)
         END

      END j

      DO k=1 TO 3
         CALL SysCurpos (5*(l-1))+k+1,42
         SAY '[0;44m'||Center(line.k,21,' ')
      END k

   END l

   correct=0
   help=0

   DO UNTIL correct=1

      retval=Mouse()

      /* Help button */

      IF retval=6 THEN DO

         help=1
         now=order.i
         raw=help.now
         pad=Copies(' ',22)

         /* Disable Help button */

         DO y=21 TO 23
            retval=MColdSpot(y,40,y,63)
         END y

         CALL SysCurPos 22,50
         SAY '[0;44m    '

         eol.1=Pos('#',raw)
         eoq.1=Pos('###',raw)
         line.1=SubStr(raw,1,(eol.1)-1)||pad
         CALL SysCurPos 12,17
         SAY '[0;44m'||Left(line.1,22)

         IF eol.1<>eoq.1 THEN DO
            eol.2=Pos('#',raw,(eol.1)+1)
            line.2=SubStr(raw,(eol.1)+1,(eol.2)-(eol.1)-1)||pad
            CALL SysCurPos 13,17
            SAY '[0;44m'||Left(line.2,22)

            IF eol.2<>eoq.1 THEN DO
               eol.3=Pos('#',raw,(eol.2)+1)
               line.3=SubStr(raw,(eol.2)+1,(eol.3)-(eol.2)-1)||pad
               CALL SysCurPos 14,17
               SAY '[0;44m'||Left(line.3,22)
            END

         END

         CALL SysSleep pause.now

         DO j=12 to 14
            CALL SysCurPos j,17
            SAY '[0;44m'||pad
         END j

      END

      /* Exit button */

      IF retval=5 THEN DO
         comment='Maybe you should have asked more help?'
         IF score>(((question.0)*10)/3) THEN comment='Not bad!'
         IF score>(((question.0)*10)/2) THEN comment='Good!'
         IF score>(((question.0)*10)/1.5) THEN comment='Very good!!!'
         IF score=((question.0)*10) THEN comment='Perfect!!!!!'
         CALL SysCls
         SAY
         SAY
         SAY '[40mYou scored' score 'out of' (question.0)*10 'points.' comment
         SAY
         SAY 'Thank you for trying "M"!' 
         SAY         
         SAY 'Press any key to exit...'
         SAY
         CALL SysCurState 'ON'
         CALL SysGetKey 'NOECHO'
         EXIT
      END

      /* Answer button */

      IF retval=good.now THEN DO
         IF help=0 THEN score=score+5
         score=score+5
         part1=Copies(' ',11-Length(Score))
         part2=' / '||(question.0)*10
         CALL SysCurPos 19,16
         SAY '[0;44m'||part1||score||part2
         correct=1
      END

      /* Wrong answer */

      IF ((retval<>0)&(retval<>6)&(retval<>good.now)) THEN DO
         correct=1

         /* Remove wrong answers */

         DO y=1 TO 4
            IF y<>good.now THEN DO
               DO z=1 TO 3
                  CALL SysCurPos ((y-1)*5)+1+z,41
                  SAY '[0;44m'||pad
               END z
            END
         END y
 
         /* Display comment */

         raw=wrong.now

         DO j=12 to 16
            CALL SysCurPos j,17
            SAY '[0;44m'||pad
         END j

         eol.1=Pos('#',raw)
         eoq.1=Pos('###',raw)
         line.1=SubStr(raw,1,(eol.1)-1)||pad
         CALL SysCurPos 11,17
         SAY '[0;44m'||Left(line.1,22)

         IF eol.1<>eoq.1 THEN DO
            eol.2=Pos('#',raw,(eol.1)+1)
            line.2=SubStr(raw,(eol.1)+1,(eol.2)-(eol.1)-1)||pad
            CALL SysCurPos 12,17
            SAY '[0;44m'||Left(line.2,22)

            IF eol.2<>eoq.1 THEN DO
               eol.3=Pos('#',raw,(eol.2)+1)
               line.3=SubStr(raw,(eol.2)+1,(eol.3)-(eol.2)-1)||pad
               CALL SysCurPos 13,17
               SAY '[0;44m'||Left(line.3,22)

               IF eol.3<>eoq.1 THEN DO
                  eol.4=Pos('#',raw,(eol.3)+1)
                  line.4=SubStr(raw,(eol.3)+1,(eol.4)-(eol.3)-1)||pad
                  CALL SysCurPos 14,17
                  SAY '[0;44m'||Left(line.4,22)

                  IF eol.4<>eoq.1 THEN DO
                     eol.5=Pos('#',raw,(eol.4)+1)
                     line.5=SubStr(raw,(eol.4)+1,(eol.5)-(eol.4)-1)||pad
                     CALL SysCurPos 15,17
                     SAY '[0;44m'||Left(line.5,22)
 
                  END
               END
            END
         END

         CALL SysSleep wait.now

         /* Remove explanation */

         DO j=11 to 16
            CALL SysCurPos j,17
            SAY '[0;44m'||pad
         END j

      END
   END

   /* Enable Help button */

   IF help=1 THEN DO
      DO y=21 TO 23
         retval=MHotSpot(y,40,y,63,6)
      END y

      CALL SysCurPos 22,50
      SAY '[0;44mHelp'
   END
END i

comment='Maybe you should have asked more help?'
IF score>(((question.0)*10)/4) THEN comment='Not bad!'
IF score>(((question.0)*10)/2) THEN comment='Good!'
IF score>(((question.0)*10)/1.5) THEN comment='Very good!!!'
IF score=((question.0)*10) THEN comment='Perfect!!!!!'
CALL SysCls
SAY
SAY
SAY '[40mYou scored' score 'out of' (question.0)*10 'points.' comment
SAY
SAY 'Press any key to exit...'
SAY
CALL SysCurState 'ON'
CALL SysGetKey 'NOECHO'

EXIT

