/* This program can be used to create a summary of a Snug HTTP server log file.
	The program takes three parameters, the directory holding the log files,
   the output file and the error file in case of an error.
   The program will inspect all files with the log-extension. The summary will
   be written to the output file.

   The summary report will follow the ini file format and be divided in months,
   where each month will be represented in a section with the month's name.

   */


#include <stdio.h>
#include <dir.h>

int main(int argc, char *argv[]) {
   FILE *fherr, *fhin, *fhout;
   char FileName[12]; /* log0001.log */
   int i;
   char LogEntry[1024]; /* Should be enough for Snug HTTP server log files. */
   
	if( argc != 4 ) {
   	printf("Input directory and output file is required.\n");
      return 0;
   }

   if( chdir(argv[1]) != 0 ) {
   	printf("Could not change current working directory.\n");
      return 0;
   }

   /* Open files. */
   fherr = fopen(argv[3], "w");
   if( fherr == NULL ) {
   	printf("Could not open error log.\n");
      return 0;
   }

   fhout = fopen(argv[2], "w");
   if( fhout == NULL ) {
   	printf("Could not open summary file.\n");
      fclose(fhout);
      return 0;
   }

   printf("Looking for Snug HTTP server generated log files.\n");
   i = 0;
   while( i < 10000 ) {
   	sprintf(FileName, "log%04d.log", i);
      fhin = fopen(FileName, "rt");
      if( fhin == NULL ) {
   		printf("No more files to be found.\n");
      	break;
      }
      memccpy(LogEntry, '\n', 
   }

   fclose(fherr);
   fclose(fhout);
   return 1;
}