/*
 *
 * Copyright (C) 1996 by Josh Osborne.
 * All rights reserved.
 *
 * This software may be freely copied, modified and redistributed without
 * fee for non-commerical purposes provided that this copyright notice is
 * preserved intact on all copies and modified copies.
 * 
 * There is no warranty or other guarantee of fitness of this software.
 * It is provided solely "as is". The author(s) disclaim(s) all
 * responsibility and liability with respect to this software's usage
 * or its effect upon hardware, computer systems, other software, or
 * anything else.
 *
 */


#include <strings.h>
#include <assert.h>

// iostream has pissed me off, we will use open(2)
extern "C" {
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
}

#include "codec.h"
#include "avi.h"
#include "ppm.h"
#include "chunk.h"
#include "patchlevel.h"

const int FRAMES_PER_SECOND = 15;

#define NEED_ARG if (++i >= argc) { \
	cerr << argv[0] << ": option " << argv[i-1] << " needs an argument" \
	  << endl; \
	exit(3); \
}

int main(int argc, char *argv[])
{
	int i, nframes, f1idx;
	codec *cd = new cram16;
	char *fname = NULL;

	cerr << "mkavi " << VERSION << endl;

	for(i = 1; i < argc; i++) {
		if (argv[i][0] != '-') {
			break;
		}

		if (!strcmp(argv[i], "-codec")) {
			NEED_ARG;
			delete cd;
			cd = NULL;

			if (!strcmp(argv[i], "rgb24")) {
				cd = new rgb24;
			}
			if (!strcmp(argv[i], "cram16")) {
				cd = new cram16;
			}

			if (cd == NULL) {
				cerr << argv[0] << ": invalid codec " << argv[i] << endl;
				exit(3);
			}

			continue;
		}

		if (!strcmp(argv[i], "-file")) {
			NEED_ARG;

			fname = argv[i];
			continue;
		}

		cerr << argv[0] << ": unknown option " << argv[i] << endl;
		exit(3);
	}

	FILE *avif = NULL;

	if (!fname) {
		fname = "new.avi";
		cerr << "No file name given, defaulting to " << fname 
		  << " use '-file name' if you don't like it" << endl;
	}
	avif = fopen(fname, "w+b");
	if (!avif) {
		cerr << "Couldn't open for write " << argv[i] << endl;
		exit(4);
	}

	chunkstream avistr(avif);

	f1idx = i;
	nframes = argc - i;
	// it is wasteful to read the first ppm file twice, but that's life.
	ppm *p = new ppm(argv[f1idx]);

	cd->start(&avistr, p->w(), p->h(), nframes);

	riffchunk *riff = new riffchunk(&avistr, "AVI RIFF", 0, "AVI ");
	riff->write();
	avi_header *avih = new avi_header(&avistr, cd,
	  p->w(), p->h(), nframes, FRAMES_PER_SECOND);
	avih->write();
	delete(p);

	listchunk *movi = new listchunk(&avistr, "movi chunk", 1, "movi");
	movi->write();

	if (cd->need_prescan()) {
		for(i = f1idx; i < argc; i++) {
			ppm p(argv[i]);

			cd->prescan(&p, i - f1idx);
		}
	}

	for(i = f1idx; i < argc; i++) {
		ppm p(argv[i]);

		cd->frame(&p, i - f1idx);
	}

	cd->done();
	riff->done();
}
