/***********************************************************************/
/* Copyright 1996 Lotus Development Corporation.  All rights reserved. */
/*                                                                     */
/* REXX command file: Freelance Graphics for OS/2 Automated            */
/*                    Installation                                     */
/*                                                                     */
/* Lotus Freelance Graphics for OS/2 installation can be automated by  */
/* tailoring this file and FLG.RSP.  This file includes commands       */
/* and descriptions of parameters necessary for CID installation.      */
/* FLG.RSP includes selected user responses.  The .CMD and .RSP        */
/* files require editing to tailor them for your specific installation.*/
/*                                                                     */
/* The utility that allows the automation of redirected installation   */
/* and configuration is the LAN CID Utility (LCU).  File redirection   */
/* between the client workstation and the server is handled by the     */
/* Service Installable File System (SRVIFS).  With SRVIFS, you can     */
/* install and configure Lotus SmartSuite on a number of clients from  */
/* one server.                                                         */
/*                                                                     */
/***********************************************************************/

/*---------------------------------------------------*/
/*  DO NOT MODIFY THE NEXT EIGHT LINES               */
/*---------------------------------------------------*/

parse ARG client logfile additional
QUEUE_REBOOT = 0
CALL_AGAIN = 0
Call AddDLLFunctions
x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'FLG'
x.0.default  = ''

/*---------------------------------------------------*/
/*  MODIFICATIONS START HERE                         */
/*---------------------------------------------------*/

/**************************/
/*  SRVATTCH section      */
/**************************/

/* 'SRVATTCH x: SERVER1' */      /* Additional SRVATTCHs can be placed here         */
/* 'SRVATTCH y: SERVER2' */      /* They can be placed before specific RunInstall   */
                                 /* statements too if you only want to attach to a  */
                                 /* special server right before a specific install. */

/**************************/
/*  Variables section     */
/**************************/

/*---------------------------------------------------*/
/*  DO NOT REMOVE THE NEXT FOUR LINES                */
/*         (They may be modified)                    */
/*---------------------------------------------------*/

bootdrive='C:'                           /* Boot drive */
configsys = bootdrive || '\CONFIG.SYS'   /* Fully qualified path to CONFIG.SYS */
exepath = 'X:\IMG\FLG'                   /* Path to executable directory on server */
dllpath = 'X:\DLL'                       /* Paths to the DLL directories on server */

/**************************/
/*  Product data section  */
/**************************/

/*---------------------------------------------------*/
/*  DO NOT REMOVE THE NEXT ELEVEN LINES              */
/*         (They may be modified)                    */
/*  You may want to change the paths for the log,    */
/*  source, and response file directories.           */
/*---------------------------------------------------*/

x.install = 1                                          /* structure index */
x.1.name='Lotus Freelance Graphics for OS/2 Standard Version' /* product name */
x.1.statevar = 'FLG'||x.1.name                         /* state variable name */
x.1.instprog = exepath ||'\INSTALL.EXE',               /* fully qualified install program path */
               ' /a:I',                                /* indicate to install */
               ' /l1:X:\LOG\FLG\'||client||'.LOG',     /* error log - !! DIRECTORY MUST ALREADY EXIST !! */
               ' /p:"'x.1.name'"',                     /* name of product */
               ' /s:X:\IMG\FLG',                       /* source directory */
               ' /x'                                   /* indicate unattended install */
x.1.rspdir   = ' /r:X:\RSP\FLG'                        /* response file directory */
x.1.default  = 'FLG.RSP'                               /* default response file name */

/*---------------------------------------------------*/
/*  NUMBER OF PROGRAMS SET UP IN THE                 */
/*         PRODUCT DATA SECTION                      */
/*---------------------------------------------------*/

NUM_INSTALL_PROGS = 1

/*---------------------------------------------------*/
/*  DO NOT MODIFY OR REMOVE THE NEXT LINE            */
/*---------------------------------------------------*/

OVERALL_STATE = GetEnvironmentVars()

/**************************/
/*  Install section       */
/**************************/

Do Forever
  Select
    when OVERALL_STATE = 0 then do
      if BootDriveIsDiskette() == YES    then iterate  /* Check if booted from diskette*/
                                                                                               /*  if it was, then goto state 1*/
      if RunInstall(x.install) == BAD_RC then exit     /* Install maintenance system */
      Call CheckBoot                                   /* Reboot if it was requested */
    end
    when OVERALL_STATE = 1 then do
      if RunInstall(x.install) == BAD_RC then exit     /* Install operating system */
      Call CheckBoot                                   /* Reboot if it was requested */
    end
  end
exit

/*---------------------------------------------------*/
/*    DO NOT MODIFY ANY CODE BELOW THIS LINE         */
/*---------------------------------------------------*/

RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do
    rc2 = LogMessage(72, x.index.name, '', logfile)     /* log an install starting msg */
    install_prog = 'CMD /C ' || strip(x.index.instprog) /* build the command string    */

    /* If automatic response file selection was indicated, then get the response */
    /* file name and append it to the command string.                            */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
                                            , x.index.default, x.index.name,
                                            , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end
    install_prog                                       /* Execute the install program */
    state = value(x.index.statevar,,'OS2ENVIRONMENT')  /* Get the current install state */
                                                       /* for this install program from */
                                                       /* the environment.              */
    /* Check the return code and set the global variables accordingly. */
    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
           with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN
    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')    /* Set the new install state for this install program. */

    /* Put the install state into the CONFIG.SYS.  If this action is */
    /* unsuccessful, then exit.                                      */
    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit
    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then   /* If the install program was  */
        Call PreserveStartupCmd(install_prog)                 /* SEMAINT, then make sure     */
                                                              /* STARTUP.CMD won't be copied */
                                                              /* over when SEINST runs.      */
      rc2 = LogMessage(70, x.index.name, '', logfile)  /* log an install successful msg*/
      return GOOD_RC                                   /* return a good return code */
    end
    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)  /* log an install failed msg */
      if (new_state <> '') then                        /* If a new state was requested,*/
                                                                                                  /* then set OVERALL_STATE to the*/
        rc2 = SetState(new_state, 'RunInstall', 2)     /* new state. */
      return BAD_RC                                    /* return a bad return code */
    end
  end
  return GOOD_RC

/*************************************************************/
PreserveStartupCmd: procedure
  parse upper arg string, other
  if pos('/T:', string) <> 0 then                      /* Determine if there is a     */
    findvalue = '/T:'                                  /* target parameter.  If there */
  else                                                 /* is none, return.            */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0
  remain = substr(string, pos(findvalue, string) + 3)  /* Get the value of the target parameter. */
  blank = pos(' ', remain)
  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain       /* Erase startup.lcu in the target directory,  */
                         /* then rename startup.s13 to startup.lcu   */
  'if exist ' param  '\startup.lcu erase  ' param  '\startup.lcu'
  'if exist ' param  '\startup.s13 rename ' param  '\startup.s13 *.lcu'
  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS
  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')    /* Get the overall install state */
                                                                                                                       /* from the environment.  */
  if OVERALL_STATE == '' then do                       /* If the overall install state */
    OVERALL_STATE = 0                                  /* has not been set yet, reset  */
    do I=0 to NUM_INSTALL_PROGS by 1                   /* all the state vars to 0.     */
      if x.I.statevar <> '' then
        rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end
  return OVERALL_STATE

/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do      /* If the install program has  no state variable, then ...*/
    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')  /* Set the REMOTE_INSTALL_STATE       */
                                                             /* to 0 so that the program being run */
                                                             /* can know that is being run in an   */
                                                             /* unattended environment.            */
    return YES                                               /* return install=yes  */
  end
  state = value(env_string,,'OS2ENVIRONMENT')                /* Otherwise, get the value of the      */
                                                             /* state variable from the environment. */
  if state <> '' then do                                       /* If the state variable exists       */
    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')  /* Set the REMOTE_INSTALL_STATE       */
                                                               /* environment variable to the value  */
                                                               /* of the state variable.             */
    return YES                                               /* return install=yes */
  end
  else                                                       /* Otherwise, */
    return NO                                                /* return install=no */

/*************************************************************/
BootDriveIsDiskette:
  if IsBootDriveRemovable() == 1 then do     /* If the drive booted from is a diskette drive, then */
    rc2 = SetState(OVERALL_STATE+1)          /* set the OVERALL_STATE to the requested value.      */
    return 'YES'
  end
  else                                       /* else the machine was booted from the hardfile.  */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:
  if IsBootDriveRemovable() == 0 then do     /* If the drive booted from is a fixed disk, then */
    rc2 = SetState(OVERALL_STATE+1)          /* set the OVERALL_STATE to the requested value.  */
    return 'YES'
  end
  else                                       /* else the machine was booted from a diskette. */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other
    if datatype(new_state, number) <> 1 then do        /* If the new state requested is not numeric, */
      if proc_name <> '' then                          /* then log an error.                         */
        LogMessage(63, proc_name, param_num, logfile)
      else
        LogMessage(63, 'SetState', 1, logfile)
      exit
    end
    OVERALL_STATE = new_state                          /* Set the OVERALL_STATE to the new state requested. */
    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')   /* Save the OVERALL_STATE in the environment.*/
    return 'NO_ERROR'

/*************************************************************/
SaveStates:
  do I=0 to NUM_INSTALL_PROGS by 1                     /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                         /* if this action was unsuccessful, then exit.  */
      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
                     , configsys, logfile) <> 0 then exit
  end
  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other
  rc2 = SetState(new_state, 'RebootAndGotoState', 1)   /* Set the state to go to in OVERALL_STATE.*/
  Call SaveStates                                      /* Save the environment vars */
  Call Reboot                                          /* Reboot the machine */
  return

/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do              /* If a reboot has been queued by an install program ...  */
    if CALL_AGAIN == 0 then                 /* If no install programs want to be recalled ... */
      rc = SetState(OVERALL_STATE+1)        /* Increment the overall state variable. */
    Call SaveStates                         /* Save the environment vars */
    Call Reboot                             /* Reboot the machine        */
  end
  else                                      /* Otherwise, increment the  */
    rc = SetState(OVERALL_STATE+1)          /* state variable and go on. */
  return

/*************************************************************/
Reboot:
  bootdrive
  rc = value('OS2_SHELL', bootdrive  '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive  '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  'cls'
  rc = AskRemoveDiskIfFloppy()
  pathlen = length(exepath)                            /* Get length of exepath  */
  posslash = lastpos("\",strip(exepath))               /* Determine the last occurence of '\' in exepath*/
  if posslash = pathlen then                           /* If '\' is the last character */
    cmdline = exepath  'SETBOOT /IBD:'  bootdrive  /* Then append 'SETBOOT'        */
  else
    cmdline = exepath  '\SETBOOT /IBD:'  bootdrive /* Else append '\SETBOOT'  */
  LogMessage(74, '', '', logfile)                      /* Log a message indicating reboot. */
  cmdline
  LogMessage(73, 'SETBOOT', '', logfile)               /* If the code gets to here, the */
                                                       /* reboot failed.  Log a message then exit. */
  exit
  return

/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'
  return
