/*
 * main.c - C[`
 * loadds7 by Romy, 1997
 */

#include <stdio.h>
#include <stdlib.h>

#define INCL_DOS
#include <os2.h>

#include "serial.h"
#include "ds7.h"
#include "messages.h"

int
main( int argc, char* argv[] )
/* : argv[1]..COM|[gԍ, argv[2]..{[[g,
           argv[3]-..荞މ摜ԍ */
{
	HFILE hFile;
	CHAR sTmp[80];
	INT i, nImages;
	USHORT usBaud = 9600;	/*ʐMx9600{[*/
	CHAR *asFilename;

	/*o[W\*/
	fprintf( stderr, msg_Version );

	if( argc < 2 ){
		/*wv\*/
		fprintf( stderr, msg_Usage, argv[0] );
		return 0;
	}

	/*COM|[g̏*/
	if( COM_Init(atoi(argv[1]), &hFile) != 0 ){
		fprintf( stderr, msg_CantOpenCom, atoi(argv[1]) );
		return -1;
	}

	/*ڑv*/
	if( StartConnection( hFile ) != 0 || Resp(hFile) != ACK ){
		fprintf( stderr, msg_CantStartConn );
		COM_Close( hFile );
		return -1;
	}
	SendACK( hFile );

	/*J̎擾*/
	if( GetCameraInfo( hFile, sTmp ) != 0 ){
		fprintf( stderr, msg_CantGetCamInfo );
		EndConnection( hFile );
		COM_Close( hFile );
		return -1;
	}

	/*L^̎擾*/
	nImages = GetRecordInfo( hFile );
	if( nImages == 0 ){
		/*摜[ȂI*/
		fprintf( stderr, msg_CantGetImageNum );
		EndConnection( hFile );
		COM_Close( hFile );
		return -1;
	}
	else if( nImages < 0 ){
		/*摜擾łȂΏI*/
		fprintf( stderr, msg_CantGetImageNum );
		EndConnection( hFile );
		COM_Close( hFile );
		return -1;
	}
	fprintf( stderr, msg_CamInfo, sTmp+5, nImages );

	/*ʐMxIvV̓ǂݎ*/
	if( argc > 2 ){
		usBaud = atoi( argv[2] );
	}

	/*ʐMxݒ*/
	if( ChangeBaudrate( hFile, usBaud ) != 0 ){
		fprintf( stderr, msg_CantChangeBaud );
		EndConnection( hFile );
		COM_Close( hFile );
		return -1;
	}

	/*摜ԍw肪Ή摜M*/
	if( argc > 3 ){
		/*Ŏw肳ꂽԍ̉摜ɎM*/
		for( i = 3; i < argc; i++ ){
			if( atoi(argv[i]) > 0 ){
				if( GetImageName( hFile, atoi(argv[i]), sTmp ) == 0 ){
					fprintf( stdout, msg_Receiving, atoi(argv[i]), sTmp );
					if( GetImage( hFile, atoi(argv[i]), sTmp ) != 0 ){
						fprintf( stderr, msg_CantGetImage, atoi(argv[i]) );
					}
				}
			}
		}
	}
	/*摜ԍw肪ȂΉ摜t@C\*/
	else{
		asFilename = (CHAR*)malloc( 13*nImages );
		for( i = 1; i <= nImages; i++ ){
			fprintf( stderr, "%d\r", i );
			if( GetImageName( hFile, i, sTmp ) == 0 ){
				strcpy( asFilename+13*(i-1), sTmp );
			}
			else{
				strcpy( asFilename+13*(i-1), "N/A" );
			}
		}
		for( i = 0; i < nImages; i++ ){
			fprintf( stdout, "No.%2d:%s\n", i+1,asFilename+13*i );
		}
		free( asFilename );
	}

	EndConnection( hFile );
	COM_Close( hFile );

	return 0;
}
