/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;

public class FrameAnimator
extends Component
implements Runnable,
AdjustmentListener {
    double fps = 10.0;
    int w;
    int h;
    Image[] images;
    int current;
    int frames;
    transient Thread animate;
    boolean running = false;

    public FrameAnimator(int n, int n2, Component component) {
        this.demo(n, n2, component);
    }

    public FrameAnimator() {
    }

    public FrameAnimator(String[] stringArray, double d) {
        this.setFrames(stringArray);
        this.setFrameRate(d);
    }

    public FrameAnimator(File[] fileArray, double d) {
        this.setFrames(fileArray);
        this.setFrameRate(d);
    }

    public FrameAnimator(URL[] uRLArray, double d) {
        this.setFrames(uRLArray);
        this.setFrameRate(d);
    }

    public FrameAnimator(Image[] imageArray, double d) {
        this.setFrames(imageArray);
        this.setFrameRate(d);
    }

    public void setFrames(String[] stringArray) {
        this.stop();
        this.frames = stringArray.length;
        this.images = new Image[this.frames];
        int n = 0;
        while (n < this.frames) {
            block8: {
                Serializable serializable;
                block9: {
                    block7: {
                        try {
                            serializable = new File(stringArray[n]);
                            if (!((File)serializable).exists()) break block7;
                            this.images[n] = this.getToolkit().getImage(((File)serializable).getAbsolutePath());
                            break block8;
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        serializable = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + stringArray[n]);
                        if (!((File)serializable).exists()) break block9;
                        this.images[n] = this.getToolkit().getImage(((File)serializable).getAbsolutePath());
                        break block8;
                    }
                    catch (Exception exception) {}
                }
                try {
                    serializable = Util.getTopPanel(this).getClass().getResource(stringArray[n]);
                    this.images[n] = this.getToolkit().getImage((URL)serializable);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        this.current = 0;
        this.determineSize();
    }

    public void setFrames(File[] fileArray) {
        this.stop();
        this.frames = fileArray.length;
        this.images = new Image[this.frames];
        int n = 0;
        while (n < this.frames) {
            this.images[n] = this.getToolkit().getImage(fileArray[n].toString());
            ++n;
        }
        this.current = 0;
        this.determineSize();
    }

    public void setFrames(URL[] uRLArray) {
        this.stop();
        this.frames = uRLArray.length;
        this.images = new Image[this.frames];
        int n = 0;
        while (n < this.frames) {
            this.images[n] = this.getToolkit().getImage(uRLArray[n]);
            ++n;
        }
        this.current = 0;
        this.determineSize();
    }

    public void setFrames(Image[] imageArray) {
        this.stop();
        this.images = imageArray;
        this.current = 0;
        this.frames = imageArray.length;
        this.determineSize();
    }

    public double getFrameRate() {
        return this.fps;
    }

    public int getCurrentFrame() {
        return this.current;
    }

    public int getNumberOfFrames() {
        return this.frames;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void determineSize() {
        MediaTracker mediaTracker = new MediaTracker(this);
        int n = 0;
        while (n < this.frames) {
            if (this.images[n] != null) {
                mediaTracker.addImage(this.images[n], 0);
            }
            ++n;
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {}
        try {
            this.h = this.images[0].getHeight(this);
            this.w = this.images[0].getWidth(this);
            this.invalidate();
            this.getParent().validate();
            this.repaint();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.w, this.h);
    }

    public synchronized void setFrameRate(double d) {
        if (d <= 0.0) {
            return;
        }
        this.fps = d;
        if (this.animate != null && this.animate.isAlive()) {
            try {
                this.animate.stop();
                this.animate = new Thread(this);
                this.animate.start();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public synchronized void setCurrentFrame(int n) {
        if (n < 0 || n > this.frames - 1) {
            return;
        }
        this.current = n;
        this.repaint();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        try {
            graphics.drawImage(this.images[this.current], 0, 0, this);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep((long)(1000.0 / this.fps));
                this.current = this.current >= this.frames - 1 ? 0 : ++this.current;
                this.repaint();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void start() {
        if (this.animate == null) {
            this.animate = new Thread((Runnable)this, "FrameAnimator Thread");
        }
        try {
            if (this.animate.isAlive()) {
                this.animate.resume();
            } else {
                this.animate.start();
            }
            this.running = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void stop() {
        if (this.animate == null) {
            return;
        }
        try {
            this.animate.suspend();
            this.running = false;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void demo(int n, double d, Component component) {
        this.validate();
        Image[] imageArray = new Image[n];
        Font font = new Font("SanSerif", 1, 150);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        while (n3 < n) {
            imageArray[n3] = component.createImage(n2, n2);
            Graphics graphics = imageArray[n3].getGraphics();
            graphics.setFont(font);
            graphics.setColor(Color.blue);
            graphics.fillRect(0, 0, n2, n2);
            graphics.setColor(Color.red);
            int n4 = (n2 - fontMetrics.stringWidth(String.valueOf(n3))) / 2;
            int n5 = fontMetrics.getAscent() + (n2 - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2;
            graphics.drawString(String.valueOf(n3), n4, n5);
            graphics.dispose();
            ++n3;
        }
        this.setFrameRate(d);
        this.setFrames(imageArray);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: java FrameAnimator frames fps");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        Frame frame = new Frame("Test of FrameAnimator");
        frame.pack();
        FrameAnimator frameAnimator = new FrameAnimator(n, n2, frame);
        frame.add(frameAnimator);
        frame.pack();
        frame.show();
        frameAnimator.start();
    }

    public void addNotify() {
        super.addNotify();
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().addAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().addAdjustmentListener(this);
        }
    }

    public void removeNotify() {
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().removeAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().removeAdjustmentListener(this);
        }
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }
}

