/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;

public class UnavailableRangeUploadState
extends UploadState {
    private static final String INACTIVE_RETRY_AFTER = "3600";

    public UnavailableRangeUploadState(HTTPUploader uploader) {
        super(uploader);
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        IncompleteFileDesc ifd;
        String str = "HTTP/1.1 416 Requested Range Unavailable\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/plain\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: 0\r\n";
        ostream.write(str.getBytes());
        this.writeAlts(ostream);
        this.writeRanges(ostream);
        this.writeProxies(ostream);
        if (this.FILE_DESC != null && this.FILE_DESC instanceof IncompleteFileDesc && !(ifd = (IncompleteFileDesc)this.FILE_DESC).isActivelyDownloading()) {
            HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, INACTIVE_RETRY_AFTER, ostream);
        }
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

