/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimitReachedUploadState
extends UploadState {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$uploader$LimitReachedUploadState == null ? (class$com$limegroup$gnutella$uploader$LimitReachedUploadState = LimitReachedUploadState.class$("com.limegroup.gnutella.uploader.LimitReachedUploadState")) : class$com$limegroup$gnutella$uploader$LimitReachedUploadState);
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$LimitReachedUploadState;

    public LimitReachedUploadState(HTTPUploader uploader) {
        super(uploader);
        LOG.debug("creating limit reached state");
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        LOG.debug("writing headers");
        String str = "HTTP/1.1 503 Service Unavailable\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/plain\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + ERROR_MESSAGE.length + "\r\n";
        ostream.write(str.getBytes());
        this.writeProxies(ostream);
        this.writeAlts(ostream);
        if (this.FILE_DESC != null) {
            URN sha1 = this.FILE_DESC.getSHA1Urn();
            if (sha1 != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, !this.FILE_DESC.hasAlternateLocations() ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER, ostream);
                ostream.write(str.getBytes());
                this.writeRanges(ostream);
            } else {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, NO_ALT_LOCS_RETRY_AFTER, ostream);
            }
        }
        HTTPUtils.writeHeader(HTTPHeaderName.CONNECTION, ConstantHTTPHeaderValue.CLOSE_VALUE, ostream);
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        LOG.debug("writing body");
        ostream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

