/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class SimppManager {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$simpp$SimppManager == null ? (class$com$limegroup$gnutella$simpp$SimppManager = SimppManager.class$("com.limegroup.gnutella.simpp.SimppManager")) : class$com$limegroup$gnutella$simpp$SimppManager);
    private static SimppManager INSTANCE;
    private int _latestVersion;
    private static final String SIMPP_FILE = "simpp.xml";
    private static int MIN_VERSION;
    private byte[] _simppBytes;
    private String _propsStream;
    private final ProcessingQueue _processingQueue;
    static /* synthetic */ Class class$com$limegroup$gnutella$simpp$SimppManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimppManager() {
        block27: {
            block26: {
                block25: {
                    super();
                    problem = false;
                    raf = null;
                    this._processingQueue = new ProcessingQueue("Simpp Handling Queue");
                    try {
                        try {
                            file = new File(CommonUtils.getUserSettingsDir(), "simpp.xml");
                            raf = new RandomAccessFile(file, "r");
                            content = new byte[(int)raf.length()];
                            raf.readFully(content);
                            verifier = new SimppDataVerifier(content);
                            verified = false;
                            this._latestVersion = 0;
                            verified = verifier.verifySource();
                            if (!verified) {
                                SimppManager.LOG.debug("Unable to verify simpp message.");
                                problem = true;
                                var10_8 = null;
                                if (problem) {
                                    this._latestVersion = SimppManager.MIN_VERSION;
                                    this._propsStream = "";
                                    this._simppBytes = "".getBytes();
                                }
                                if (raf == null) return;
                                break block25;
                            }
                            parser = null;
                            try {
                                parser = new SimppParser(verifier.getVerifiedData());
                            }
                            catch (SAXException sx) {
                                SimppManager.LOG.error("Unable to parse simpp data on disk", sx);
                                problem = true;
                                var10_9 = null;
                                if (problem) {
                                    this._latestVersion = SimppManager.MIN_VERSION;
                                    this._propsStream = "";
                                    this._simppBytes = "".getBytes();
                                }
                                if (raf == null) return;
                                try {
                                    raf.close();
                                    return;
                                }
                                catch (IOException iox) {
                                    // empty catch block
                                }
                                return;
                            }
                            catch (IOException iox) {
                                SimppManager.LOG.error("IOX parsing simpp on disk", iox);
                                problem = true;
                                var10_10 = null;
                                if (problem) {
                                    this._latestVersion = SimppManager.MIN_VERSION;
                                    this._propsStream = "";
                                    this._simppBytes = "".getBytes();
                                }
                                if (raf == null) return;
                                ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl57:
                                // 1 sources

                                raf.close();
                                return;
lbl59:
                                // 1 sources

                                catch (IOException iox) {
                                    // empty catch block
                                }
                                return;
                            }
                            if (parser.getVersion() <= SimppManager.MIN_VERSION) {
                                SimppManager.LOG.error("Version below min on disk, aborting simpp.");
                                problem = true;
                                break block26;
                            }
                            this._latestVersion = parser.getVersion();
                            this._propsStream = parser.getPropsData();
                            this._simppBytes = content;
                            break block27;
                        }
                        catch (IOException iox) {
                            SimppManager.LOG.error("IOX reading simpp xml on disk", iox);
                            problem = true;
                            var10_13 = null;
                            if (problem) {
                                this._latestVersion = SimppManager.MIN_VERSION;
                                this._propsStream = "";
                                this._simppBytes = "".getBytes();
                            }
                            if (raf == null) return;
                            try {}
                            catch (IOException iox) {
                                return;
                            }
                            raf.close();
                            return;
                        }
                    }
                    catch (Throwable var9_25) {
                        var10_14 = null;
                        if (problem) {
                            this._latestVersion = SimppManager.MIN_VERSION;
                            this._propsStream = "";
                            this._simppBytes = "".getBytes();
                        }
                        if (raf == null) throw var9_25;
                        ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl95:
                        // 1 sources

                        raf.close();
                        throw var9_25;
lbl97:
                        // 1 sources

                        catch (IOException iox) {
                            // empty catch block
                        }
                        throw var9_25;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl102:
                // 1 sources

                raf.close();
                return;
lbl104:
                // 1 sources

                catch (IOException iox) {
                    // empty catch block
                }
                return;
            }
            var10_11 = null;
            if (problem) {
                this._latestVersion = SimppManager.MIN_VERSION;
                this._propsStream = "";
                this._simppBytes = "".getBytes();
            }
            if (raf == null) return;
            ** try [egrp 3[TRYBLOCK] [14 : 284->291)] { 
lbl115:
            // 1 sources

            raf.close();
            return;
lbl117:
            // 1 sources

            catch (IOException iox) {
                // empty catch block
            }
            return;
        }
        var10_12 = null;
        if (problem) {
            this._latestVersion = SimppManager.MIN_VERSION;
            this._propsStream = "";
            this._simppBytes = "".getBytes();
        }
        if (raf == null) return;
        try {}
        catch (IOException iox) {}
        raf.close();
        return;
    }

    public static synchronized SimppManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new SimppManager();
        }
        return INSTANCE;
    }

    public int getVersion() {
        return this._latestVersion;
    }

    public byte[] getSimppBytes() {
        return this._simppBytes;
    }

    public String getPropsString() {
        return this._propsStream;
    }

    public void checkAndUpdate(final byte[] simppPayload) {
        if (simppPayload == null) {
            return;
        }
        final int myVersion = this._latestVersion;
        Runnable simppHandler = new Runnable(){

            public void run() {
                SimppDataVerifier verifier = new SimppDataVerifier(simppPayload);
                if (!verifier.verifySource()) {
                    return;
                }
                SimppParser parser = null;
                try {
                    parser = new SimppParser(verifier.getVerifiedData());
                }
                catch (SAXException sx) {
                    LOG.error("SAX error reading network simpp", sx);
                    return;
                }
                catch (IOException iox) {
                    LOG.error("IOX parsing network simpp", iox);
                    return;
                }
                int version = parser.getVersion();
                if (version <= myVersion) {
                    LOG.error("Network simpp below current version, aborting.");
                    return;
                }
                SimppManager.this._latestVersion = version;
                SimppManager.access$202(SimppManager.this, simppPayload);
                SimppManager.this._propsStream = parser.getPropsData();
                String props = parser.getPropsData();
                SimppSettingsManager.instance().updateSimppSettings(props);
                for (int i = 0; i < 5 && !SimppManager.this.save(); ++i) {
                }
                CapabilitiesVM.reconstructInstance();
                RouterService.getConnectionManager().sendUpdatedCapabilities();
            }
        };
        this._processingQueue.add(simppHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save() {
        block20: {
            block19: {
                tmp = new File(CommonUtils.getUserSettingsDir(), "simpp.xml.tmp");
                simpp = new File(CommonUtils.getUserSettingsDir(), "simpp.xml");
                simppWriter = null;
                try {
                    try {
                        simppWriter = new BufferedOutputStream(new FileOutputStream(tmp));
                        simppWriter.write(this._simppBytes);
                        simppWriter.flush();
                    }
                    catch (IOException bad) {
                        var5_13 = false;
                        var7_5 = null;
                        if (simppWriter == null) return var5_13;
                        try {
                            simppWriter.close();
                            return var5_13;
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        return var5_13;
                    }
                    var7_4 = null;
                    if (simppWriter == null) break block19;
                }
                catch (Throwable var6_15) {
                    var7_6 = null;
                    if (simppWriter == null) throw var6_15;
                    ** try [egrp 2[TRYBLOCK] [4 : 87->94)] { 
lbl29:
                    // 1 sources

                    simppWriter.close();
                    throw var6_15;
lbl31:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw var6_15;
                }
                try {}
                catch (IOException ignored) {}
                simppWriter.close();
            }
            dis = null;
            data = new byte[this._simppBytes.length];
            try {
                try {
                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(tmp)));
                    dis.readFully(data);
                    if (Arrays.equals(data, this._simppBytes)) break block20;
                    var6_16 = false;
                    var10_18 = null;
                    if (dis == null) return var6_16;
                }
                catch (IOException bad) {
                    var7_7 = false;
                    var10_20 = null;
                    if (dis == null) return var7_7;
                    try {
                        dis.close();
                        return var7_7;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return var7_7;
                }
            }
            catch (Throwable var9_26) {
                var10_21 = null;
                if (dis == null) throw var9_26;
                ** try [egrp 5[TRYBLOCK] [10 : 194->202)] { 
lbl67:
                // 1 sources

                dis.close();
                throw var9_26;
lbl69:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
                throw var9_26;
            }
            try {}
            catch (IOException ignored) {
                // empty catch block
                return var6_16;
            }
            dis.close();
            return var6_16;
        }
        var10_19 = null;
        if (dis == null) return FileUtils.forceRename(tmp, simpp);
        try {}
        catch (IOException ignored) {}
        dis.close();
        return FileUtils.forceRename(tmp, simpp);
        return FileUtils.forceRename(tmp, simpp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ byte[] access$202(SimppManager x0, byte[] x1) {
        x0._simppBytes = x1;
        return x1;
    }

    static {
        MIN_VERSION = 3;
    }
}

