/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.AbstractNumberSetting;
import java.util.Properties;

public final class LongSetting
extends AbstractNumberSetting {
    private long value;

    LongSetting(Properties defaultProps, Properties props, String key, long defaultLong) {
        super(defaultProps, props, key, String.valueOf(defaultLong), null, null, null);
    }

    LongSetting(Properties defaultProps, Properties props, String key, long defaultLong, String simppSetting, long max, long min) {
        super(defaultProps, props, key, String.valueOf(defaultLong), simppSetting, new Long(max), new Long(min));
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        super.setValue(String.valueOf(value));
    }

    protected void loadValue(String sValue) {
        try {
            this.value = Long.parseLong(sValue.trim());
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    protected boolean isInRange(String value) {
        long max = (Long)this.MAX_VALUE;
        long min = (Long)this.MIN_VALUE;
        long val = Long.parseLong(value);
        return val <= max && val >= min;
    }
}

