/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.CompositeDragSourceListener;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DefaultDragSourceListener;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.tables.FileTransferable;
import com.limegroup.gnutella.gui.tables.LazyFileTransfer;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DragListener
implements DragGestureListener {
    private static final DragListener INSTANCE = new DragListener();

    public static final DragListener instance() {
        return INSTANCE;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Object recog;
        LinkedList l = new LinkedList();
        LinkedList lazy = new LinkedList();
        Component source = dge.getComponent();
        if (source instanceof LimeJTable) {
            this.fillFromTable(dge, l, lazy);
        } else if (source instanceof JTree) {
            this.fillFromTree(dge, l, lazy);
        } else {
            return;
        }
        if (l.size() == 0 && lazy.size() == 0) {
            return;
        }
        FileTransferable t = new FileTransferable(l, lazy);
        DragSourceListener listener = DefaultDragSourceListener.instance();
        if (!CommonUtils.isJava14OrLater() && (recog = ((JComponent)source).getClientProperty("limewire.dragRecognizer")) != null) {
            listener = new CompositeDragSourceListener(listener, (DragSourceListener)recog);
        }
        try {
            if (DragSource.isDragImageSupported()) {
                dge.startDrag(DragSource.DefaultCopyNoDrop, DragManager.createDragImage(t), new Point(2, 2), t, listener);
            } else {
                dge.startDrag(DragSource.DefaultCopyNoDrop, t, listener);
            }
        }
        catch (InvalidDnDOperationException ignored) {
            // empty catch block
        }
    }

    private void fillFromTable(DragGestureEvent dge, List l, List lazy) {
        LimeJTable table = (LimeJTable)dge.getComponent();
        DataLine[] lines = table.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            this.addFileTransfer((FileTransfer)((Object)lines[i]), l, lazy);
        }
    }

    private void fillFromTree(DragGestureEvent dge, List l, List lazy) {
        JTree tree = (JTree)dge.getComponent();
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            this.addFileTransfer((FileTransfer)path.getLastPathComponent(), l, lazy);
        }
    }

    private void addFileTransfer(FileTransfer transfer, List l, List lazy) {
        File f = transfer.getFile();
        if (f == null) {
            if (transfer instanceof LazyFileTransfer) {
                lazy.add(((LazyFileTransfer)transfer).getLazyFile());
            }
        } else {
            this.addFile(l, f);
        }
    }

    private void addFile(List l, File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        l.add(f);
    }
}

