/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.tables.DataLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TableRowFilter
extends ResultPanelModel {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$search$TableRowFilter == null ? (class$com$limegroup$gnutella$gui$search$TableRowFilter = TableRowFilter.class$("com.limegroup.gnutella.gui.search.TableRowFilter")) : class$com$limegroup$gnutella$gui$search$TableRowFilter);
    private final TableLineFilter FILTER;
    private final List HIDDEN;
    private int _numSources;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$TableRowFilter;

    public TableRowFilter(TableLineFilter f) {
        if (f == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = f;
        this.HIDDEN = new LinkedList();
        this._numSources = 0;
    }

    public int getFilteredSources() {
        return super.getTotalSources();
    }

    public int getTotalSources() {
        return this.getFilteredSources() + this._numSources;
    }

    public int add(DataLine line, int row) {
        TableLine tl = (TableLine)line;
        if (this.allow(tl)) {
            return super.add(line, row);
        }
        this.HIDDEN.add(tl);
        this._numSources += tl.getLocationCount();
        if (this._useMetadata) {
            this.METADATA.addNew(tl);
        }
        return -1;
    }

    protected void simpleClear() {
        this._numSources = 0;
        this.HIDDEN.clear();
        super.simpleClear();
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    private boolean allow(TableLine line) {
        return this.FILTER.allow(line);
    }

    private void rebuild() {
        int i;
        ArrayList existing = new ArrayList(this._list);
        ArrayList hidden = new ArrayList(this.HIDDEN);
        this.simpleClear();
        this.setUseMetadata(false);
        for (i = 0; i < existing.size(); ++i) {
            if (this.isSorted()) {
                this.addSorted((DataLine)existing.get(i));
                continue;
            }
            this.add((DataLine)existing.get(i));
        }
        for (i = 0; i < hidden.size(); ++i) {
            Iterator j;
            TableLine tl = (TableLine)hidden.get(i);
            SearchResult sr = (SearchResult)tl.getInitializeObject();
            sr.setAlts(tl.getAlts());
            List otherResults = tl.getOtherResults();
            if (this.isSorted()) {
                this.addSorted(sr);
                j = otherResults.iterator();
                while (j.hasNext()) {
                    this.addSorted(j.next());
                }
                continue;
            }
            this.add(sr);
            j = otherResults.iterator();
            while (j.hasNext()) {
                this.add(j.next());
            }
        }
        this.setUseMetadata(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

