/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.ListModelMap;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.SelectorMenu;
import com.limegroup.gnutella.gui.tables.CircularIcon;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.SortArrowIcon;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FilterBox
extends JPanel {
    private static final ListCellRenderer RENDERER = new Renderer();
    private static final ListSelectionListener MOVER = new Mover();
    private static final BooleanSetting STRIPE_ROWS = ResultPanel.SEARCH_SETTINGS.ROWSTRIPE;
    private static final String OPTIONS = GUIMediator.getStringResource("SEARCH_FILTER_OPTIONS");
    private static final String OPTION = GUIMediator.getStringResource("SEARCH_FILTER_OPTION");
    private static final String SELECTED = "SELECTION";
    private static final String MATCH = "MATCH";
    private static final String MATCH_IDX = "MATCH_IDX";
    private final Ditherer DITHERER = new Ditherer(10, ThemeFileHandler.FILTER_TITLE_TOP_COLOR.getValue(), ThemeFileHandler.FILTER_TITLE_COLOR.getValue());
    protected final JLabel TITLE;
    protected final JPanel TITLE_PANEL;
    protected final JList LIST;
    protected final JPanel LIST_PANEL;
    protected final ListModelDelegator DELEGATOR;
    protected final JLabel CONTROLS;
    protected final MetadataModel MODEL;
    protected final ChangeEvent EVENT = new ChangeEvent(this);
    protected Selector _selector;
    protected ChangeListener _selectorChangeListener;
    protected ChangeListener _stateChangeListener;
    private boolean _minimized = false;
    private boolean _canMinimize = true;
    private boolean _mouseClicked = false;
    private String _requestedValue;
    private String[] _requestedValues;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    FilterBox(MetadataModel model, Selector selector) {
        this.setLayout(new BorderLayout());
        if (model == null) {
            throw new NullPointerException("no model");
        }
        if (selector == null) {
            throw new NullPointerException("no selector");
        }
        this.CONTROLS = new JLabel();
        this.TITLE = new JLabel();
        this.TITLE.setFont(UIManager.getFont("Table.font.bold"));
        this.TITLE_PANEL = this.createTitlePanel(this.TITLE, this.CONTROLS);
        this.LIST = new JList();
        this.DELEGATOR = new ListModelDelegator();
        JScrollPane pane = new JScrollPane(this.LIST);
        this.LIST_PANEL = this.addToPanel(pane, false);
        this.MODEL = model;
        this.add((Component)this.TITLE_PANEL, "North");
        this.add((Component)this.LIST_PANEL, "Center");
        this.LIST.setBackground(ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue());
        this.LIST.setCellRenderer(RENDERER);
        this.LIST.addListSelectionListener(MOVER);
        this.LIST.setModel(this.DELEGATOR);
        this.LIST.setSelectionMode(0);
        this.LIST.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                FilterBox.this._mouseClicked = true;
                FilterBox.this.LIST.removeMouseListener(this);
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        pane.setHorizontalScrollBarPolicy(31);
        this.setSelector(selector);
    }

    JList getList() {
        return this.LIST;
    }

    JComponent getComponent() {
        if (this._minimized) {
            return this.TITLE_PANEL;
        }
        this.removeAll();
        this.add((Component)this.TITLE_PANEL, "North");
        this.add((Component)this.LIST_PANEL, "Center");
        return this;
    }

    void minimize() {
        this._minimized = true;
        this._selector.setMinimized(true);
        this.TITLE.setFont(UIManager.getFont("Table.font"));
        this.TITLE_PANEL.setBorder(this.getBorder());
        this.invalidate();
        this.CONTROLS.setIcon(SortArrowIcon.getAscendingIcon());
        this.updateTitle();
        this.revalidate();
        if (this._stateChangeListener != null) {
            this._stateChangeListener.stateChanged(this.EVENT);
        }
    }

    void restore() {
        this._minimized = false;
        this._selector.setMinimized(false);
        this.TITLE.setFont(UIManager.getFont("Table.font.bold"));
        this.TITLE_PANEL.setBorder(null);
        this.updateTitle();
        this.CONTROLS.setIcon(SortArrowIcon.getDescendingIcon());
        this.revalidate();
        if (this._stateChangeListener != null) {
            this._stateChangeListener.stateChanged(this.EVENT);
        }
    }

    void setCanMinimize(boolean allowed) {
        if (this._minimized) {
            return;
        }
        if (allowed) {
            this.CONTROLS.setIcon(SortArrowIcon.getDescendingIcon());
        } else {
            this.CONTROLS.setIcon(null);
        }
        this._canMinimize = allowed;
    }

    boolean isMinimized() {
        return this._minimized;
    }

    MetadataModel getMetadataModel() {
        return this.MODEL;
    }

    Selector getSelector() {
        return this._selector;
    }

    void setSelectorChangeListener(ChangeListener listener) {
        this._selectorChangeListener = listener;
    }

    void setStateChangeListener(ChangeListener listener) {
        this._stateChangeListener = listener;
    }

    void setSelector(Selector selector) {
        if (selector == null) {
            throw new NullPointerException("no selector");
        }
        this.LIST.putClientProperty(MATCH, null);
        this.LIST.putClientProperty(MATCH_IDX, null);
        this.LIST.putClientProperty(SELECTED, null);
        ListModelMap oldModel = this._selector == null ? null : this.MODEL.getListModelMap(this._selector);
        this._selector = selector;
        ListModelMap newModel = this.MODEL.getListModelMap(selector);
        this.setModel(newModel);
        this.DELEGATOR.changeListener(oldModel, newModel);
        if (selector.isMinimized()) {
            this.minimize();
        }
        if (this._selectorChangeListener != null) {
            this._selectorChangeListener.stateChanged(this.EVENT);
        }
        this.updateTitle();
    }

    /*
     * Unable to fully structure code
     */
    void updateTitle() {
        block4: {
            block3: {
                sel = this.getSelectedValue();
                title = FilterBox.getTitle(this._selector);
                oldTitle = this.TITLE.getText();
                if (this._minimized) break block3;
                this.TITLE.setText(title);
                break block4;
            }
            if (sel == null) ** GOTO lbl-1000
            if (MetadataModel.isAll(sel)) lbl-1000:
            // 2 sources

            {
                extra = (size = this.DELEGATOR.getSize() - 1) == 1 ? size + " " + FilterBox.OPTION : size + " " + FilterBox.OPTIONS;
            } else {
                extra = sel.toString();
            }
            this.TITLE.setText(title + " (" + extra + ")");
        }
        if (!oldTitle.equals(this.TITLE.getText())) {
            this.TITLE.setPreferredSize(new Dimension(GUIUtils.width(this.TITLE), 13));
        }
    }

    Object getSelectedValue() {
        int idx = this.LIST.getSelectedIndex();
        if (idx < 0 || idx >= this.DELEGATOR.getSize()) {
            return null;
        }
        return this.LIST.getSelectedValue();
    }

    void setRequestedValue(String value) {
        this._mouseClicked = false;
        this._requestedValue = value.trim().toLowerCase();
        this._requestedValues = StringUtils.split(this._requestedValue, ' ');
        this.selectValueFromScore();
    }

    void clearSelection() {
        this.LIST.putClientProperty(SELECTED, null);
        this.LIST.clearSelection();
    }

    void setModel(ListModelMap view) {
        Object selected = this.LIST.getClientProperty(SELECTED);
        this.DELEGATOR.setDelegate(view);
        if (selected != null) {
            int index = this.indexOf(selected);
            if (index != -1) {
                this.setSelectedIndex(index, true);
                this.selectMatchingValue(false);
            } else {
                this.LIST.clearSelection();
                this.selectMatchingValue(true);
            }
        } else {
            this.LIST.clearSelection();
            this.selectMatchingValue(true);
        }
        this.updateTitle();
    }

    ListModelMap getModel() {
        return this.DELEGATOR.getDelegate();
    }

    void addSelectionListener(ListDataListener ldl, ListSelectionListener lsl) {
        this.LIST.addListSelectionListener(lsl);
        this.DELEGATOR.addListDataListener(ldl);
    }

    protected JPanel createTitlePanel(JLabel title, JLabel controls) {
        title.setHorizontalAlignment(0);
        JLabel button = new JLabel(CircularIcon.instance());
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                JComponent source = (JComponent)e.getSource();
                SelectorMenu menu = new SelectorMenu(FilterBox.this);
                menu.getComponent().show(source, p.x + 1, p.y - 6);
            }
        });
        controls.setIcon(SortArrowIcon.getDescendingIcon());
        controls.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (FilterBox.this._minimized) {
                    FilterBox.this.restore();
                } else if (FilterBox.this._canMinimize) {
                    FilterBox.this.minimize();
                }
            }
        });
        DitherPanel panel = new DitherPanel(this.DITHERER);
        panel.setBackground(ThemeFileHandler.FILTER_TITLE_COLOR.getValue());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)button, c);
        c.anchor = 10;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 1, 0, 1);
        panel.add((Component)title, c);
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 5);
        panel.add((Component)controls, c);
        panel.setMaximumSize(new Dimension(9999999, CircularIcon.instance().getIconHeight() + 4));
        return panel;
    }

    protected JPanel addToPanel(JComponent comp, boolean opaque) {
        JPanel panel = new JPanel(new GridLayout());
        panel.add(comp);
        panel.setMaximumSize(comp.getMaximumSize());
        panel.setPreferredSize(comp.getPreferredSize());
        return panel;
    }

    private void selectValueFromScore() {
        if (this._requestedValue == null) {
            return;
        }
        ListModelMap map = this.DELEGATOR.getDelegate();
        int highScore = 0;
        int index = -1;
        String matchingValue = null;
        int i = 1;
        Iterator iter = map.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof String) {
                String val = (String)next;
                int score = this.score(val, highScore);
                if (score > highScore) {
                    highScore = score;
                    index = i;
                    matchingValue = val;
                }
                if (highScore == 100) {
                    this._mouseClicked = true;
                    break;
                }
            }
            ++i;
        }
        if (index != -1) {
            this.LIST.putClientProperty(MATCH, matchingValue);
            this.LIST.putClientProperty(MATCH_IDX, new Integer(index));
            this.LIST.ensureIndexIsVisible(index);
        }
    }

    private void selectMatchingValue(boolean scroll) {
        String match = (String)this.LIST.getClientProperty(MATCH);
        if (match != null) {
            int idx = this.indexOf(match);
            if (idx != -1) {
                this.LIST.putClientProperty(MATCH_IDX, new Integer(idx));
                if (scroll) {
                    this.LIST.ensureIndexIsVisible(idx);
                }
            } else {
                this.LIST.putClientProperty(MATCH_IDX, null);
            }
        }
    }

    private int indexOf(Object value) {
        ListModelMap view = this.DELEGATOR.getDelegate();
        if (view != null) {
            return view.indexOf(value);
        }
        return -1;
    }

    private void setSelectedIndex(int index, boolean scroll) {
        this.LIST.setSelectedIndex(index);
        if (scroll) {
            this.LIST.ensureIndexIsVisible(index);
        }
        this.LIST.repaint();
    }

    private int score(String value, int oldScore) {
        if (this._requestedValue.equals((value = value.toLowerCase()).trim())) {
            return 100;
        }
        if (oldScore > 99) {
            return 0;
        }
        if (value.indexOf(this._requestedValue) > -1) {
            return 99;
        }
        if (oldScore > 98) {
            return 0;
        }
        if (this._requestedValues.length == 1) {
            return 0;
        }
        if (this._requestedValues.length == oldScore) {
            return 0;
        }
        int matches = 0;
        for (int i = 0; i < this._requestedValues.length; ++i) {
            if (value.indexOf(this._requestedValues[i]) <= -1) continue;
            ++matches;
        }
        return matches;
    }

    private static String getTitle(Selector selector) {
        return selector.getTitle();
    }

    public static void clearRenderer() {
        Container parent = ((Component)((Object)RENDERER)).getParent();
        if (parent != null) {
            parent.remove((Component)((Object)RENDERER));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Mover
    implements ListSelectionListener {
        private Mover() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            JList source = (JList)event.getSource();
            int selIndex = source.getSelectedIndex();
            if (selIndex != -1) {
                source.ensureIndexIsVisible(selIndex);
                source.putClientProperty(FilterBox.SELECTED, source.getSelectedValue());
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int idx, boolean isSelected, boolean cellHasFocus) {
            Integer matchIdx = (Integer)list.getClientProperty(FilterBox.MATCH_IDX);
            boolean match = matchIdx != null && idx == matchIdx;
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setFont(UIManager.getFont("Table.font.bold"));
                this.setOpaque(true);
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                if (match) {
                    this.setFont(UIManager.getFont("Table.font.bold"));
                    this.setForeground(list.getForeground());
                } else {
                    this.setFont(UIManager.getFont("Table.font"));
                    this.setForeground(list.getForeground());
                }
                if (idx % 2 == 0 && STRIPE_ROWS.getValue()) {
                    this.setOpaque(true);
                    this.setBackground(ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue());
                } else {
                    this.setOpaque(false);
                }
            }
            if (value instanceof IconAndNameHolder) {
                IconAndNameHolder in = (IconAndNameHolder)value;
                this.setIcon(in.getIcon());
                this.setText(value == null ? "" : in.getName());
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private class ListModelDelegator
    extends AbstractListModel
    implements ListDataListener {
        private ListModelMap _delegate = null;

        private ListModelDelegator() {
        }

        void setDelegate(ListModelMap delegate) {
            if (this._delegate == delegate) {
                return;
            }
            this._delegate = delegate;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        void changeListener(ListModelMap oldModel, ListModelMap newModel) {
            if (oldModel != null) {
                oldModel.removeListDataListener(this);
            }
            newModel.addListDataListener(this);
        }

        ListModelMap getDelegate() {
            return this._delegate;
        }

        public int getSize() {
            if (this._delegate != null) {
                return this._delegate.getSize();
            }
            return 0;
        }

        public Object getElementAt(int idx) {
            if (this._delegate != null) {
                return this._delegate.getElementAt(idx);
            }
            return null;
        }

        public void intervalAdded(ListDataEvent e) {
            e = new ListDataEvent(this, e.getType(), e.getIndex0(), e.getIndex1());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? FilterBox.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                ((ListDataListener)listeners[i + 1]).intervalAdded(e);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            e = new ListDataEvent(this, e.getType(), e.getIndex0(), e.getIndex1());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? FilterBox.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
            }
        }

        public void contentsChanged(ListDataEvent e) {
            e = new ListDataEvent(this, e.getType(), e.getIndex0(), e.getIndex1());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? FilterBox.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                ((ListDataListener)listeners[i + 1]).contentsChanged(e);
            }
            if (!FilterBox.this._mouseClicked && FilterBox.this._requestedValue != null) {
                FilterBox.this.selectValueFromScore();
            } else {
                boolean matching = FilterBox.this.LIST.getClientProperty(FilterBox.MATCH) != null;
                Object selected = FilterBox.this.LIST.getClientProperty(FilterBox.SELECTED);
                if (selected != null) {
                    FilterBox.this.setSelectedIndex(FilterBox.this.indexOf(selected), true);
                    if (matching) {
                        FilterBox.this.selectMatchingValue(false);
                    }
                } else if (matching) {
                    FilterBox.this.selectMatchingValue(true);
                }
            }
            FilterBox.this.updateTitle();
        }
    }
}

