/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.options.OptionsConstructor;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.SettingsHandler;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public final class OptionsMediator
implements ThemeObserver {
    public static final String ROOT_NODE_KEY = "OPTIONS_ROOT_NODE";
    private static final OptionsMediator INSTANCE = new OptionsMediator();
    private static OptionsPaneManager _paneManager = null;
    private static OptionsConstructor _constructor = null;
    private boolean _saveDirectoryChanged = false;

    public static synchronized OptionsMediator instance() {
        return INSTANCE;
    }

    private OptionsMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_OPTIONS_WINDOW"));
        ThemeMediator.addThemeObserver(this);
    }

    public final void setOptionsVisible(boolean visible) {
        if (_constructor == null) {
            if (!visible) {
                return;
            }
            this.updateTheme();
        }
        this._saveDirectoryChanged = false;
        _paneManager.initOptions();
        _constructor.setOptionsVisible(visible);
    }

    public final boolean isOptionsVisible() {
        if (_constructor == null) {
            return false;
        }
        return _constructor.isOptionsVisible();
    }

    public final String getString(String key) {
        return GUIMediator.getStringResource(key);
    }

    public final ImageIcon getImage(String imageName) {
        return GUIMediator.getThemeImage(imageName);
    }

    public final void handleSelection(String key) {
        _paneManager.show(key);
    }

    public final void applyOptions() throws IOException {
        _paneManager.applyOptions();
        SettingsHandler.save();
    }

    public final boolean isDirty() {
        return _paneManager.isDirty();
    }

    public final void revertOptions() {
        SettingsHandler.revertToDefault();
        GUIMediator.showMessage("OPTIONS_RESTART_REQUIRED");
    }

    public boolean getSaveDirectoryChanged() {
        return this._saveDirectoryChanged;
    }

    public void setSaveDirectoryChanged(boolean directoryChanged) {
        this._saveDirectoryChanged = directoryChanged;
    }

    public JDialog getMainOptionsComponent() {
        if (_constructor == null) {
            this.updateTheme();
        }
        return _constructor.getMainOptionsComponent();
    }

    public void updateTheme() {
        _paneManager = new OptionsPaneManager();
        _constructor = new OptionsConstructor(new OptionsTreeManager(), _paneManager);
    }
}

