/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.UploadCountHolder;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.MetaFileManager;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class LibraryTableDataLine
extends AbstractDataLine
implements ThemeObserver,
FileTransfer {
    private static final Integer ZERO_INTEGER = new Integer(0);
    private static final UploadCountHolder ZERO_UPLOAD_COUNT_HOLDER = new UploadCountHolder(0, 0);
    private static boolean _allowXML;
    private static String[] _schemas;
    private static MetaFileManager _mfm;
    static final int ICON_IDX = 0;
    private static final LimeTableColumn ICON_COLUMN;
    static final int NAME_IDX = 1;
    private static final LimeTableColumn NAME_COLUMN;
    static final int SIZE_IDX = 2;
    private static final LimeTableColumn SIZE_COLUMN;
    static final int TYPE_IDX = 3;
    private static final LimeTableColumn TYPE_COLUMN;
    static final int PATH_IDX = 4;
    private static final LimeTableColumn PATH_COLUMN;
    static final int UPLOADS_IDX = 5;
    private static final LimeTableColumn UPLOADS_COLUMN;
    static final int HITS_IDX = 6;
    private static final LimeTableColumn HITS_COLUMN;
    static final int ALT_LOC_IDX = 7;
    private static final LimeTableColumn ALT_LOC_COLUMN;
    static final int LICENSE_IDX = 8;
    private static final LimeTableColumn LICENSE_COLUMN;
    static final int NUMBER_OF_COLUMNS = 9;
    private File _file;
    private String _name;
    private String _type;
    private int _size;
    private FileDesc _fileDesc;
    private String _path;
    private Color _cellColor;
    private Color _othercellColor;
    private final LibraryTableModel _model;
    private boolean _iconLoaded = false;
    private boolean _iconScheduledForLoad = false;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ColoredCell;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$UploadCountHolder;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$License;

    public LibraryTableDataLine(LibraryTableModel ltm) {
        this._model = ltm;
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    public void cleanup() {
        ThemeMediator.removeThemeObserver(this);
    }

    public void updateTheme() {
        this._cellColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
        this._othercellColor = ThemeFileHandler.NOT_SHARING_LABEL_COLOR.getValue();
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    public int getColumnCount() {
        return 9;
    }

    public void initialize(Object o) {
        File file;
        if (o instanceof FileDesc) {
            file = ((FileDesc)o).getFile();
            this._fileDesc = (FileDesc)o;
        } else {
            file = (File)o;
            this._fileDesc = null;
        }
        super.initialize(file);
        String fullPath = file.getPath();
        try {
            fullPath = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this._file = file;
        this._name = this._file.getName();
        this._type = "";
        int index = this._name.lastIndexOf(".");
        int index2 = fullPath.lastIndexOf(File.separator);
        this._path = fullPath.substring(0, index2);
        if (index != -1 && index != 0) {
            this._type = this._name.substring(index + 1);
            this._name = this._name.substring(0, index);
        }
        this._size = (int)file.length();
    }

    public void changeFile(File newFile) {
        FileDesc tmpFD = this._fileDesc;
        this.initialize(newFile);
        this._fileDesc = tmpFD;
    }

    public File getFile() {
        return this._file;
    }

    public Object getValueAt(int idx) {
        switch (idx) {
            case 0: {
                if (!this._iconScheduledForLoad) {
                    this._iconScheduledForLoad = true;
                    GUIMediator.instance().schedule(new Runnable(){

                        public void run() {
                            GUIMediator.safeInvokeAndWait(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    IconManager.instance().getIconForFile(LibraryTableDataLine.access$100(1.access$000(this.this$1)));
                                    LibraryTableDataLine.access$202(1.access$000(this.this$1), true);
                                    LibraryTableDataLine.access$300(1.access$000(this.this$1)).refresh();
                                }
                            });
                        }

                        static /* synthetic */ LibraryTableDataLine access$000(1 x0) {
                            return x0.LibraryTableDataLine.this;
                        }
                    });
                    return null;
                }
                if (this._iconLoaded) {
                    return IconManager.instance().getIconForFile(this._file);
                }
                return null;
            }
            case 1: {
                String nm = this._name;
                if (LibraryMediator.instance().incompleteDirectoryIsSelected()) {
                    try {
                        nm = IncompleteFileManager.getCompletedName(this._file);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                return new ColoredCellImpl(nm, this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 2: {
                return new ColoredCellImpl(new SizeHolder(this._size), this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 3: {
                return new ColoredCellImpl(this._type, this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 6: {
                if (this._fileDesc == null) {
                    return null;
                }
                int hits = this._fileDesc.getHitCount();
                return hits == 0 ? ZERO_INTEGER : new Integer(hits);
            }
            case 7: {
                if (this._fileDesc == null) {
                    return null;
                }
                int locs = this._fileDesc.getAltLocsSize() - 1;
                return locs <= 0 ? ZERO_INTEGER : new Integer(locs);
            }
            case 5: {
                if (this._fileDesc == null) {
                    return null;
                }
                int a = this._fileDesc.getAttemptedUploads();
                int c = this._fileDesc.getCompletedUploads();
                return a == 0 && c == 0 ? ZERO_UPLOAD_COUNT_HOLDER : new UploadCountHolder(a, c);
            }
            case 4: {
                return new ColoredCellImpl(this._path, this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 8: {
                License lc = this.getLicense();
                if (lc != null) {
                    if (lc.isValid(this._fileDesc.getSHA1Urn())) {
                        return new Integer(2);
                    }
                    return new Integer(0);
                }
                return null;
            }
        }
        return null;
    }

    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return ICON_COLUMN;
            }
            case 1: {
                return NAME_COLUMN;
            }
            case 2: {
                return SIZE_COLUMN;
            }
            case 3: {
                return TYPE_COLUMN;
            }
            case 4: {
                return PATH_COLUMN;
            }
            case 6: {
                return HITS_COLUMN;
            }
            case 7: {
                return ALT_LOC_COLUMN;
            }
            case 5: {
                return UPLOADS_COLUMN;
            }
            case 8: {
                return LICENSE_COLUMN;
            }
        }
        return null;
    }

    public boolean isClippable(int idx) {
        switch (idx) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    public int getTypeAheadColumn() {
        return 1;
    }

    public boolean isDynamic(int idx) {
        switch (idx) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    static void setXMLEnabled(boolean en) {
        _allowXML = en;
        if (_allowXML) {
            _schemas = LimeXMLSchemaRepository.instance().getAvailableSchemaURIs();
            FileManager fm = RouterService.getFileManager();
            if (fm instanceof MetaFileManager) {
                _mfm = (MetaFileManager)fm;
            }
        } else {
            _schemas = null;
            _mfm = null;
        }
    }

    boolean isLicensed() {
        return this._fileDesc != null && this._fileDesc.isLicensed();
    }

    License getLicense() {
        return this._fileDesc != null ? this._fileDesc.getLicense() : null;
    }

    public String[] getToolTipArray(int col) {
        if (!_allowXML || _schemas == null || _schemas.length == 0 || _mfm == null || this._fileDesc == null) {
            return null;
        }
        LinkedList<String> data = new LinkedList<String>();
        boolean found = false;
        DisplayManager dm = DisplayManager.instance();
        List docs = this._fileDesc.getLimeXMLDocuments();
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            LimeXMLDocument doc = (LimeXMLDocument)i.next();
            String schemaDesc = doc.getSchemaDescription();
            List nameValues = doc.getOrderedNameValueList();
            Iterator j = nameValues.iterator();
            while (j.hasNext()) {
                found = true;
                NameValue nv = (NameValue)j.next();
                data.add(dm.getDisplayName(nv.getName(), schemaDesc) + ": " + nv.getValue());
            }
        }
        if (found) {
            data.add(0, this._name);
            return data.toArray(new String[data.size()]);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ File access$100(LibraryTableDataLine x0) {
        return x0._file;
    }

    static /* synthetic */ boolean access$202(LibraryTableDataLine x0, boolean x1) {
        x0._iconLoaded = x1;
        return x0._iconLoaded;
    }

    static /* synthetic */ LibraryTableModel access$300(LibraryTableDataLine x0) {
        return x0._model;
    }

    static {
        ICON_COLUMN = new LimeTableColumn(0, "LIBRARY_TABLE_ICON", GUIMediator.getThemeImage("question_mark"), 18, true, class$javax$swing$Icon == null ? (class$javax$swing$Icon = LibraryTableDataLine.class$("javax.swing.Icon")) : class$javax$swing$Icon);
        NAME_COLUMN = new LimeTableColumn(1, "LIBRARY_TABLE_NAME", 239, true, class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell);
        SIZE_COLUMN = new LimeTableColumn(2, "LIBRARY_TABLE_SIZE", 62, true, class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell);
        TYPE_COLUMN = new LimeTableColumn(3, "LIBRARY_TABLE_TYPE", 48, true, class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell);
        PATH_COLUMN = new LimeTableColumn(4, "LIBRARY_TABLE_PATH", 108, true, class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell);
        UPLOADS_COLUMN = new LimeTableColumn(5, "LIBRARY_TABLE_UPLOAD_COUNT", 62, true, class$com$limegroup$gnutella$gui$tables$UploadCountHolder == null ? (class$com$limegroup$gnutella$gui$tables$UploadCountHolder = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.UploadCountHolder")) : class$com$limegroup$gnutella$gui$tables$UploadCountHolder);
        HITS_COLUMN = new LimeTableColumn(6, "LIBRARY_TABLE_HITCOUNT", 39, true, class$java$lang$Integer == null ? (class$java$lang$Integer = LibraryTableDataLine.class$("java.lang.Integer")) : class$java$lang$Integer);
        ALT_LOC_COLUMN = new LimeTableColumn(7, "LIBRARY_TABLE_NUMALTLOC", 72, true, class$java$lang$Integer == null ? (class$java$lang$Integer = LibraryTableDataLine.class$("java.lang.Integer")) : class$java$lang$Integer);
        LICENSE_COLUMN = new LimeTableColumn(8, "LIBRARY_TABLE_LICENSE", 20, true, class$com$limegroup$gnutella$licenses$License == null ? (class$com$limegroup$gnutella$licenses$License = LibraryTableDataLine.class$("com.limegroup.gnutella.licenses.License")) : class$com$limegroup$gnutella$licenses$License);
    }
}

