/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusComponent
extends JPanel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    private final int POSITION;
    private final JProgressBar BAR;
    private final JLabel LABEL;

    public StatusComponent(int orientation) {
        this.setLayout(new BoxLayout(this, 1));
        this.POSITION = orientation;
        this.LABEL = new JLabel();
        if (CommonUtils.isJava14OrLater()) {
            this.BAR = new JProgressBar();
            this.BAR.setIndeterminate(true);
        } else {
            this.BAR = null;
        }
        this.construct();
        GUIUtils.setOpaque(false, this);
        if (this.BAR != null && !CommonUtils.isMacOSX()) {
            this.BAR.setOpaque(true);
        }
        if (this.LABEL != null) {
            this.LABEL.setForeground(ThemeFileHandler.WINDOW4_COLOR.getValue());
        }
    }

    public void setProgressPreferredSize(Dimension dim) {
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        if (this.BAR != null) {
            this.BAR.setMinimumSize(dim);
            this.BAR.setMaximumSize(dim);
            this.BAR.setPreferredSize(dim);
        }
    }

    public void setText(String text) {
        if (CommonUtils.isJava14OrLater() && !CommonUtils.isMacOSX()) {
            this.BAR.setString(text);
        } else {
            FontMetrics fm = this.LABEL.getFontMetrics(this.LABEL.getFont());
            this.LABEL.setPreferredSize(new Dimension(fm.stringWidth(text), fm.getHeight()));
            this.LABEL.setText(text);
        }
    }

    private void construct() {
        if (CommonUtils.isJava14OrLater()) {
            if (CommonUtils.isMacOSX()) {
                BoxPanel textPanel = new BoxPanel(0);
                textPanel.add(this.LABEL);
                textPanel.add(Box.createHorizontalGlue());
                this.add(textPanel);
            } else {
                this.BAR.setStringPainted(true);
            }
            this.add(this.BAR);
        } else {
            BoxPanel textPanel = new BoxPanel(0);
            if (this.POSITION == 2) {
                textPanel.add(Box.createHorizontalGlue());
                textPanel.add(this.LABEL);
                textPanel.add(Box.createHorizontalGlue());
            } else if (this.POSITION == 0) {
                textPanel.add(this.LABEL);
                textPanel.add(Box.createHorizontalGlue());
            } else if (this.POSITION == 1) {
                textPanel.add(Box.createHorizontalGlue());
                textPanel.add(this.LABEL);
            }
            this.add(textPanel);
        }
    }
}

