/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.bugs.BugManager;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.DefaultErrorCatcher;
import com.limegroup.gnutella.gui.ErrorHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GURLHandler;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MessageHandler;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.VisualConnectionCallback;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.SystemUtils;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Initializer {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$Initializer == null ? (class$com$limegroup$gnutella$gui$Initializer = Initializer.class$("com.limegroup.gnutella.gui.Initializer")) : class$com$limegroup$gnutella$gui$Initializer);
    private static volatile boolean isStartup = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$Initializer;

    private Initializer() {
    }

    static void initialize(String[] args, Frame awtSplash) throws Throwable {
        File userDir;
        long startMemory = 0L;
        if (LOG.isTraceEnabled()) {
            startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            LOG.trace("START Initializer, using: " + startMemory + " memory");
        }
        if ((userDir = new File(System.getProperty("user.dir", ""))).exists()) {
            FileUtils.setWriteable(userDir);
        }
        FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        ErrorService.setErrorCallback(new ErrorHandler());
        MessageService.setCallback(new MessageHandler());
        DefaultErrorCatcher.install();
        if (CommonUtils.isMacOSX()) {
            LOG.trace("START registering OSX events");
            GURLHandler.getInstance().register();
            SystemUtils.setOpenFileLimit(1024);
            LOG.trace("STOP registering OSX events");
            if (CommonUtils.isJava14OrLater() && ThemeSettings.isBrushedMetalTheme()) {
                System.setProperty("apple.awt.brushMetalLook", "true");
            }
            LOG.trace("START MacEventHandler");
            MacEventHandler.instance();
            LOG.trace("STOP MacEventHandler");
        }
        if (args.length >= 2 && "-pmf".equals(args[0])) {
            PackagedMediaFileLauncher.launchFile(args[1], false);
            return;
        }
        if (StartupSettings.RUN_ON_STARTUP.getValue()) {
            LOG.trace("START yield");
            Thread.yield();
            LOG.trace("STOP yield");
        }
        if (args.length >= 1 && "-startup".equals(args[0])) {
            isStartup = true;
        }
        if (isStartup && !StartupSettings.RUN_ON_STARTUP.getValue()) {
            System.exit(0);
        }
        String arg = null;
        LOG.trace("START magnet check");
        if (args.length > 0 && !args[0].equals("-startup")) {
            arg = ExternalControl.preprocessArgs(args);
            ExternalControl.checkForActiveLimeWire(arg);
            ExternalControl.enqueueMagnetRequest(arg);
        } else if (!StartupSettings.ALLOW_MULTIPLE_INSTANCES.getValue()) {
            ExternalControl.checkForActiveLimeWire();
        }
        LOG.trace("STOP magnet check");
        LOG.trace("START system properties");
        Initializer.setSystemProperties();
        Initializer.setOSXSystemProperties();
        LOG.trace("STOP system properties");
        SetupManager setupManager = new SetupManager();
        if (!setupManager.shouldShowFirewallWindow() && CommonUtils.isJava14OrLater() && !ConnectionSettings.DISABLE_UPNP.getValue()) {
            LOG.trace("START UPnPManager");
            UPnPManager.instance().start();
            LOG.trace("STOP UPnPManager");
        }
        LOG.trace("START ResourceManager");
        ResourceManager.instance();
        LOG.trace("STOP ResourceManager");
        if (!isStartup) {
            SplashWindow.instance().begin();
        }
        if (awtSplash != null) {
            awtSplash.dispose();
        }
        LOG.trace("START VisualConnectionCallback");
        VisualConnectionCallback ac = new VisualConnectionCallback();
        LOG.trace("STOP VisualConnectionCallback");
        LOG.trace("START new RouterService");
        RouterService routerService = new RouterService(ac);
        if (!setupManager.shouldShowFirewallWindow()) {
            RouterService.asyncGuiInit();
        }
        LOG.trace("STOP new RouterService");
        LOG.trace("START HTML");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_HTML_ENGINE"));
        BasicHTML.createHTMLView(new JLabel(), "<html>.</html>");
        LOG.trace("STOP HTML");
        LOG.trace("START BugManager");
        BugManager.instance();
        LOG.trace("STOP BugManager");
        LOG.trace("START SetupManager");
        setupManager.createIfNeeded();
        LOG.trace("STOP SetupManager");
        LOG.trace("START SaveDirectoryHandler");
        SaveDirectoryHandler.handleSaveDirectory();
        LOG.trace("STOP SaveDirectoryHandler");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_INTERFACE"));
        LOG.trace("START GUIMediator.instance()");
        GUIMediator mediator = GUIMediator.instance();
        LOG.trace("STOP GUIMediator.instance()");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_CORE_COMPONENTS"));
        mediator.setRouterService(routerService);
        LOG.trace("START NotifyUserProxy");
        NotifyUserProxy notifyProxy = NotifyUserProxy.instance();
        notifyProxy.hideNotify();
        LOG.trace("STOP NotifyUserProxy");
        if (!isStartup) {
            SplashWindow.instance().dispose();
        }
        GUIMediator.allowVisibility();
        if (!isStartup) {
            LOG.trace("START setAppVisible");
            GUIMediator.setAppVisible(true);
            LOG.trace("STOP setAppVisible");
        } else {
            LOG.trace("START startupHidden");
            GUIMediator.startupHidden();
            LOG.trace("STOP startupHidden");
        }
        LOG.trace("START IconManager.instance()");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_ICONS"));
        IconManager.instance();
        LOG.trace("STOP IconManager.instance()");
        LOG.trace("START I18NConvert.instance()");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_I18N"));
        I18NConvert.instance();
        LOG.trace("STOP I18NConvert.instance()");
        LOG.trace("START RouterService");
        routerService.start();
        LOG.trace("STOP RouterService");
        mediator.startTimer();
        ExternalControl.runQueuedMagnetRequest();
        if (CommonUtils.isJava14OrLater() && DaapSettings.DAAP_ENABLED.getValue()) {
            LOG.trace("START DaapManager");
            try {
                GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_DAAP"));
                DaapManager.instance().start();
                DaapManager.instance().init();
            }
            catch (IOException err) {
                GUIMediator.showError("ERROR_DAAP_START_FAILED");
                DaapSettings.DAAP_ENABLED.setValue(false);
            }
            LOG.trace("STOP DaapManager");
        }
        GUIMediator.instance().loadFinished();
        if (CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater()) {
            UIManager.put("ProgressBar.repaintInterval", new Integer(500));
        }
        if (LOG.isTraceEnabled()) {
            long stopMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            LOG.trace("STOP Initializer, using: " + stopMemory + " memory, consumed: " + (stopMemory - startMemory));
        }
    }

    static void setStartup() {
        isStartup = true;
    }

    static void setSystemProperties() {
        System.setProperty("http.agent", CommonUtils.getHttpServer());
    }

    static void setOSXSystemProperties() {
        if (!CommonUtils.isMacOSX()) {
            return;
        }
        if (CommonUtils.isJava14OrLater()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        } else {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "LimeWire");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

