/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import java.awt.IllegalComponentStateException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DefaultErrorCatcher {
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$DefaultErrorCatcher;

    static void install() {
        System.setProperty("sun.awt.exception.handler", (class$com$limegroup$gnutella$gui$DefaultErrorCatcher == null ? (class$com$limegroup$gnutella$gui$DefaultErrorCatcher = DefaultErrorCatcher.class$("com.limegroup.gnutella.gui.DefaultErrorCatcher")) : class$com$limegroup$gnutella$gui$DefaultErrorCatcher).getName());
    }

    public void handle(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String bug = sw.toString();
        if (!this.isIgnorable(ex, bug)) {
            ErrorService.error(ex, "Uncaught event-thread error.");
        } else {
            System.err.println("Ignoring error:");
            ex.printStackTrace();
        }
    }

    private boolean isIgnorable(Throwable bug, String msg) {
        if (bug instanceof StackOverflowError) {
            return true;
        }
        if (bug instanceof OutOfMemoryError) {
            return true;
        }
        if (msg == null) {
            return true;
        }
        if (msg.indexOf("javax.swing.RepaintManager") != -1) {
            return true;
        }
        if (msg.indexOf("sun.awt.RepaintArea.paint") != -1) {
            return true;
        }
        if (bug instanceof ArrayIndexOutOfBoundsException) {
            if (msg.indexOf("apple.awt.CWindow.displayChanged") != -1) {
                return true;
            }
            if (msg.indexOf("javax.swing.plaf.basic.BasicTabbedPaneUI.getTabBounds") != -1) {
                return true;
            }
        }
        if (bug instanceof IllegalStateException && msg.indexOf("cannot open system clipboard") != -1) {
            return true;
        }
        if (bug instanceof IllegalComponentStateException && msg.indexOf("component must be showing on the screen to determine its location") != -1) {
            return true;
        }
        if (bug instanceof NullPointerException) {
            if (msg.indexOf("MetalFileChooserUI") != -1) {
                return true;
            }
            if (msg.indexOf("WindowsFileChooserUI") != -1) {
                return true;
            }
            if (msg.indexOf("AquaDirectoryModel") != -1) {
                return true;
            }
            if (msg.indexOf("SizeRequirements.calculateAlignedPositions") != -1) {
                return true;
            }
            if (msg.indexOf("BasicTextUI.damageRange") != -1) {
                return true;
            }
            if (msg.indexOf("null pData") != -1) {
                return true;
            }
            if (msg.indexOf("disposed component") != -1) {
                return true;
            }
        }
        if (bug instanceof InternalError && msg.indexOf("getGraphics not implemented for this component") != -1) {
            return true;
        }
        if (msg.indexOf("com.limegroup.gnutella") == -1) {
            return true;
        }
        if (this.intercepts(msg, "com.limegroup.gnutella.tables.MouseEventConsumptionChecker")) {
            return true;
        }
        return this.intercepts(msg, "com.limegroup.gnutella.gui.tables.LimeJTable.processMouseEvent");
    }

    private boolean intercepts(String msg, String inter) {
        int i = msg.indexOf(inter);
        if (i == -1) {
            return false;
        }
        if (msg.lastIndexOf("com.limegroup.gnutella", i) != -1) {
            return false;
        }
        if ((i += inter.length()) >= msg.length()) {
            return false;
        }
        return msg.indexOf("com.limegroup.gnutella", i) == -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

