/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import java.util.EventObject;

public class FileManagerEvent
extends EventObject {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int RENAME = 3;
    public static final int CHANGE = 4;
    private final int kind;
    private final FileDesc[] files;

    public FileManagerEvent(FileManager manager, int kind) {
        this(manager, kind, null);
    }

    public FileManagerEvent(FileManager manager, int kind, FileDesc[] files) {
        super(manager);
        this.kind = kind;
        this.files = files;
    }

    public int getKind() {
        return this.kind;
    }

    public FileDesc[] getFileDesc() {
        return this.files;
    }

    public boolean isAddEvent() {
        return this.kind == 1;
    }

    public boolean isRemoveEvent() {
        return this.kind == 2;
    }

    public boolean isRenameEvent() {
        return this.kind == 3;
    }

    public boolean isChangeEvent() {
        return this.kind == 4;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("FileManagerEvent: [event=");
        switch (this.kind) {
            case 1: {
                buffer.append("ADD");
                break;
            }
            case 2: {
                buffer.append("REMOVE");
                break;
            }
            case 3: {
                buffer.append("RENAME");
                break;
            }
            case 4: {
                buffer.append("CHANGE");
                break;
            }
            default: {
                buffer.append("UNKNOWN");
            }
        }
        if (this.files != null) {
            buffer.append(", files=").append(this.files.length).append("\n");
            for (int i = 0; i < this.files.length; ++i) {
                buffer.append(this.files[i]);
            }
        } else {
            buffer.append(", files=null");
        }
        return buffer.append("]").toString();
    }
}

