/* REXX installation script for Keyboard Layout Editor */
/* Copyright (C) 1998 by BigVic & Kolosoft Group */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*-------------------------- Initialization ------------------------------*/
installdir = directory()

if GetYesNo( "Install Keyboard Layout Editor in "installdir ) == 0 then
   exit


/*------------------------- Create Keyboard Layout Editor folder ---------------------*/

param='ICONFILE='installdir'\finstfl.ICO;OBJECTID=<PMKED_FLD>;ALWAYSSORT=Yes;ICONVIEWPOS=25,25,45,30'
rc = SysCreateObject( "WPFolder","Keyboard Layout Editor","<WP_DESKTOP>",param,"REPLACE" )
if rc then
   say "Keyboard Layout Editor folder successfully created on desktop..."
else
   say "ERROR: Keyboard Layout Editor folder creating failed!"

/*------------------- Create Keyboard Layout Editor object ---------------------------*/

param='ICONFILE='installdir'\pmked.ICO;OBJECTID=<PMKED_EXE>;EXENAME='installdir'\pmked.EXE;STARTUPDIR='installdir
rc = SysCreateObject( "WPProgram", "Keyboard Layout Editor", "<PMKED_FLD>",param,"REPLACE" )

if rc then
   say "Keyboard Layout Editor object successfully created..."
else 
   say "ERROR: Keyboard Layout Editor object creating failed!"


/*--------------- Create Keyboard Layout Editor Uninstall object -----------------------*/

param='ICONFILE='installdir'\funinst.ICO;EXENAME=*;PROGTYPE=PM;PARAMETERS=/C 'installdir'\funinst.CMD;STARTUPDIR='installdir
rc = SysCreateObject( "WPProgram", "Uninstall Keyboard Layout Editor", "<PMKED_FLD>",param,'REPLACE')

if rc then
   say "Uninstall object successfully created..."
else 
   say "ERROR: Uninstall object creating failed!"


/*-------------------------- Install DC User Pack Information -----------------*/
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='installdir';PARAMETERS='installdir'\pmked.INF'
rc = SysCreateObject("WPProgram","Keyboard Layout Editor Reference","<PMKED_FLD>",param,'REPLACE')

exit

GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Sorry. Please enter "Y" or "N".'
      end
   end

return (reply = "Y")
