/****************************************************************************
 * Copyright Notice:                                                        *
 *  (c) Copyright 1992 by Kurt Westerfeld.  ALL RIGHTS RESERVED.            *
 *      This work protected by US Copyright Law.
 *  You may not create derived works from this material.                    *
 ****************************************************************************
 * $Header: D:\Src\kwqmail\RCS\install.cmd 1.2 1993/06/09 11:28:19 kurt Exp $
 *
 * $Date: 1993/06/09 11:28:19 $
 ****************************************************************************
 * Name:            INSTALL.CMD                                             *
 *                                                                          *
 * Description:     REXX script to install KWQ Mail/2.                      *
 *                                                                          *
 * Usage:           INSTALL <InstallDir> <FloppyDir>                        *
 *                                                                          *
 * Example:         INSTALL C:\KWQMAIL A:                                   *
 ****************************************************************************/

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCls

/* Get command line parameters. */
Parse Arg InstallDir FloppyDir

/* Initializations. */
bInstructed = 0
Signal On Halt Name SignalHandler

/* Get installation directory. */
If InstallDir = " " Then Do
    Call Instructions
    Say
    Call SimplePrompt 'Please enter the directory on your hard drive for KWQ Mail/2:'
    Parse Pull InstallDir

    /* Check for errors. */
    If InstallDir = " " Then Do
        Say
        Say 'Error!  You must specify a directory name.'
        Say 'Please re-run this installation program.'
        Say
        Exit
    End
End

/* Get directory from which we are installing. */
If FloppyDir = " " Then Do
    Call Instructions
    Say
    Say 'NOTE:  If installing from a floppy drive, specify A: or B: '
    Call SimplePrompt 'Please enter the drive this program is installing from:'
    Pull FloppyDir

    /* Check for errors. */
    If FloppyDir = " " Then Do
        Say
        Say 'Error!  You must specify a directory name.'
        Say 'Please re-run this installation program.'
        Say
        Exit
    End
End

/* Fix up path. */
If SubStr( FloppyDir, Length( FloppyDir ), 1 ) \= '\' Then
    FloppyDir = FloppyDir||'\'

/* Confirm choices. */
Call SysCls
Say
Say '                           KWQ Mail/2 Install!'
Say
Say
Say 'KWQ Mail/2 will be installed with the following information:'
Say
Say '         Installation Directory: "'InstallDir'"'
Say '         Source Directory:       "'FloppyDir'"'
Say
Call YNPrompt 'OK to continue?', '1'

/* Check for directory. */
Say
Say 'Checking for directory "'InstallDir'".'
Call SysFileTree InstallDir, FileStem, 'D'

/* Directory not found. */
If FileStem.0 = '0' Then Do
    Say 'The "'InstallDir'" directory does not exist on your hard drive.'
    Call YNPrompt 'OK to create "'InstallDir'"?', '1'
    Say 'Creating 'InstallDir'....'
    rc = SysMkDir( InstallDir )
    if rc = 0 Then Do
        Say 'The "'InstallDir'" directory was created successfully.'
    End
    Else Do
        Say 'The "'InstallDir'" directory could not be created.'
        Exit
    End
End

/* Copy files. */
Call SysCls
Say
Say 'KWQ Mail/2 INSTALL is copying files to your hard drive.'
Call CopyFile 'bugfixes.doc',   FloppyDir, InstallDir
Call CopyFile 'file_id.diz ',   FloppyDir, InstallDir
Call CopyFile 'kwq.doc     ',   FloppyDir, InstallDir
Call CopyFile 'kwq.exe     ',   FloppyDir, InstallDir
Call CopyFile 'kwqmail.faq ',   FloppyDir, InstallDir
Call CopyFile 'kwqmail.HLP ',   FloppyDir, InstallDir
Call CopyFile 'orderkwq.frm',   FloppyDir, InstallDir
Call CopyFile 'packing.lst ',   FloppyDir, InstallDir
Call CopyFile 'readme.1st  ',   FloppyDir, InstallDir
Call CopyFile 'taglines.kwq',   FloppyDir, InstallDir
Call CopyFile 'twitfilt.kwq',   FloppyDir, InstallDir
Call CopyFile 'whats.new   ',   FloppyDir, InstallDir

/* Prompt to create a program object. */
Call SysCls
Say 'KWQ Mail/2 can be installed as a program object on your desktop.'
Ret = YNPrompt( 'Do you want a program object created?', '0' )
If Ret = 'Y' | Ret = 'y' Then Do
    Say
    Say 'Creating program reference object.'
    r = SysCreateObject(    "WPProgram",,
                            "KWQ Mail/2",,
                            "<WP_DESKTOP>",,
                            "EXENAME="||InstallDir||"\KWQ.EXE;ASSOCTYPE=,QWK Mail;ASSOCFILTER=*.QWK;STARTUPDIR="||InstallDir )
End

/* Salutation! */
Call SysCls
Say 'KWQ Mail/2 has been installed on your system.'
Say
Say 'Be sure to browse the "README.1ST" file for information about'
Say 'last minute changes to the documentation.'
Say
Call SimplePrompt 'Press the Enter key to exit installation....'
Pull ByeBye

/* Bye! */
Exit


/****************************************************************************
 * Name:        CopyFile
 *
 * Description: Procedure to copy a file from one place to another.
 *
 * Args:        File2copy, FloppyDrive, DestDrive
 ****************************************************************************/
CopyFile: Arg ArgFile2Copy, ArgFloppyDir, ArgInstallDir

    Say
    Say 'Copying 'ArgFloppyDir||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'.'
    Command = '@Copy 'ArgFloppyDir||ArgFile2Copy' 'ArgInstallDir||'\'||ArgFile2Copy
    Command
    if rc \= 0 Then Do
        Call SimplePrompt 'Error! 'ArgFile2Copy' was not installed properly.'
        Pull ConfirmIt
    End
    Return


/****************************************************************************
 * Name:        Prompt
 *
 * Description: Procedure to place a prompt onto the screen a reposition the
 *              cursor.
 *
 * Args:        Prompt
 ****************************************************************************/
SimplePrompt: Parse Arg ArgPrompt

    /* Get current cursor position. */
    Parse Value SysCurPos() With Row .

    /* Get screen size. */
    Parse Value SysTextScreenSize() With NumRows .

    /* At end of screen? */
    if Row = NumRows - 1 Then Row = Row - 1

    /* Assemble prompt. */
    Col = Length( ArgPrompt ) + 1

    /* Show prompt. */
    Say ArgPrompt
    Call SysCurPos Row, Col

    Return


/****************************************************************************
 * Name:        YNPrompt
 *
 * Description: Procedure to prompt for Yes or No.
 *              Exit program if No is pressed and Abort is '1'.
 *
 * Args:        Yes/No Prompt
 ****************************************************************************/
YNPrompt: Parse Arg ArgPrompt, ArgAbort

    /* Prompt the user. */
    Call SimplePrompt ArgPrompt' (Y or N)'

    /* Loop until user presses y or n. */
    Do Forever
        Key = SysGetKey( 'NOECHO' )
        If Key = 'Y' | Key = 'y' Then Do
            Say
            Return Key
        End
        Else If Key = 'N' | Key = 'n' Then Do
            Say
            If ArgAbort = '1' Then Exit
            Return Key
        End
    End
    Return 'y'


/****************************************************************************
 * Name:        Instructions
 *
 * Description: Instruct the user how this installation will work.
 ****************************************************************************/
Instructions:
    If bInstructed  = 0 Then Do
        Say
        Say '                   KWQ Mail/2 Installation Instructions:'
        Say
        Say
        Say 'Directions:    To install KWQ Mail/2, you must choose a target'
        Say '               directory on your hard drive and enter the name'
        Say '               of the floppy drive this batch file is'
        Say '               executing from.'
        Say
        Say 'Optional:      INSTALL <InstallDir> <FloppyDir> '
        Say
        Say 'Example:       INSTALL C:\KWQMAIL A: '
        Say
        bInstructed = 1
    End
    Return


/****************************************************************************
 * Name:        SignalHandler
 *
 * Description: Default signal handler.
 ****************************************************************************/
SignalHandler:
    Call SysCls
    Say 'KWQ Mail/2 installation aborted.'
    Exit

