/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.apache.batik.css.parser.CSSLexicalUnit;
import org.apache.batik.css.parser.CSSSACMediaList;
import org.apache.batik.css.parser.CSSSelectorList;
import org.apache.batik.css.parser.DefaultConditionFactory;
import org.apache.batik.css.parser.DefaultDocumentHandler;
import org.apache.batik.css.parser.DefaultErrorHandler;
import org.apache.batik.css.parser.DefaultSelectorFactory;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.Scanner;
import org.apache.batik.css.parser.ScannerUtilities;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class Parser
implements ExtendedParser,
Localizable {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.css.parser.resources.Messages";
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.css.parser.resources.Messages");
    protected Scanner scanner;
    protected int current;
    protected DocumentHandler documentHandler = DefaultDocumentHandler.INSTANCE;
    protected SelectorFactory selectorFactory = DefaultSelectorFactory.INSTANCE;
    protected ConditionFactory conditionFactory = DefaultConditionFactory.INSTANCE;
    protected ErrorHandler errorHandler = DefaultErrorHandler.INSTANCE;
    protected String pseudoElement;
    protected String documentURI;

    protected CSSParseException createCSSParseException(String string) {
        return this.createCSSParseException(string, null);
    }

    protected CSSParseException createCSSParseException(String string, Object[] objectArray) {
        return new CSSParseException(this.formatMessage(string, objectArray), this.documentURI, this.scanner.getLine(), this.scanner.getColumn());
    }

    protected Scanner createScanner(InputSource inputSource) {
        Reader reader;
        this.documentURI = inputSource.getURI();
        if (this.documentURI == null) {
            this.documentURI = "";
        }
        if ((reader = inputSource.getCharacterStream()) != null) {
            return new Scanner(reader);
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            return new Scanner(inputStream, inputSource.getEncoding());
        }
        String string = inputSource.getURI();
        if (string == null) {
            throw new CSSException(this.formatMessage("empty.source", null));
        }
        try {
            ParsedURL parsedURL = new ParsedURL(string);
            inputStream = parsedURL.openStreamRaw("text/css");
            return new Scanner(inputStream, inputSource.getEncoding());
        }
        catch (IOException iOException) {
            throw new CSSException(iOException);
        }
    }

    protected LexicalUnit dimension(boolean bl, LexicalUnit lexicalUnit) {
        try {
            float f2 = bl ? 1 : -1;
            String string = this.scanner.getStringValue();
            int n2 = 0;
            block5: while (n2 < string.length()) {
                switch (string.charAt(n2)) {
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++n2;
                        continue block5;
                    }
                }
            }
            this.nextIgnoreSpaces();
            return CSSLexicalUnit.createDimension(f2 * Float.parseFloat(string.substring(0, n2)), string.substring(n2), lexicalUnit);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createCSSParseException("number.format");
        }
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    protected LexicalUnit hexcolor(LexicalUnit lexicalUnit) {
        String string = this.scanner.getStringValue();
        int n2 = string.length();
        CSSLexicalUnit cSSLexicalUnit = null;
        switch (n2) {
            case 3: {
                char c2 = Character.toLowerCase(string.charAt(0));
                char c3 = Character.toLowerCase(string.charAt(1));
                char c4 = Character.toLowerCase(string.charAt(2));
                if (!(ScannerUtilities.isCSSHexadecimalCharacter(c2) && ScannerUtilities.isCSSHexadecimalCharacter(c3) && ScannerUtilities.isCSSHexadecimalCharacter(c4))) {
                    throw this.createCSSParseException("rgb.color", new Object[]{string});
                }
                int n3 = c2 >= '0' && c2 <= '9' ? c2 - 48 : c2 - 97 + 10;
                int n4 = n3;
                n4 |= (n3 <<= 4);
                n3 = c3 >= '0' && c3 <= '9' ? c3 - 48 : c3 - 97 + 10;
                int n5 = n3;
                n3 = c4 >= '0' && c4 <= '9' ? c4 - 48 : c4 - 97 + 10;
                int n6 = n3;
                cSSLexicalUnit = CSSLexicalUnit.createInteger(n4, null);
                CSSLexicalUnit cSSLexicalUnit2 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit);
                cSSLexicalUnit2 = CSSLexicalUnit.createInteger(n5 |= (n3 <<= 4), cSSLexicalUnit2);
                cSSLexicalUnit2 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit2);
                cSSLexicalUnit2 = CSSLexicalUnit.createInteger(n6 |= (n3 <<= 4), cSSLexicalUnit2);
                break;
            }
            case 6: {
                char c5 = Character.toLowerCase(string.charAt(0));
                char c6 = Character.toLowerCase(string.charAt(1));
                char c7 = Character.toLowerCase(string.charAt(2));
                char c8 = Character.toLowerCase(string.charAt(3));
                char c9 = Character.toLowerCase(string.charAt(4));
                char c10 = Character.toLowerCase(string.charAt(5));
                if (!(ScannerUtilities.isCSSHexadecimalCharacter(c5) && ScannerUtilities.isCSSHexadecimalCharacter(c6) && ScannerUtilities.isCSSHexadecimalCharacter(c7) && ScannerUtilities.isCSSHexadecimalCharacter(c8) && ScannerUtilities.isCSSHexadecimalCharacter(c9) && ScannerUtilities.isCSSHexadecimalCharacter(c10))) {
                    throw this.createCSSParseException("rgb.color");
                }
                int n7 = c5 >= '0' && c5 <= '9' ? c5 - 48 : c5 - 97 + 10;
                n7 <<= 4;
                n7 |= c6 >= '0' && c6 <= '9' ? c6 - 48 : c6 - 97 + 10;
                int n8 = c7 >= '0' && c7 <= '9' ? c7 - 48 : c7 - 97 + 10;
                n8 <<= 4;
                n8 |= c8 >= '0' && c8 <= '9' ? c8 - 48 : c8 - 97 + 10;
                int n9 = c9 >= '0' && c9 <= '9' ? c9 - 48 : c9 - 97 + 10;
                n9 <<= 4;
                int n10 = c10 >= '0' && c10 <= '9' ? c10 - 48 : c10 - 97 + 10;
                cSSLexicalUnit = CSSLexicalUnit.createInteger(n7, null);
                CSSLexicalUnit cSSLexicalUnit3 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit);
                cSSLexicalUnit3 = CSSLexicalUnit.createInteger(n8, cSSLexicalUnit3);
                cSSLexicalUnit3 = CSSLexicalUnit.createSimple((short)0, cSSLexicalUnit3);
                cSSLexicalUnit3 = CSSLexicalUnit.createInteger(n9 |= n10, cSSLexicalUnit3);
                break;
            }
            default: {
                throw this.createCSSParseException("rgb.color", new Object[]{string});
            }
        }
        this.nextIgnoreSpaces();
        return CSSLexicalUnit.createPredefinedFunction((short)27, cSSLexicalUnit, lexicalUnit);
    }

    protected boolean isPseudoElement(String string) {
        switch (string.charAt(0)) {
            case 'A': 
            case 'a': {
                return string.equalsIgnoreCase("after");
            }
            case 'B': 
            case 'b': {
                return string.equalsIgnoreCase("before");
            }
            case 'F': 
            case 'f': {
                return string.equalsIgnoreCase("first-letter") || string.equalsIgnoreCase("first-line");
            }
        }
        return false;
    }

    protected int next() {
        try {
            while (true) {
                this.scanner.clearBuffer();
                this.current = this.scanner.next();
                if (this.current != 18) break;
                this.documentHandler.comment(this.scanner.getStringValue());
            }
            return this.current;
        }
        catch (ParseException parseException) {
            this.reportError(parseException.getMessage());
            return this.current;
        }
    }

    protected int nextIgnoreSpaces() {
        try {
            block6: while (true) {
                this.scanner.clearBuffer();
                this.current = this.scanner.next();
                switch (this.current) {
                    case 17: {
                        continue block6;
                    }
                    case 18: {
                        this.documentHandler.comment(this.scanner.getStringValue());
                        continue block6;
                    }
                }
                break;
            }
            return this.current;
        }
        catch (ParseException parseException) {
            this.errorHandler.error(this.createCSSParseException(parseException.getMessage()));
            return this.current;
        }
    }

    protected float number(boolean bl) {
        try {
            float f2 = bl ? 1 : -1;
            String string = this.scanner.getStringValue();
            this.nextIgnoreSpaces();
            return f2 * Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createCSSParseException("number.format");
        }
    }

    protected void parseAtRule() {
        this.scanner.scanAtRule();
        this.documentHandler.ignorableAtRule(this.scanner.getStringValue());
        this.nextIgnoreSpaces();
    }

    protected LexicalUnit parseExpression(boolean bl) {
        LexicalUnit lexicalUnit;
        LexicalUnit lexicalUnit2 = lexicalUnit = this.parseTerm(null);
        while (true) {
            boolean bl2 = false;
            switch (this.current) {
                case 6: {
                    bl2 = true;
                    lexicalUnit2 = CSSLexicalUnit.createSimple((short)0, lexicalUnit2);
                    this.nextIgnoreSpaces();
                    break;
                }
                case 10: {
                    bl2 = true;
                    lexicalUnit2 = CSSLexicalUnit.createSimple((short)4, lexicalUnit2);
                    this.nextIgnoreSpaces();
                }
            }
            if (bl) {
                if (this.current == 15) {
                    if (bl2) {
                        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
                    }
                    return lexicalUnit;
                }
                lexicalUnit2 = this.parseTerm(lexicalUnit2);
                continue;
            }
            switch (this.current) {
                case 0: 
                case 2: 
                case 8: 
                case 23: {
                    if (bl2) {
                        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
                    }
                    return lexicalUnit;
                }
            }
            lexicalUnit2 = this.parseTerm(lexicalUnit2);
        }
    }

    protected void parseFontFaceRule() {
        try {
            this.documentHandler.startFontFace();
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException cSSParseException) {
                    this.reportError(cSSParseException);
                }
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.documentHandler.endFontFace();
            throw throwable;
        }
        this.documentHandler.endFontFace();
    }

    /*
     * Exception decompiling
     */
    protected LexicalUnit parseFunction(boolean var1_1, LexicalUnit var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void parseImportRule() {
        CSSSACMediaList cSSSACMediaList;
        String string = null;
        switch (this.current) {
            default: {
                this.reportError("string.or.uri");
                return;
            }
            case 19: 
            case 51: 
        }
        string = this.scanner.getStringValue();
        this.nextIgnoreSpaces();
        if (this.current != 20) {
            cSSSACMediaList = new CSSSACMediaList();
            cSSSACMediaList.append("all");
        } else {
            cSSSACMediaList = this.parseMediaList();
        }
        this.documentHandler.importStyle(string, cSSSACMediaList, null);
        if (this.current != 8) {
            this.reportError("semicolon");
        } else {
            this.next();
        }
    }

    public SACMediaList parseMedia(String string) throws CSSException, IOException {
        CSSSACMediaList cSSSACMediaList = new CSSSACMediaList();
        if (!"all".equalsIgnoreCase(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                cSSSACMediaList.append(stringTokenizer.nextToken());
            }
        }
        return cSSSACMediaList;
    }

    protected CSSSACMediaList parseMediaList() {
        CSSSACMediaList cSSSACMediaList = new CSSSACMediaList();
        cSSSACMediaList.append(this.scanner.getStringValue());
        this.nextIgnoreSpaces();
        while (this.current == 6) {
            this.nextIgnoreSpaces();
            switch (this.current) {
                default: {
                    this.reportError("identifier");
                    break;
                }
                case 20: {
                    cSSSACMediaList.append(this.scanner.getStringValue());
                    this.nextIgnoreSpaces();
                }
            }
        }
        return cSSSACMediaList;
    }

    protected void parseMediaRule() {
        CSSSACMediaList cSSSACMediaList;
        block8: {
            if (this.current != 20) {
                this.reportError("identifier");
                return;
            }
            cSSSACMediaList = this.parseMediaList();
            try {
                this.documentHandler.startMedia(cSSSACMediaList);
                if (this.current != 1) {
                    this.reportError("left.curly.brace");
                    break block8;
                }
                this.nextIgnoreSpaces();
                block5: while (true) {
                    switch (this.current) {
                        default: {
                            this.parseRuleSet();
                            continue block5;
                        }
                        case 0: 
                        case 2: 
                    }
                    break;
                }
                this.nextIgnoreSpaces();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.documentHandler.endMedia(cSSSACMediaList);
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.documentHandler.endMedia(cSSSACMediaList);
    }

    protected void parsePageRule() {
        String string = null;
        String string2 = null;
        if (this.current == 20) {
            string = this.scanner.getStringValue();
            this.nextIgnoreSpaces();
            if (this.current == 16) {
                this.nextIgnoreSpaces();
                if (this.current != 20) {
                    this.reportError("identifier");
                    return;
                }
                string2 = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
            }
        }
        try {
            this.documentHandler.startPage(string, string2);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException cSSParseException) {
                    this.reportError(cSSParseException);
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.documentHandler.endPage(string, string2);
            throw throwable;
        }
        this.documentHandler.endPage(string, string2);
    }

    public boolean parsePriority(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        return this.parsePriorityInternal();
    }

    public boolean parsePriority(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        return this.parsePriorityInternal();
    }

    protected boolean parsePriorityInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        this.scanner = null;
        switch (this.current) {
            case 0: {
                return false;
            }
            case 28: {
                return true;
            }
        }
        this.reportError("token", new Object[]{new Integer(this.current)});
        return false;
    }

    public LexicalUnit parsePropertyValue(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        return this.parsePropertyValueInternal();
    }

    public LexicalUnit parsePropertyValue(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        return this.parsePropertyValueInternal();
    }

    protected LexicalUnit parsePropertyValueInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = this.parseExpression(false);
        }
        catch (CSSParseException cSSParseException) {
            this.reportError(cSSParseException);
            throw cSSParseException;
        }
        this.scanner = null;
        if (this.current != 0) {
            this.errorHandler.fatalError(this.createCSSParseException("eof.expected"));
        }
        return lexicalUnit;
    }

    protected void parseRule() {
        switch (this.scanner.getType()) {
            case 28: {
                this.nextIgnoreSpaces();
                this.parseImportRule();
                break;
            }
            case 29: {
                this.nextIgnoreSpaces();
                this.parseAtRule();
                break;
            }
            case 31: {
                this.nextIgnoreSpaces();
                this.parseFontFaceRule();
                break;
            }
            case 32: {
                this.nextIgnoreSpaces();
                this.parseMediaRule();
                break;
            }
            case 33: {
                this.nextIgnoreSpaces();
                this.parsePageRule();
                break;
            }
            default: {
                this.parseRuleSet();
            }
        }
    }

    public void parseRule(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        this.parseRuleInternal();
    }

    public void parseRule(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        this.parseRuleInternal();
    }

    protected void parseRuleInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        this.parseRule();
        this.scanner = null;
    }

    protected void parseRuleSet() {
        SelectorList selectorList = null;
        try {
            selectorList = this.parseSelectorList();
        }
        catch (CSSParseException cSSParseException) {
            this.reportError(cSSParseException);
            return;
        }
        try {
            this.documentHandler.startSelector(selectorList);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
                if (this.current == 2) {
                    this.nextIgnoreSpaces();
                }
            } else {
                this.nextIgnoreSpaces();
                try {
                    this.parseStyleDeclaration(true);
                }
                catch (CSSParseException cSSParseException) {
                    this.reportError(cSSParseException);
                }
            }
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.documentHandler.endSelector(selectorList);
            throw throwable;
        }
        this.documentHandler.endSelector(selectorList);
    }

    protected Selector parseSelector() {
        SimpleSelector simpleSelector;
        Selector selector = simpleSelector = this.parseSimpleSelector();
        this.pseudoElement = null;
        block5: while (true) {
            switch (this.current) {
                case 7: 
                case 11: 
                case 13: 
                case 16: 
                case 20: 
                case 27: {
                    selector = this.selectorFactory.createDescendantSelector(selector, this.parseSimpleSelector());
                    continue block5;
                }
                case 4: {
                    this.nextIgnoreSpaces();
                    selector = this.selectorFactory.createDirectAdjacentSelector((short)1, selector, this.parseSimpleSelector());
                    continue block5;
                }
                case 9: {
                    this.nextIgnoreSpaces();
                    selector = this.selectorFactory.createChildSelector(selector, this.parseSimpleSelector());
                    continue block5;
                }
            }
            break;
        }
        if (this.pseudoElement != null) {
            selector = this.selectorFactory.createChildSelector(selector, this.selectorFactory.createPseudoElementSelector(null, this.pseudoElement));
        }
        return selector;
    }

    protected SelectorList parseSelectorList() {
        CSSSelectorList cSSSelectorList = new CSSSelectorList();
        cSSSelectorList.append(this.parseSelector());
        while (this.current == 6) {
            this.nextIgnoreSpaces();
            cSSSelectorList.append(this.parseSelector());
        }
        return cSSSelectorList;
    }

    public SelectorList parseSelectors(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        return this.parseSelectorsInternal();
    }

    public SelectorList parseSelectors(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        return this.parseSelectorsInternal();
    }

    protected SelectorList parseSelectorsInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        SelectorList selectorList = this.parseSelectorList();
        this.scanner = null;
        return selectorList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected SimpleSelector parseSimpleSelector() {
        switch (this.current) {
            case 20: {
                var1_1 /* !! */  = this.selectorFactory.createElementSelector(null, this.scanner.getStringValue());
                this.next();
                break;
            }
            case 13: {
                this.next();
            }
            default: {
                var1_1 /* !! */  = this.selectorFactory.createElementSelector(null, null);
            }
        }
        var2_2 /* !! */  = null;
        block25: while (true) {
            var3_3 /* !! */  = null;
            switch (this.current) {
                case 27: {
                    var3_3 /* !! */  = this.conditionFactory.createIdCondition(this.scanner.getStringValue());
                    this.next();
                    ** GOTO lbl92
                }
                case 7: {
                    if (this.next() != 20) {
                        throw this.createCSSParseException("identifier");
                    }
                    var3_3 /* !! */  = this.conditionFactory.createClassCondition(null, this.scanner.getStringValue());
                    this.next();
                    ** GOTO lbl92
                }
                case 11: {
                    if (this.nextIgnoreSpaces() != 20) {
                        throw this.createCSSParseException("identifier");
                    }
                    var4_4 = this.scanner.getStringValue();
                    var5_5 = this.nextIgnoreSpaces();
                    block10 : switch (var5_5) {
                        default: {
                            throw this.createCSSParseException("right.bracket");
                        }
                        case 12: {
                            this.nextIgnoreSpaces();
                            var3_3 /* !! */  = this.conditionFactory.createAttributeCondition(var4_4, null, false, null);
                            break;
                        }
                        case 3: 
                        case 25: 
                        case 26: {
                            var6_6 = null;
                            switch (this.nextIgnoreSpaces()) {
                                default: {
                                    throw this.createCSSParseException("identifier.or.string");
                                }
                                case 19: 
                                case 20: 
                            }
                            var6_6 = this.scanner.getStringValue();
                            this.nextIgnoreSpaces();
                            if (this.current != 12) {
                                throw this.createCSSParseException("right.bracket");
                            }
                            this.next();
                            switch (var5_5) {
                                case 3: {
                                    var3_3 /* !! */  = this.conditionFactory.createAttributeCondition(var4_4, null, false, var6_6);
                                    break block10;
                                }
                                case 26: {
                                    var3_3 /* !! */  = this.conditionFactory.createOneOfAttributeCondition(var4_4, null, false, var6_6);
                                    break block10;
                                }
                            }
                            var3_3 /* !! */  = this.conditionFactory.createBeginHyphenAttributeCondition(var4_4, null, false, var6_6);
                            break;
                        }
                    }
                    ** GOTO lbl92
                }
                case 16: {
                    switch (this.nextIgnoreSpaces()) {
                        case 20: {
                            var6_6 = this.scanner.getStringValue();
                            if (this.isPseudoElement(var6_6)) {
                                if (this.pseudoElement != null) {
                                    throw this.createCSSParseException("duplicate.pseudo.element");
                                }
                                this.pseudoElement = var6_6;
                            } else {
                                var3_3 /* !! */  = this.conditionFactory.createPseudoClassCondition(null, var6_6);
                            }
                            this.next();
                            break;
                        }
                        case 52: {
                            var7_7 = this.scanner.getStringValue();
                            if (this.nextIgnoreSpaces() != 20) {
                                throw this.createCSSParseException("identifier");
                            }
                            var8_8 = this.scanner.getStringValue();
                            if (this.nextIgnoreSpaces() != 15) {
                                throw this.createCSSParseException("right.brace");
                            }
                            if (!var7_7.equalsIgnoreCase("lang")) {
                                throw this.createCSSParseException("pseudo.function");
                            }
                            var3_3 /* !! */  = this.conditionFactory.createLangCondition(var8_8);
                            this.next();
                            break;
                        }
                        default: {
                            throw this.createCSSParseException("identifier");
                        }
                    }
lbl92:
                    // 5 sources

                    if (var3_3 /* !! */  == null) continue block25;
                    if (var2_2 /* !! */  == null) {
                        var2_2 /* !! */  = var3_3 /* !! */ ;
                        continue block25;
                    }
                    var2_2 /* !! */  = this.conditionFactory.createAndCondition(var2_2 /* !! */ , var3_3 /* !! */ );
                    continue block25;
                }
            }
            break;
        }
        this.skipSpaces();
        if (var2_2 /* !! */  != null) {
            var1_1 /* !! */  = this.selectorFactory.createConditionalSelector(var1_1 /* !! */ , var2_2 /* !! */ );
        }
        return var1_1 /* !! */ ;
    }

    public void parseStyleDeclaration(String string) throws CSSException, IOException {
        this.scanner = new Scanner(string);
        this.parseStyleDeclarationInternal();
    }

    public void parseStyleDeclaration(InputSource inputSource) throws CSSException, IOException {
        this.scanner = this.createScanner(inputSource);
        this.parseStyleDeclarationInternal();
    }

    protected void parseStyleDeclaration(boolean bl) throws CSSException {
        block8: while (true) {
            switch (this.current) {
                case 0: {
                    if (bl) {
                        throw this.createCSSParseException("eof");
                    }
                    return;
                }
                case 2: {
                    if (!bl) {
                        throw this.createCSSParseException("eof.expected");
                    }
                    this.nextIgnoreSpaces();
                    return;
                }
                case 8: {
                    this.nextIgnoreSpaces();
                    continue block8;
                }
                default: {
                    throw this.createCSSParseException("identifier");
                }
                case 20: 
            }
            String string = this.scanner.getStringValue();
            if (this.nextIgnoreSpaces() != 16) {
                throw this.createCSSParseException("colon");
            }
            this.nextIgnoreSpaces();
            LexicalUnit lexicalUnit = null;
            try {
                lexicalUnit = this.parseExpression(false);
            }
            catch (CSSParseException cSSParseException) {
                this.reportError(cSSParseException);
            }
            if (lexicalUnit == null) continue;
            boolean bl2 = false;
            if (this.current == 23) {
                bl2 = true;
                this.nextIgnoreSpaces();
            }
            this.documentHandler.property(string, lexicalUnit, bl2);
        }
    }

    protected void parseStyleDeclarationInternal() throws CSSException, IOException {
        this.nextIgnoreSpaces();
        try {
            try {
                this.parseStyleDeclaration(false);
            }
            catch (CSSParseException cSSParseException) {
                this.reportError(cSSParseException);
            }
            Object var2_2 = null;
            this.scanner = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.scanner = null;
            throw throwable;
        }
    }

    public void parseStyleSheet(String string) throws CSSException, IOException {
        this.parseStyleSheet(new InputSource(string));
    }

    /*
     * Unable to fully structure code
     */
    public void parseStyleSheet(InputSource var1_1) throws CSSException, IOException {
        block18: {
            this.scanner = this.createScanner(var1_1);
            try {
                this.documentHandler.startDocument(var1_1);
                this.current = this.scanner.next();
                switch (this.current) {
                    case 30: {
                        if (this.nextIgnoreSpaces() != 19) {
                            this.reportError("charset.string");
                            break;
                        }
                        if (this.nextIgnoreSpaces() != 8) {
                            this.reportError("semicolon");
                        }
                        this.next();
                        break;
                    }
                    case 18: {
                        this.documentHandler.comment(this.scanner.getStringValue());
                    }
                }
                this.skipSpacesAndCDOCDC();
                while (this.current == 28) {
                    this.nextIgnoreSpaces();
                    this.parseImportRule();
                    this.nextIgnoreSpaces();
                }
                block15: while (true) {
                    switch (this.current) {
                        case 33: {
                            this.nextIgnoreSpaces();
                            this.parsePageRule();
                            ** GOTO lbl50
                        }
                        case 32: {
                            this.nextIgnoreSpaces();
                            this.parseMediaRule();
                            ** GOTO lbl50
                        }
                        case 31: {
                            this.nextIgnoreSpaces();
                            this.parseFontFaceRule();
                            ** GOTO lbl50
                        }
                        case 29: {
                            this.nextIgnoreSpaces();
                            this.parseAtRule();
                            ** GOTO lbl50
                        }
                        default: {
                            this.parseRuleSet();
lbl50:
                            // 5 sources

                            this.skipSpacesAndCDOCDC();
                            continue block15;
                        }
                        ** case 0:
lbl54:
                        // 1 sources

                        break block18;
                    }
                    break;
                }
            }
            finally {
                var3_2 = null;
                this.documentHandler.endDocument(var1_1);
                this.scanner = null;
            }
        }
    }

    protected LexicalUnit parseTerm(LexicalUnit lexicalUnit) {
        boolean bl = true;
        boolean bl2 = false;
        switch (this.current) {
            case 5: {
                bl = false;
            }
            case 4: {
                this.next();
                bl2 = true;
            }
        }
        switch (this.current) {
            case 24: {
                int n2 = bl ? 1 : -1;
                int n3 = n2 * Integer.parseInt(this.scanner.getStringValue());
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createInteger(n3, lexicalUnit);
            }
            case 54: {
                return CSSLexicalUnit.createFloat((short)14, this.number(bl), lexicalUnit);
            }
            case 42: {
                return CSSLexicalUnit.createFloat((short)23, this.number(bl), lexicalUnit);
            }
            case 45: {
                return CSSLexicalUnit.createFloat((short)21, this.number(bl), lexicalUnit);
            }
            case 44: {
                return CSSLexicalUnit.createFloat((short)22, this.number(bl), lexicalUnit);
            }
            case 46: {
                return CSSLexicalUnit.createFloat((short)17, this.number(bl), lexicalUnit);
            }
            case 37: {
                return CSSLexicalUnit.createFloat((short)19, this.number(bl), lexicalUnit);
            }
            case 38: {
                return CSSLexicalUnit.createFloat((short)20, this.number(bl), lexicalUnit);
            }
            case 39: {
                return CSSLexicalUnit.createFloat((short)18, this.number(bl), lexicalUnit);
            }
            case 36: {
                return CSSLexicalUnit.createFloat((short)15, this.number(bl), lexicalUnit);
            }
            case 35: {
                return CSSLexicalUnit.createFloat((short)16, this.number(bl), lexicalUnit);
            }
            case 47: {
                return CSSLexicalUnit.createFloat((short)28, this.number(bl), lexicalUnit);
            }
            case 48: {
                return CSSLexicalUnit.createFloat((short)30, this.number(bl), lexicalUnit);
            }
            case 49: {
                return CSSLexicalUnit.createFloat((short)29, this.number(bl), lexicalUnit);
            }
            case 43: {
                return CSSLexicalUnit.createFloat((short)32, this.number(bl), lexicalUnit);
            }
            case 40: {
                return CSSLexicalUnit.createFloat((short)31, this.number(bl), lexicalUnit);
            }
            case 41: {
                return CSSLexicalUnit.createFloat((short)33, this.number(bl), lexicalUnit);
            }
            case 50: {
                return CSSLexicalUnit.createFloat((short)34, this.number(bl), lexicalUnit);
            }
            case 34: {
                return this.dimension(bl, lexicalUnit);
            }
            case 52: {
                return this.parseFunction(bl, lexicalUnit);
            }
        }
        if (bl2) {
            throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
        }
        switch (this.current) {
            case 19: {
                String string = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)36, string, lexicalUnit);
            }
            case 20: {
                String string = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                if (string.equalsIgnoreCase("inherit")) {
                    return CSSLexicalUnit.createSimple((short)12, lexicalUnit);
                }
                return CSSLexicalUnit.createString((short)35, string, lexicalUnit);
            }
            case 51: {
                String string = this.scanner.getStringValue();
                this.nextIgnoreSpaces();
                return CSSLexicalUnit.createString((short)24, string, lexicalUnit);
            }
            case 27: {
                return this.hexcolor(lexicalUnit);
            }
        }
        throw this.createCSSParseException("token", new Object[]{new Integer(this.current)});
    }

    protected void reportError(String string) {
        this.reportError(string, null);
    }

    protected void reportError(String string, Object[] objectArray) {
        this.reportError(this.createCSSParseException(string, objectArray));
    }

    protected void reportError(CSSParseException cSSParseException) {
        this.errorHandler.error(cSSParseException);
        int n2 = 1;
        while (true) {
            switch (this.current) {
                case 0: {
                    return;
                }
                case 2: 
                case 8: {
                    if (--n2 == 0) {
                        this.nextIgnoreSpaces();
                        return;
                    }
                }
                case 1: {
                    ++n2;
                }
            }
            this.nextIgnoreSpaces();
        }
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setLocale(Locale locale) throws CSSException {
        this.localizableSupport.setLocale(locale);
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }

    protected int skipSpaces() {
        int n2 = this.scanner.getType();
        while (n2 == 17) {
            n2 = this.next();
        }
        return n2;
    }

    protected int skipSpacesAndCDOCDC() {
        block3: while (true) {
            switch (this.current) {
                case 17: 
                case 18: 
                case 21: 
                case 22: {
                    this.scanner.clearBuffer();
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return this.current;
    }
}

