/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;
import puzzle.PuzzleProperties;
import puzzle.storeage.JigsawPuzzleException;

public class TestGroupLayout
extends JFrame {
    private static final Logger logger = Logger.getLogger(TestGroupLayout.class);
    private JPanel previewPanel;
    private JButton startButton;
    private JButton cancelButton;
    private JButton findFileButton;
    private JLabel pieceSizeLabel;
    private JSpinner pieceSizeSpinner;
    private JLabel additionalOptionsLabel;
    private JLabel turnPieceLabel;
    private JCheckBox turnPieceCheckBox;
    private JLabel edgesLabel;
    private JComboBox edgesComboBox;

    public TestGroupLayout() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Test Layout");
        this.setLocationByPlatform(true);
        this.setResizable(true);
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.previewPanel = new JPanel();
        this.turnPieceCheckBox = new JCheckBox(PuzzleProperties.getLocalized("optionAllowTurn"));
        this.startButton = new JButton(PuzzleProperties.getLocalized("newGameDialogStart"));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestGroupLayout.this.startClicked();
            }
        });
        this.cancelButton = new JButton(PuzzleProperties.getLocalized("newGameDialogCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestGroupLayout.this.cancelClicked();
            }
        });
        this.findFileButton = new JButton(PuzzleProperties.getLocalized("newGameDialogFindFile"));
        this.findFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TestGroupLayout.this.findFileClicked();
                }
                catch (JigsawPuzzleException jigsawPuzzleException) {
                    logger.error("couldn't load image: " + jigsawPuzzleException.toString());
                    TestGroupLayout.this.showErrorMessage(PuzzleProperties.getLocalized("loadImageErrorTitle"), PuzzleProperties.getLocalized("loadImageErrorMessage"));
                }
            }
        });
        this.pieceSizeLabel = new JLabel(PuzzleProperties.getLocalized("newGameDialogPieceSize"));
        this.additionalOptionsLabel = new JLabel(PuzzleProperties.getLocalized("newGameDialogOptions"));
        this.edgesLabel = new JLabel(PuzzleProperties.getLocalized("newGameDialogEdges"));
    }

    private void initLayout() {
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.additionalOptionsLabel).addComponent(this.edgesLabel).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startButton).addComponent(this.cancelButton)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.additionalOptionsLabel).addComponent(this.edgesLabel).addComponent(this.startButton)).addComponent(this.cancelButton));
        this.pack();
    }

    protected void showErrorMessage(String string, String string2) {
    }

    protected void findFileClicked() throws JigsawPuzzleException {
        throw new JigsawPuzzleException();
    }

    protected void cancelClicked() {
    }

    protected void startClicked() {
    }

    public static void main(String[] stringArray) {
        PuzzleProperties.loadLocal();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestGroupLayout testGroupLayout = new TestGroupLayout();
                testGroupLayout.setVisible(true);
            }
        });
    }
}

