/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Iterator;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import puzzle.GameCommander;
import puzzle.PuzzleProperties;
import puzzle.gameevent.GameEvent;
import puzzle.gameevent.GameEventListener;
import puzzle.pieces.PuzzlePiece;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.ui.PuzzleInputListener;

public class GamePanel
extends JPanel
implements GameEventListener {
    private Logger logger = Logger.getLogger(GamePanel.class);
    private Image offscreenImage;
    private final PuzzleInputListener inputListener;
    private final GameCommander gC = GameCommander.getInstance();

    public PuzzleInputListener getInputListener() {
        return this.inputListener;
    }

    public GamePanel() {
        this.inputListener = new PuzzleInputListener();
        this.addMouseListener(this.inputListener);
        this.addMouseMotionListener(this.inputListener);
        GameCommander.getInstance().addListener(this);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.gC.isGameRunning()) {
            if (GameCommander.getInstance().getPreferences().isAntiAliasing()) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.offscreenImage != null) {
                graphics.drawImage(this.offscreenImage, 0, 0, null);
            }
        }
    }

    private void deleteFromArea(PuzzlePiece puzzlePiece) throws JigsawPuzzleException {
        Rectangle rectangle = puzzlePiece.getBoundingRectangle();
        Graphics2D graphics2D = (Graphics2D)this.offscreenImage.getGraphics().create();
        graphics2D.setClip(rectangle);
        graphics2D.setColor(PuzzleProperties.BACKGROUND_COLOR);
        graphics2D.fill(rectangle);
        if (GameCommander.getInstance().getPreferences().isAntiAliasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (PuzzlePiece puzzlePiece2 : GameCommander.getInstance().getPieceDisposer().getPuzzlePieces()) {
            if (!puzzlePiece2.isWithinRectangle(rectangle) || puzzlePiece2 == puzzlePiece) continue;
            puzzlePiece2.renderInClip(graphics2D);
        }
        graphics2D.dispose();
        this.repaint(rectangle);
    }

    private void drawToArea(PuzzlePiece puzzlePiece) throws JigsawPuzzleException {
        Rectangle rectangle = puzzlePiece.getBoundingRectangle();
        Graphics2D graphics2D = (Graphics2D)this.offscreenImage.getGraphics().create();
        graphics2D.setClip(rectangle);
        puzzlePiece.renderInClip(graphics2D);
        graphics2D.dispose();
        this.repaint(rectangle);
    }

    public void reRender() throws JigsawPuzzleException {
        Object object;
        boolean bl = false;
        if (this.offscreenImage == null || !this.isSameSize(this.offscreenImage, this.getPreferredSize())) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0].getDefaultConfiguration();
            this.offscreenImage = ((GraphicsConfiguration)object).createCompatibleImage(this.getSize().width, this.getSize().height);
            bl = true;
        }
        Graphics2D graphics2D = (Graphics2D)this.offscreenImage.getGraphics();
        if (bl) {
            graphics2D.clearRect(0, 0, this.offscreenImage.getWidth(null), this.offscreenImage.getHeight(null));
        }
        graphics2D.setColor(PuzzleProperties.BACKGROUND_COLOR);
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        object = GameCommander.getInstance().getPieceDisposer().getPuzzlePieces();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PuzzlePiece puzzlePiece = (PuzzlePiece)iterator.next();
            puzzlePiece.renderInClip(graphics2D);
        }
        graphics2D.dispose();
        this.repaint();
    }

    private boolean isSameSize(Image image, Dimension dimension) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = dimension.width;
        int n4 = dimension.height;
        return n == n3 && n2 == n4;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public void eventHappened(GameEvent gameEvent) throws JigsawPuzzleException {
        switch (gameEvent.getType()) {
            case PREPARE_TO_TURN_PIECE: 
            case PREPARE_TO_MOVE_PIECE: 
            case PREPARE_TO_HIGHLIGHT_PIECE: {
                this.deleteFromArea((PuzzlePiece)gameEvent.getInfo());
                break;
            }
            case TURN_PIECE: 
            case MOVE_PIECE: 
            case HIGHLIGHT_PIECE: {
                this.drawToArea((PuzzlePiece)gameEvent.getInfo());
                break;
            }
        }
    }
}

