/*
 * Decompiled with CFR 0.152.
 */
package puzzle.storeage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StorageUtil {
    private static BASE64Encoder base64Enc;
    private static BASE64Decoder base64Dec;

    public static Node findDirectChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            return node2;
        }
        return null;
    }

    public static void storeBinaryData(Node node, String string, byte[] byArray) {
        if (base64Enc == null) {
            base64Enc = new BASE64Encoder();
        }
        String string2 = base64Enc.encode(byArray);
        Document document = node.getOwnerDocument();
        Element element = document.createElement(string);
        CDATASection cDATASection = document.createCDATASection("");
        cDATASection.setNodeValue(string2);
        element.appendChild(cDATASection);
        node.appendChild(element);
    }

    public static byte[] restoreBinaryData(Node node, String string) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, string);
        CDATASection cDATASection = (CDATASection)node2.getChildNodes().item(0);
        if (base64Dec == null) {
            base64Dec = new BASE64Decoder();
        }
        try {
            byte[] byArray = base64Dec.decodeBuffer(cDATASection.getData());
            return byArray;
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
            throw new LoadGameException(dOMException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LoadGameException(iOException);
        }
    }

    public static void storeSerialisableObject(Node node, String string, Object object) throws SaveGameException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            StorageUtil.storeBinaryData(node, string, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SaveGameException(iOException);
        }
    }

    public static Object restoreSerialisableObject(Node node, String string) throws LoadGameException {
        try {
            byte[] byArray = StorageUtil.restoreBinaryData(node, string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new LoadGameException(classNotFoundException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LoadGameException(iOException);
        }
    }

    public static Document createDOMDocument() throws SaveGameException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SaveGameException(parserConfigurationException);
        }
    }

    public static void saveAsXML(Document document, File file) throws SaveGameException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            throw new SaveGameException(transformerConfigurationException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new SaveGameException(fileNotFoundException);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new SaveGameException(transformerException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SaveGameException(iOException);
        }
    }
}

