/*
 * Decompiled with CFR 0.152.
 */
package puzzle.pieces;

import java.awt.Point;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import puzzle.edge.Edge;
import puzzle.pieces.MultiPiece;
import puzzle.pieces.PuzzlePiece;
import puzzle.pieces.SinglePiece;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;

public class PuzzlePieceDisposer
implements Storeable {
    private List<PuzzlePiece> puzzlePieces = new Vector<PuzzlePiece>();

    public int getPieceCount() {
        return this.puzzlePieces.size();
    }

    public PuzzlePiece findbyPoint(Point point) {
        for (PuzzlePiece puzzlePiece : this.puzzlePieces) {
            if (!puzzlePiece.isHit(point)) continue;
            int n = this.puzzlePieces.lastIndexOf(puzzlePiece);
            this.puzzlePieces.set(n, this.puzzlePieces.get(this.puzzlePieces.size() - 1));
            this.puzzlePieces.set(this.puzzlePieces.size() - 1, puzzlePiece);
            return puzzlePiece;
        }
        return null;
    }

    public void addPuzzleStueck(PuzzlePiece puzzlePiece) {
        if (puzzlePiece == null) {
            throw new NullPointerException("PS null");
        }
        this.puzzlePieces.add(puzzlePiece);
    }

    public PuzzlePiece assamblyPieces(PuzzlePiece puzzlePiece, Edge edge, PuzzlePiece puzzlePiece2, Edge edge2) throws JigsawPuzzleException {
        PuzzlePiece puzzlePiece3;
        MultiPiece multiPiece;
        if (puzzlePiece == null) {
            throw new NullPointerException("ps1 null");
        }
        if (puzzlePiece2 == null) {
            throw new NullPointerException("ps2 null");
        }
        boolean bl = false;
        if (puzzlePiece.getPieceCount() > puzzlePiece2.getPieceCount()) {
            multiPiece = (MultiPiece)puzzlePiece;
            puzzlePiece3 = puzzlePiece2;
        } else if (puzzlePiece.getPieceCount() < puzzlePiece2.getPieceCount()) {
            multiPiece = (MultiPiece)puzzlePiece2;
            puzzlePiece3 = puzzlePiece;
        } else if (puzzlePiece2.getPieceCount() == 1) {
            edge.close();
            edge2.close();
            multiPiece = new MultiPiece((SinglePiece)puzzlePiece, (SinglePiece)puzzlePiece2);
            puzzlePiece3 = null;
            bl = true;
        } else {
            multiPiece = (MultiPiece)puzzlePiece;
            puzzlePiece3 = puzzlePiece2;
        }
        if (!bl) {
            int n = Integer.MAX_VALUE;
            List<Edge> list = puzzlePiece3.getOpenEdges();
            if (puzzlePiece3 instanceof SinglePiece) {
                n = 4;
            } else if (puzzlePiece3 instanceof MultiPiece) {
                n = list.size();
            }
            for (Edge edge3 : multiPiece.getOpenEdges()) {
                if (n == 0) break;
                int n2 = edge3.getEdgePairNumber();
                Edge.Type type = Edge.contraryEdgeChar(edge3.getType());
                Edge edge4 = null;
                for (Edge edge5 : list) {
                    if (edge5.getEdgePairNumber() != n2) continue;
                    edge4 = edge5;
                    list.remove(edge5);
                    break;
                }
                if (edge4 == null) continue;
                if (edge4.getType() != type) {
                    throw new JigsawPuzzleException("could not add, because edges are turned twisted");
                }
                if (edge3.getType() == Edge.Type.NULL) continue;
                edge3.close();
                edge4.close();
                --n;
            }
        }
        multiPiece.addPiece(puzzlePiece3);
        this.puzzlePieces.remove(puzzlePiece);
        this.puzzlePieces.remove(puzzlePiece2);
        this.puzzlePieces.add(multiPiece);
        return multiPiece;
    }

    public List<PuzzlePiece> getPuzzlePieces() {
        return this.puzzlePieces;
    }

    public boolean ends() {
        return this.puzzlePieces.size() == 1;
    }

    public void reset() {
        this.puzzlePieces.clear();
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "PieceDisposer");
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (!node3.getNodeName().equals("PuzzlePiece")) continue;
            Node node4 = StorageUtil.findDirectChildNode(node3, "MultiPiece");
            Node node5 = StorageUtil.findDirectChildNode(node3, "SinglePiece");
            PuzzlePiece puzzlePiece = null;
            if (node5 != null) {
                puzzlePiece = new SinglePiece();
            } else if (node4 != null) {
                puzzlePiece = new MultiPiece();
            } else {
                throw new LoadGameException("Neither a single nor a multipiece was found");
            }
            puzzlePiece.restore(node3);
            this.addPuzzleStueck(puzzlePiece);
        }
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("PieceDisposer");
        for (PuzzlePiece puzzlePiece : this.puzzlePieces) {
            Element element2 = document.createElement("PuzzlePiece");
            puzzlePiece.store(element2);
            element.appendChild(element2);
        }
        node.appendChild(element);
    }
}

