/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_ShortcutConstants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Unix_Shortcut
extends Shortcut
implements Unix_ShortcutConstants {
    private static String version = "$Id: Unix_Shortcut.java,v 1.1.2.1 2005/04/12 07:21:57 miraodb Exp $";
    private static String rev = "$Revision: 1.1.2.1 $";
    private String createdDirectory;
    private static String DESKTOP_EXT = ".desktop";
    private int itsShow;
    private int itsUserType;
    private int itsType;
    private int itsIconIndex;
    private String itsWorkingDirectory;
    private String itsGroupName;
    private String itsTargetPath;
    private String itsIconPath;
    private String itsDescription;
    private String itsArguments;
    private String itsName;
    private String itsFileName;
    private String itsApplnkFolder = "applnk";
    private static String template = "";
    private Properties props;
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";

    public Unix_Shortcut() {
        StringBuffer hlp = new StringBuffer();
        String userLanguage = System.getProperty("user.language", "en");
        hlp.append("[Desktop Entry]\n");
        hlp.append("Comment=$Comment\n");
        hlp.append("Comment[" + userLanguage + "]=" + "$Comment" + N);
        hlp.append("Encoding=$Encoding\n");
        hlp.append("Exec='$Exec' $Arguments\n");
        hlp.append("GenericName=$GenericName\n");
        hlp.append("GenericName[" + userLanguage + "]=" + "$GenericName" + N);
        hlp.append("Icon=$Icon\n");
        hlp.append("MimeType=$MimeType\n");
        hlp.append("Name=$Name\n");
        hlp.append("Name[" + userLanguage + "]=" + "$Name" + N);
        hlp.append("Path='$Path'\n");
        hlp.append("ServiceTypes=$ServiceTypes\n");
        hlp.append("SwallowExec=$SwallowExec\n");
        hlp.append("SwallowTitle=$SwallowTitle\n");
        hlp.append("Terminal=$Terminal\n");
        hlp.append("TerminalOptions=$Options_For_Terminal\n");
        hlp.append("Type=$Type\n");
        hlp.append("URL=$URL\n");
        hlp.append("X-KDE-SubstituteUID=$X_KDE_SubstituteUID\n");
        hlp.append("X-KDE-Username=$X_KDE_Username\n");
        template = hlp.toString();
        this.props = new Properties();
        this.initProps();
    }

    private void initProps() {
        String[] propsArray = new String[]{"$Comment", "$$LANG_Comment", "$Encoding", "$Exec", "$Arguments", "$GenericName", "$$LANG_GenericName", "$MimeType", "$Name", "$$LANG_Name", "$Path", "$ServiceTypes", "$SwallowExec", "$SwallowTitle", "$Terminal", "$Options_For_Terminal", "$Type", "$X_KDE_SubstituteUID", "$X_KDE_Username", "$Icon", "$URL"};
        for (int i = 0; i < propsArray.length; ++i) {
            this.props.put(propsArray[i], "");
        }
    }

    public void initialize(int aType, String aName) throws Exception {
        this.itsType = aType;
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    public boolean supported() {
        return true;
    }

    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    public String getFileName() {
        return this.itsFileName;
    }

    public Vector getProgramGroups(int userType) {
        File kdeHomeShareApplnk;
        String FS = File.separator;
        Vector<String> groups = new Vector<String>();
        File homedir = new File(System.getProperty("user.home"));
        try {
            File kdeHome = new File(homedir.toString() + FS + ".kde");
            if (!kdeHome.exists()) {
                return groups;
            }
            File kdeHomeShare = new File(kdeHome.toString() + FS + "share");
            if (!kdeHomeShare.exists()) {
                return groups;
            }
            kdeHomeShareApplnk = new File(kdeHomeShare.toString() + FS + "applnk");
            String[] applnkFolders = new String[]{"applnk-mdk", "applnk-redhat", "applnk"};
            for (int i = 0; i < applnkFolders.length; ++i) {
                kdeHomeShareApplnk = new File(kdeHomeShare.toString() + FS + applnkFolders[i]);
                if (!kdeHomeShareApplnk.exists()) continue;
                this.itsApplnkFolder = applnkFolders[i];
                break;
            }
            if (!kdeHomeShareApplnk.exists()) {
                return groups;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return groups;
        }
        try {
            File[] listing = kdeHomeShareApplnk.listFiles();
            for (int i = 0; i < listing.length; ++i) {
                if (!listing[i].isDirectory()) continue;
                groups.add(listing[i].getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return groups;
    }

    public boolean multipleUsers() {
        return true;
    }

    public void save() throws Exception {
        String FS = File.separator;
        String target = null;
        String shortCutDef = this.replace();
        if (this.itsGroupName == null || "".equals(this.itsGroupName)) {
            target = System.getProperty("user.home") + FS + "Desktop" + FS + this.itsName + DESKTOP_EXT;
        } else {
            File homedir = new File(System.getProperty("user.home"));
            File kdeHome = new File(homedir.toString() + FS + ".kde");
            File kdeHomeShare = new File(kdeHome.toString() + FS + "share");
            File kdeHomeShareApplnk = new File(kdeHomeShare.toString() + FS + this.itsApplnkFolder);
            target = kdeHomeShareApplnk.toString() + FS + this.itsGroupName + FS + this.itsName + DESKTOP_EXT;
        }
        File targetPath = new File(target.toString().substring(0, target.toString().lastIndexOf(File.separatorChar)));
        if (!targetPath.exists()) {
            targetPath.mkdirs();
            this.createdDirectory = targetPath.toString();
        }
        this.itsFileName = new String(target);
        File targetFileName = new File(target);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fileWriter.write(shortCutDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setArguments(String args) {
        this.itsArguments = args;
        this.props.put("$Arguments", args);
    }

    public void setDescription(String description) {
        this.itsDescription = description;
        this.props.put("$Comment", description);
    }

    public void setIconLocation(String path, int index) {
        this.itsIconPath = path;
        this.itsIconIndex = index;
        this.props.put("$Icon", path);
    }

    public void setLinkName(String aName) {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    public void setLinkType(int aType) throws IllegalArgumentException {
        this.itsType = aType;
    }

    public void setProgramGroup(String aGroupName) {
        this.itsGroupName = aGroupName;
    }

    public void setShowCommand(int show) {
        this.itsShow = show;
    }

    public void setTargetPath(String aPath) {
        this.itsTargetPath = aPath;
        this.props.put("$Exec", aPath);
    }

    public void setUserType(int aUserType) {
        this.itsUserType = aUserType;
    }

    public void setWorkingDirectory(String aDirectory) {
        this.itsWorkingDirectory = aDirectory;
        this.props.put("$Path", aDirectory);
    }

    public String toString() {
        return this.itsName + N + template;
    }

    public String replace() {
        String result = new String(template);
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result = StringTool.replace(result, key, this.props.getProperty(key));
        }
        return result;
    }

    public static void main(String[] args) {
        Unix_Shortcut aSample = new Unix_Shortcut();
        try {
            aSample.initialize(1, "Start Tomcat");
        }
        catch (Exception exc) {
            System.err.println("Could not init Unix_Shourtcut");
        }
        aSample.replace();
        System.out.println(aSample);
        File targetFileName = new File(System.getProperty("user.home") + File.separator + "Start Tomcat" + DESKTOP_EXT);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fileWriter.write(template);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setEncoding(String aEncoding) {
        this.props.put("$Encoding", aEncoding);
    }

    public void setKdeSubstUID(String aKDESubstUID) {
        this.props.put("$X_KDE_SubstituteUID", aKDESubstUID);
    }

    public void setMimetype(String aMimetype) {
        this.props.put("$MimeType", aMimetype);
    }

    public void setTerminal(String trueFalseOrNothing) {
        this.props.put("$Terminal", trueFalseOrNothing);
    }

    public void setTerminalOptions(String someTerminalOptions) {
        this.props.put("$Options_For_Terminal", someTerminalOptions);
    }

    public void setType(String aType) {
        this.props.put("$Type", aType);
    }

    public void setURL(String anUrl) {
        this.props.put("$URL", anUrl);
    }
}

