/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Debug {
    private static final boolean TRACE;
    private static final boolean STACKTRACE;
    public static boolean LOG;
    private static PrintWriter logFile;

    public static void trace(Object s) {
        if (TRACE) {
            System.out.println(s);
            if (STACKTRACE && s instanceof Throwable) {
                ((Throwable)s).printStackTrace();
            }
            System.out.flush();
        }
    }

    public static void error(Object s) {
        Debug.trace(s);
        System.err.println(s);
        System.err.flush();
        if (LOG && logFile == null) {
            Debug.createLogFile();
        }
        if (LOG && logFile != null && s != null) {
            logFile.print(s);
            if (s instanceof Throwable) {
                ((Throwable)s).printStackTrace(logFile);
            }
            logFile.flush();
        }
    }

    private static void createLogFile() {
        try {
            File out = new File(System.getProperty("user.dir"), ".log.txt");
            if (out.canWrite()) {
                if (out.exists()) {
                    out.delete();
                }
                FileWriter fw = new FileWriter(out);
                logFile = new PrintWriter(fw);
            }
        }
        catch (Throwable e) {
            System.err.println(e);
            System.err.flush();
        }
    }

    public static boolean tracing() {
        return TRACE;
    }

    public static boolean stackTracing() {
        return STACKTRACE;
    }

    static {
        boolean st = false;
        try {
            st = Boolean.getBoolean("STACKTRACE");
        }
        catch (Exception ex) {
            // empty catch block
        }
        STACKTRACE = st;
        boolean t = false;
        try {
            t = STACKTRACE ? true : Boolean.getBoolean("TRACE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TRACE = t;
    }
}

