/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class ScriptParser {
    public static final String INSTALL_PATH = "INSTALL_PATH";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String USER_HOME = "USER_HOME";
    public static final String USER_NAME = "USER_NAME";
    public static final String FILE_SEPARATOR = "FILE_SEPARATOR";
    public static final String APP_NAME = "APP_NAME";
    public static final String APP_URL = "APP_URL";
    public static final String APP_VER = "APP_VER";
    public static final String ISO3_LANG = "ISO3_LANG";
    private Collection files;
    private VariableSubstitutor vs;

    public ScriptParser(Collection files, VariableSubstitutor vs) {
        this.files = files;
        this.vs = vs;
    }

    public void parseFiles() throws Exception {
        Iterator iter = this.files.iterator();
        while (iter.hasNext()) {
            ParsableFile pfile = (ParsableFile)iter.next();
            if (!OsConstraint.oneMatchesCurrentSystem(pfile.osConstraints)) continue;
            File file = new File(pfile.path);
            File parsedFile = File.createTempFile("izpp", null, file.getParentFile());
            FileInputStream inFile = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(inFile, 5120);
            FileOutputStream outFile = new FileOutputStream(parsedFile);
            BufferedOutputStream out = new BufferedOutputStream(outFile, 5120);
            this.vs.substitute(in, out, pfile.type, pfile.encoding);
            in.close();
            out.close();
            file.delete();
            if (parsedFile.renameTo(file)) continue;
            throw new IOException("Could not rename file " + parsedFile + " to " + file);
        }
    }
}

