/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser.node;

import com.eteks.parser.CompiledFunction;
import com.eteks.parser.DoubleInterpreter;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.node.ExpressionNode;
import com.eteks.parser.node.ParameterizedNode;
import java.util.Vector;

public class FunctionNode
implements ParameterizedNode {
    private Vector parametersExpression = new Vector(2, 1);
    private Function function;
    private boolean recursiveCall;
    private static Interpreter doubleInterpreter;

    public FunctionNode(Function function, boolean bl) {
        this.function = function;
        this.recursiveCall = bl;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean isRecursiveCall() {
        return this.recursiveCall;
    }

    public void addParameter(ExpressionNode expressionNode) {
        this.parametersExpression.addElement(expressionNode);
    }

    public int getParameterCount() {
        return this.parametersExpression.size();
    }

    public ExpressionNode getParameter(int n) {
        return (ExpressionNode)this.parametersExpression.elementAt(n);
    }

    public Object computeExpression(Interpreter interpreter, Object[] objectArray) {
        Object[] objectArray2 = new Object[this.parametersExpression.size()];
        int n = 0;
        while (n < this.parametersExpression.size()) {
            objectArray2[n] = this.getParameter(n).computeExpression(interpreter, objectArray);
            ++n;
        }
        return interpreter.getFunctionValue(this.function, objectArray2, this.recursiveCall);
    }

    public double computeExpression(double[] dArray) {
        Object object;
        if (this.function instanceof CompiledFunction) {
            double[] dArray2 = new double[this.parametersExpression.size()];
            int n = 0;
            while (n < this.parametersExpression.size()) {
                dArray2[n] = this.getParameter(n).computeExpression(dArray);
                ++n;
            }
            return ((CompiledFunction)this.function).computeFunction(dArray2);
        }
        Object[] objectArray = new Double[this.parametersExpression.size()];
        int n = 0;
        while (n < this.parametersExpression.size()) {
            objectArray[n] = new Double(this.getParameter(n).computeExpression(dArray));
            ++n;
        }
        if (doubleInterpreter == null) {
            doubleInterpreter = new DoubleInterpreter();
        }
        if ((object = this.function.computeFunction(doubleInterpreter, objectArray)) instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new IllegalArgumentException("Result " + object + " not an instance of Number");
    }
}

