/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.d3d;

import com.eteks.tools.d3d.Point3D;
import com.eteks.tools.d3d.Vector3D;

public class Matrix3D {
    protected float[][] coord = new float[4][];

    public Matrix3D() {
        int n = 0;
        while (n < 4) {
            this.coord[n] = new float[4];
            ++n;
        }
    }

    public String toString() {
        String string = "Matrix3D :\n";
        int n = 0;
        while (n < 4) {
            string = String.valueOf(string) + "line " + n + " :";
            int n2 = 0;
            while (n2 < 4) {
                string = String.valueOf(string) + " " + this.coord[n][n2];
                ++n2;
            }
            if (n < 3) {
                string = String.valueOf(string) + "\n";
            }
            ++n;
        }
        return string;
    }

    public Matrix3D multiplyMatrix(Matrix3D matrix3D) {
        Matrix3D matrix3D2 = new Matrix3D();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 0;
                while (n3 < 4) {
                    float[] fArray = matrix3D2.coord[n];
                    int n4 = n2;
                    fArray[n4] = fArray[n4] + this.coord[n][n3] * matrix3D.coord[n3][n2];
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return matrix3D2;
    }

    public float getValue(int n, int n2) {
        return this.coord[n][n2];
    }

    public static Matrix3D getIndentity3DMatrix() {
        Matrix3D matrix3D = new Matrix3D();
        int n = 0;
        while (n < 4) {
            matrix3D.coord[n][n] = 1.0f;
            ++n;
        }
        return matrix3D;
    }

    public static Matrix3D getRotationMatrix(Point3D point3D, Vector3D vector3D, int[] nArray) {
        Matrix3D matrix3D;
        Matrix3D matrix3D2 = Matrix3D.getIndentity3DMatrix();
        int n = 0;
        while (n <= 2) {
            matrix3D2.coord[n][3] = point3D.getCoordinate(n);
            ++n;
        }
        int n2 = 2;
        while (n2 >= 0) {
            n = nArray[n2];
            if ((double)vector3D.getCoordinate(n) != 0.0) {
                matrix3D = Matrix3D.getIndentity3DMatrix();
                float f = (float)Math.cos(vector3D.getCoordinate(n));
                matrix3D.coord[(n + 2) % 3][(n + 2) % 3] = f;
                matrix3D.coord[(n + 1) % 3][(n + 1) % 3] = f;
                float f2 = (float)Math.sin(vector3D.getCoordinate(n));
                matrix3D.coord[(n + 2) % 3][(n + 1) % 3] = f2;
                matrix3D.coord[(n + 1) % 3][(n + 2) % 3] = -f2;
                matrix3D2 = matrix3D2.multiplyMatrix(matrix3D);
            }
            --n2;
        }
        matrix3D = Matrix3D.getIndentity3DMatrix();
        n = 0;
        while (n <= 2) {
            matrix3D.coord[n][3] = -point3D.getCoordinate(n);
            ++n;
        }
        return matrix3D2.multiplyMatrix(matrix3D);
    }

    public static Matrix3D getTranslationMatrix(Vector3D vector3D) {
        Matrix3D matrix3D = Matrix3D.getIndentity3DMatrix();
        int n = 0;
        while (n <= 2) {
            matrix3D.coord[n][3] = vector3D.getCoordinate(n);
            ++n;
        }
        return matrix3D;
    }

    public static Matrix3D getProjectionMatrix(float f, float f2, float f3) {
        Matrix3D matrix3D = Matrix3D.getIndentity3DMatrix();
        matrix3D.coord[0][2] = -f * (float)Math.cos(f2);
        matrix3D.coord[1][2] = -f * (float)Math.sin(f2);
        if ((double)f3 != 0.0) {
            matrix3D.coord[3][2] = -1.0f / f3;
        }
        return matrix3D;
    }

    public static Matrix3D getScaleMatrix(Vector3D vector3D) {
        Matrix3D matrix3D = Matrix3D.getIndentity3DMatrix();
        int n = 0;
        while (n <= 2) {
            matrix3D.coord[n][n] = vector3D.getCoordinate(n);
            ++n;
        }
        return matrix3D;
    }

    public static Matrix3D getDisplayMatrix(Point3D point3D, Vector3D vector3D, int[] nArray, Vector3D vector3D2, float f, float f2, float f3, Point3D point3D2, Vector3D vector3D3) {
        Matrix3D matrix3D = Matrix3D.getScreenMatrix(f, f2, f3, point3D2, vector3D3).multiplyMatrix(Matrix3D.getReferenceMatrix(point3D, vector3D, nArray, vector3D2));
        return matrix3D;
    }

    public static Matrix3D getReferenceMatrix(Point3D point3D, Vector3D vector3D, int[] nArray, Vector3D vector3D2) {
        Matrix3D matrix3D = Matrix3D.getTranslationMatrix(vector3D2).multiplyMatrix(Matrix3D.getRotationMatrix(point3D, vector3D, nArray));
        return matrix3D;
    }

    public static Matrix3D getScreenMatrix(float f, float f2, float f3, Point3D point3D, Vector3D vector3D) {
        Matrix3D matrix3D = Matrix3D.getTranslationMatrix(new Vector3D(point3D)).multiplyMatrix(Matrix3D.getScaleMatrix(vector3D)).multiplyMatrix(Matrix3D.getProjectionMatrix(f, f2, f3));
        return matrix3D;
    }
}

