/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxoXsltTransformer {
    public static void transform(File inFile, File outFile, File xslFile, Map<String, String> parameters, Map<String, String> properties) throws IOException {
        try {
            String baseDir = xslFile.getParent();
            MyResolver resolver = new MyResolver(baseDir);
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(new StreamSource(xslFile));
            Transformer xformer = template.newTransformer();
            xformer.setURIResolver(resolver);
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    xformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    xformer.setOutputProperty(entry.getKey(), entry.getValue());
                }
            }
            xformer.transform(new StreamSource(inFile), new StreamResult(outFile));
        }
        catch (TransformerException e) {
            SourceLocator locator = e.getLocator();
            String info = "column: " + locator.getColumnNumber() + "line: " + locator.getLineNumber() + "publicId: " + locator.getPublicId() + "systemId: " + locator.getSystemId();
            throw new IOException(info, e);
        }
    }

    private JaxoXsltTransformer() {
    }

    private static class MyResolver
    implements URIResolver {
        private final String basePath;

        MyResolver(String path) {
            this.basePath = path;
        }

        public Source resolve(String href, String base) {
            StringBuffer path = new StringBuffer(this.basePath);
            path.append(File.separator).append(href);
            File file = new File(path.toString());
            if (file.exists()) {
                return new StreamSource(file);
            }
            return null;
        }
    }
}

