/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sf.jaxodraw.util.JaxoLog;

public final class JaxoLooknFeel {
    private static Map<Component, Boolean> components = new WeakHashMap<Component, Boolean>();
    private static Locale locale = JComponent.getDefaultLocale();

    private JaxoLooknFeel() {
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void applyLocale(Locale value) {
        if (!value.equals(locale)) {
            locale = value;
            JComponent.setDefaultLocale(locale);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        JaxoLooknFeel.setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
                        JaxoLooknFeel.updateLocale();
                    }
                    catch (Exception x) {
                        JaxoLog.debug(x);
                    }
                }
            });
        }
    }

    public static boolean applyLookAndFeel(String lookAndFeelClassName) {
        boolean success = true;
        try {
            JaxoLooknFeel.setLookAndFeel(lookAndFeelClassName);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JaxoLooknFeel.updateLookAndFeel();
                }
            });
        }
        catch (Exception exc) {
            success = false;
            JaxoLog.debug(exc);
            try {
                JaxoLooknFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception x) {
                JaxoLog.debug(x);
            }
        }
        return success;
    }

    public static UIManager.LookAndFeelInfo info(String className) {
        UIManager.LookAndFeelInfo[] ll = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < ll.length; ++i) {
            if (!className.equals(ll[i].getClassName())) continue;
            return ll[i];
        }
        return new UIManager.LookAndFeelInfo(className, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLookAndFeel(String value) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Locale old = Locale.getDefault();
        Locale.setDefault(locale);
        try {
            UIManager.setLookAndFeel(value);
            new JFileChooser();
        }
        finally {
            Locale.setDefault(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLookAndFeel(LookAndFeel value) throws UnsupportedLookAndFeelException {
        Locale old = Locale.getDefault();
        Locale.setDefault(locale);
        try {
            UIManager.setLookAndFeel(value);
            new JFileChooser();
        }
        finally {
            Locale.setDefault(old);
        }
    }

    public static void updateLookAndFeel() {
        Frame[] f = Frame.getFrames();
        for (int i = 0; i < f.length; ++i) {
            JaxoLooknFeel.updateWindow(f[i]);
        }
        for (Component c : components.keySet()) {
            SwingUtilities.updateComponentTreeUI(c);
        }
    }

    private static void updateWindow(Window w) {
        SwingUtilities.updateComponentTreeUI(w);
        Window[] c = w.getOwnedWindows();
        for (int i = 0; i < c.length; ++i) {
            JaxoLooknFeel.updateWindow(c[i]);
        }
    }

    public static void registerComponent(JComponent c) {
        components.put(c, Boolean.TRUE);
    }

    public static void unregisterComponent(JComponent c) {
        components.remove(c);
    }

    private static void updateLocale() {
        Frame[] f = Frame.getFrames();
        for (int i = 0; i < f.length; ++i) {
            JaxoLooknFeel.updateWindowLocale(f[i]);
        }
        for (Component c : components.keySet()) {
            JaxoLooknFeel.applyLocale(c);
        }
    }

    private static void updateWindowLocale(Window w) {
        JaxoLooknFeel.applyLocale(w);
        Window[] c = w.getOwnedWindows();
        for (int i = 0; i < c.length; ++i) {
            JaxoLooknFeel.updateWindowLocale(c[i]);
        }
    }

    private static void applyLocale(Component c) {
        c.setLocale(locale);
        if (c instanceof JComponent) {
            ((JComponent)c).updateUI();
        }
        if (c instanceof Container) {
            Container p = (Container)c;
            for (int i = p.getComponentCount() - 1; i >= 0; --i) {
                JaxoLooknFeel.applyLocale(p.getComponent(i));
            }
        }
    }
}

