/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import net.sf.jaxodraw.util.JaxoLog;

public final class JaxoConstants {
    public static final int NO_MODE = -1;
    private static final int MIN_MODE = 0;
    public static final int STANDBY = 0;
    private static final int PARTICLE_MIN = 3;
    public static final int FLINE = 3;
    public static final int FLOOP = 4;
    public static final int FARC = 5;
    public static final int SLINE = 6;
    public static final int SLOOP = 7;
    public static final int SARC = 8;
    public static final int GLINE = 9;
    public static final int GLOOP = 10;
    public static final int GARC = 11;
    public static final int PLINE = 12;
    public static final int PLOOP = 13;
    public static final int PARC = 14;
    public static final int GLLINE = 15;
    public static final int GLLOOP = 16;
    public static final int GLARC = 17;
    public static final int FBEZ = 18;
    public static final int PBEZ = 19;
    public static final int GLBEZ = 20;
    public static final int SBEZ = 21;
    public static final int GBEZ = 22;
    private static final int PARTICLE_MAX = 22;
    private static final int MISC_MIN = 230;
    public static final int BOX = 230;
    public static final int BLOB = 231;
    public static final int VERTEX = 232;
    public static final int ZIGZAG = 233;
    public static final int TEXT = 234;
    public static final int LATEX = 235;
    private static final int MISC_MAX = 235;
    private static final int VERTEX_MIN = 336;
    public static final int VERTEXT1 = 336;
    public static final int VERTEXT2 = 337;
    public static final int VERTEXT3 = 338;
    public static final int VERTEXT4 = 339;
    public static final int VERTEXT5 = 340;
    public static final int VERTEXT6 = 341;
    private static final int VERTEX_MAX = 341;
    private static final int EDIT_MIN = 450;
    public static final int MOVE = 450;
    public static final int RESIZE = 451;
    public static final int DUPLICATE = 452;
    public static final int COLOR = 453;
    public static final int EDIT = 454;
    public static final int DELETE = 455;
    public static final int BACKGROUND = 456;
    public static final int FOREGROUND = 457;
    public static final int UNGROUP = 459;
    public static final int SELECT = 460;
    private static final int EDIT_MAX = 461;
    private static final int FILE_MIN = 570;
    public static final int NEWG = 570;
    public static final int OPEN = 571;
    public static final int SAVE = 572;
    public static final int SAVE_AS = 573;
    public static final int EXPORT = 575;
    public static final int PRINT = 576;
    public static final int CLOSE = 578;
    public static final int NEWT = 580;
    public static final int IMPORT = 581;
    public static final int SAVE_SELECTION_AS = 582;
    public static final int EXPORT_SELECTION = 583;
    private static final int FILE_MAX = 583;
    public static final int RECENT_FILE = 685;
    private static final int ZOOM_FACTOR_MIN = 791;
    public static final int ZOOM_FACTOR = 791;
    public static final int ZOOM_FACTOR_X2 = 792;
    public static final int ZOOM_FACTOR_X4 = 793;
    public static final int ZOOM_FACTOR_X8 = 794;
    private static final int ZOOM_FACTOR_MAX = 794;
    private static final int ACTION_MIN = 1101;
    public static final int UNDO = 1101;
    public static final int CLEAR = 1102;
    public static final int REDO = 1103;
    public static final int REFRESH = 1104;
    public static final int PASTE = 1105;
    public static final int DESCRIBE = 1106;
    public static final int PACKAGE = 1107;
    public static final int PREVIEW = 1108;
    public static final int WATCHFILE = 1109;
    public static final int RENAME_TAB = 1110;
    public static final int CUT = 1111;
    public static final int SCOPY = 1112;
    public static final int SGROUP = 1113;
    public static final int SUNGROUP = 1114;
    public static final int SFORE = 1115;
    public static final int SBACK = 1116;
    public static final int LATEX_PREVIEW_SELECTION = 1117;
    public static final int MOVE_GRAPH = 1118;
    private static final int ACTION_MAX = 1118;
    private static final int HELP_MIN = 2151;
    public static final int ABOUT = 2151;
    public static final int USR_GUIDE = 2152;
    public static final int SYS_INFO = 2153;
    public static final int MAC_README = 2154;
    private static final int HELP_MAX = 2154;
    private static final int GRID_MIN = 3161;
    public static final int GRID = 3161;
    public static final int ZOOM = 3162;
    public static final int QUIT = 3163;
    public static final int GRID_SIZE = 3164;
    public static final int RECTANGULAR_GRID = 3165;
    public static final int HEXAGONAL_GRID = 3166;
    public static final int GRID_STYLE_DOT = 3167;
    public static final int GRID_STYLE_CROSS = 3168;
    public static final int GRID_STYLE_LINE = 3169;
    public static final int GRID_STYLE_LINE_HONEYCOMB = 3170;
    private static final int GRID_MAX = 3170;
    private static final int LANG_MIN = 4171;
    public static final int ENGLISH = 4171;
    public static final int GERMAN = 4172;
    public static final int FRENCH = 4173;
    public static final int ITALIAN = 4174;
    public static final int SPANISH = 4175;
    private static final int LANG_MAX = 4175;
    private static final int OPTION_MIN = 5182;
    public static final int TOOLBAR = 5182;
    public static final int STATUSBAR = 5183;
    public static final int ANTIALIAS = 5184;
    public static final int ARROW = 5185;
    public static final int LOOKNFEEL = 5187;
    public static final int PREFERENCES = 5188;
    public static final int GRID_ONOFF = 5189;
    public static final int GRIDBAR = 5190;
    public static final int SNAP_ONOFF = 5191;
    public static final int PLUGINS = 5192;
    private static final int OPTION_MAX = 5192;
    private static final int DEFAULT_MIN = 6201;
    public static final int DEF_NONE = 6201;
    public static final int DEF_FLINE = 6202;
    public static final int DEF_FLOOP = 6203;
    public static final int DEF_FARC = 6204;
    public static final int DEF_SLINE = 6205;
    public static final int DEF_SLOOP = 6206;
    public static final int DEF_SARC = 6207;
    public static final int DEF_GLINE = 6208;
    public static final int DEF_GLOOP = 6209;
    public static final int DEF_GARC = 6210;
    public static final int DEF_PLINE = 6211;
    public static final int DEF_PLOOP = 6212;
    public static final int DEF_PARC = 6213;
    public static final int DEF_GLLINE = 6214;
    public static final int DEF_GLLOOP = 6215;
    public static final int DEF_GLARC = 6216;
    public static final int DEF_BOX = 6217;
    public static final int DEF_BLOB = 6218;
    public static final int DEF_VERTEX = 6219;
    public static final int DEF_ZIGZAG = 6220;
    public static final int DEF_TEXT = 6221;
    public static final int DEF_LATEX = 6222;
    public static final int DEF_MOVE = 6223;
    public static final int DEF_RESIZE = 6224;
    public static final int DEF_DUPLICATE = 6225;
    public static final int DEF_COLOR = 6226;
    public static final int DEF_EDIT = 6227;
    public static final int DEF_SELECT = 6228;
    private static final int DEFAULT_MAX = 6229;
    private static final int MAX_MODE = 6229;
    public static final int DUMMIE = 10000;
    public static final int DUMMIE1 = 10001;
    private static final String[] DEF_ACTION_KEYS = new String[]{"None", "Fermion_Line", "Fermion_Loop", "Fermion_Arc", "Scalar_Line", "Scalar_Loop", "Scalar_Arc", "Ghost_Line", "Ghost_Loop", "Ghost_Arc", "Photon_Line", "Photon_Loop", "Photon_Arc", "Gluon_Line", "Gluon_Loop", "Gluon_Arc", "Box", "Blob", "Vertex", "Zigzag", "Text", "LaTex", "Move", "Resize", "Duplicate", "Color", "Edit", "Select"};
    private static final int[] DEF_MODES = new int[]{6201, 6202, 6203, 6204, 6205, 6206, 6207, 6208, 6209, 6210, 6211, 6212, 6213, 6214, 6215, 6216, 6217, 6218, 6219, 6220, 6221, 6222, 6223, 6224, 6225, 6226, 6227, 6228};

    private JaxoConstants() {
    }

    public static String[] defaultActionKeys() {
        return (String[])DEF_ACTION_KEYS.clone();
    }

    public static int[] defaultModes() {
        return (int[])DEF_MODES.clone();
    }

    public static boolean isEditMode(int mode) {
        boolean iem = true;
        if (mode < 450 || mode > 461) {
            iem = false;
        }
        return iem;
    }

    public static boolean isParticleMode(int mode) {
        boolean ipm = true;
        if (mode < 3 || mode > 22) {
            ipm = false;
        }
        return ipm;
    }

    public static boolean isMiscMode(int mode) {
        boolean imm = true;
        if (mode < 230 || mode > 235) {
            imm = false;
        }
        return imm;
    }

    public static boolean isFileMode(int mode) {
        boolean ifm = true;
        if (mode < 570 || mode > 583) {
            ifm = false;
        }
        return ifm;
    }

    public static boolean isActionMode(int mode) {
        boolean is = true;
        if (mode < 1101 || mode > 1118) {
            is = false;
        }
        return is;
    }

    public static boolean isGridMode(int mode) {
        boolean is = true;
        if (mode < 3161 || mode > 3170) {
            is = false;
        }
        return is;
    }

    public static boolean isVertexMode(int mode) {
        boolean is = true;
        if (mode < 336 || mode > 341) {
            is = false;
        }
        return is;
    }

    public static boolean isZoomFactorMode(int mode) {
        boolean is = true;
        if (mode < 791 || mode > 794) {
            is = false;
        }
        return is;
    }

    public static boolean isHelpMode(int mode) {
        boolean is = true;
        if (mode < 2151 || mode > 2154) {
            is = false;
        }
        return is;
    }

    public static boolean isLanguageMode(int mode) {
        boolean is = true;
        if (mode < 4171 || mode > 4175) {
            is = false;
        }
        return is;
    }

    public static boolean isOptionMode(int mode) {
        boolean is = true;
        if (mode < 5182 || mode > 5192) {
            is = false;
        }
        return is;
    }

    public static boolean isDefaultMode(int mode) {
        boolean is = true;
        if (mode < 6201 || mode > 6229) {
            is = false;
        }
        return is;
    }

    public static boolean isNewObjectMode(int mode) {
        return JaxoConstants.isParticleMode(mode) || JaxoConstants.isMiscMode(mode) || JaxoConstants.isVertexMode(mode);
    }

    public static boolean isLineMode(int mode) {
        boolean is = false;
        if (mode == 3 || mode == 9 || mode == 15 || mode == 12 || mode == 6) {
            is = true;
        }
        return is;
    }

    public static boolean isArcMode(int mode) {
        boolean is = false;
        if (mode == 5 || mode == 11 || mode == 17 || mode == 14 || mode == 8) {
            is = true;
        }
        return is;
    }

    public static boolean isBezierMode(int mode) {
        boolean is = false;
        if (mode == 18 || mode == 19 || mode == 20 || mode == 21 || mode == 22) {
            is = true;
        }
        return is;
    }

    public static boolean isLoopMode(int mode) {
        boolean is = false;
        if (mode == 4 || mode == 10 || mode == 16 || mode == 13 || mode == 7) {
            is = true;
        }
        return is;
    }

    public static boolean isTextMode(int mode) {
        return mode == 235 || mode == 234;
    }

    public static boolean isSelectMode(int mode) {
        return mode == 454 || mode == 453 || mode == 456 || mode == 457 || mode == 455 || mode == 459 || mode == 460;
    }

    public static String getModeAsString(int mode) {
        String result = "NO_MODE";
        if (mode >= 0 && mode <= 6229) {
            result = Integer.toString(mode);
        }
        return result;
    }

    public static int getModeAsInt(String modeString) {
        int i;
        int intvalue = -1;
        try {
            intvalue = Integer.parseInt(modeString);
        }
        catch (NumberFormatException exc) {
            JaxoLog.debug(exc);
        }
        for (i = -1; i != intvalue && i <= 6229; ++i) {
        }
        if (i >= 6229) {
            i = -1;
        }
        return i;
    }

    public static int defaultActionToMode(int defaultAction) {
        switch (defaultAction) {
            case 6201: {
                return 0;
            }
            case 6202: {
                return 3;
            }
            case 6203: {
                return 4;
            }
            case 6204: {
                return 5;
            }
            case 6205: {
                return 6;
            }
            case 6206: {
                return 7;
            }
            case 6207: {
                return 8;
            }
            case 6208: {
                return 9;
            }
            case 6209: {
                return 10;
            }
            case 6210: {
                return 11;
            }
            case 6211: {
                return 12;
            }
            case 6212: {
                return 13;
            }
            case 6213: {
                return 14;
            }
            case 6214: {
                return 15;
            }
            case 6215: {
                return 16;
            }
            case 6216: {
                return 17;
            }
            case 6217: {
                return 230;
            }
            case 6218: {
                return 231;
            }
            case 6219: {
                return 232;
            }
            case 6220: {
                return 233;
            }
            case 6221: {
                return 234;
            }
            case 6222: {
                return 235;
            }
            case 6223: {
                return 450;
            }
            case 6224: {
                return 451;
            }
            case 6225: {
                return 452;
            }
            case 6226: {
                return 453;
            }
            case 6227: {
                return 454;
            }
            case 6228: {
                return 460;
            }
        }
        JaxoLog.warn("Unknown default mode: " + defaultAction);
        return 0;
    }
}

