/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.jaxodraw.io.exports.JaxoExport;
import net.sf.jaxodraw.io.imports.JaxoImport;
import net.sf.jaxodraw.plugin.AbstractJaxoPlugin;
import net.sf.jaxodraw.plugin.JaxoExportPlugin;
import net.sf.jaxodraw.plugin.JaxoImportPlugin;
import net.sf.jaxodraw.plugin.JaxoPlugin;
import net.sf.jaxodraw.plugin.JaxoPluginLoader;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxoPluginInfo {
    private static JaxoPluginInfo pluginInfo;
    private final List<Object> exportFormats = new ArrayList<Object>(8);
    private final List<JaxoImportPlugin> importFormats = new ArrayList<JaxoImportPlugin>(2);
    private final Set<String> externalPlugins = new HashSet<String>(4);

    private JaxoPluginInfo() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JaxoPluginInfo getPluginInfo() {
        Class<JaxoPluginInfo> clazz = JaxoPluginInfo.class;
        synchronized (JaxoPluginInfo.class) {
            if (pluginInfo == null) {
                pluginInfo = new JaxoPluginInfo();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return pluginInfo;
        }
    }

    private void init() {
        this.setupPluginFormats();
    }

    private void setupPluginFormats() {
        this.exportFormats.addAll(JaxoExport.getBuiltInFormats());
        this.importFormats.addAll(JaxoImport.getBuiltInFormats());
        this.createPluginDir();
        JaxoPluginLoader pluginLoader = new JaxoPluginLoader();
        List<JaxoPlugin> plugins = pluginLoader.loadPlugins(JaxoInfo.PLUGIN_DIR);
        Iterator<JaxoPlugin> it = plugins.iterator();
        while (it.hasNext()) {
            this.addPlugin(it.next());
        }
    }

    public void reValidate() {
        this.exportFormats.clear();
        this.importFormats.clear();
        this.externalPlugins.clear();
        this.exportFormats.addAll(JaxoExport.getBuiltInFormats());
        this.importFormats.addAll(JaxoImport.getBuiltInFormats());
        this.createPluginDir();
        JaxoPluginLoader pluginLoader = new JaxoPluginLoader();
        List<JaxoPlugin> plugins = pluginLoader.reValidate(JaxoInfo.PLUGIN_DIR);
        Iterator<JaxoPlugin> it = plugins.iterator();
        while (it.hasNext()) {
            this.addPlugin(it.next());
        }
    }

    public String availablePlugins() {
        return this.externalPlugins.isEmpty() ? JaxoLanguage.translate("None") : this.externalPlugins.toString();
    }

    public Set<String> getAvailablePlugins() {
        return new HashSet<String>(this.externalPlugins);
    }

    public List<Object> getExportFormats() {
        return new ArrayList<Object>(this.exportFormats);
    }

    public List<JaxoImportPlugin> getImportFormats() {
        return new ArrayList<JaxoImportPlugin>(this.importFormats);
    }

    public void addPlugin(JaxoPlugin plugin) {
        if (plugin instanceof JaxoExportPlugin) {
            JaxoExportPlugin exportPlugin = (JaxoExportPlugin)plugin;
            this.externalPlugins.add(exportPlugin.getClassName());
            if (exportPlugin.makeAvailableAtRuntime() && !this.exportFormats.contains(exportPlugin)) {
                this.exportFormats.add(exportPlugin);
            }
        } else if (plugin instanceof JaxoImportPlugin) {
            JaxoImportPlugin importPlugin = (JaxoImportPlugin)plugin;
            this.externalPlugins.add(importPlugin.getClassName());
            if (importPlugin.makeAvailableAtRuntime() && !this.importFormats.contains(importPlugin)) {
                this.importFormats.add(importPlugin);
            }
        }
    }

    public void removePlugin(JaxoPlugin plugin) {
        if (plugin == null) {
            return;
        }
        if (this.exportFormats.remove(plugin)) {
            JaxoLog.debug("removed export plugin: " + plugin.pluginId());
        }
        if (this.importFormats.remove(plugin)) {
            JaxoLog.debug("removed import plugin: " + plugin.pluginId());
        }
        if (this.externalPlugins.remove(((AbstractJaxoPlugin)plugin).getClassName())) {
            JaxoLog.debug("removed external plugin: " + plugin.pluginId());
        }
    }

    public JaxoImportPlugin getImportForExtension(String ext) {
        for (JaxoImportPlugin plugin : this.importFormats) {
            if (!ext.equals(plugin.getFileExtension())) continue;
            return plugin;
        }
        return null;
    }

    private void createPluginDir() {
        File pluginDir = new File(JaxoInfo.PLUGIN_DIR);
        if (!pluginDir.exists()) {
            if (pluginDir.mkdirs()) {
                JaxoLog.debug("Created plugin directory: " + JaxoInfo.PLUGIN_DIR);
            } else {
                JaxoLog.warn("Failed to create plugin dir: " + JaxoInfo.PLUGIN_DIR);
            }
        }
    }
}

