/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.plugin.AbstractJaxoPlugin;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoLanguage;

public abstract class JaxoImportPlugin
extends AbstractJaxoPlugin {
    private String charsetName;
    private static final JComponent CONF_PANEL = new JLabel(" ");

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String name) {
        this.charsetName = name;
    }

    public JaxoGraph importGraph(String fileName) {
        return this.importGraph(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxoGraph importGraph(File f) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            try {
                if (f.exists()) {
                    this.showImportError(f, "JaxoIO.read%0OpenFailed");
                } else {
                    this.showImportError(f, "JaxoIO.read%0NotFound");
                }
                this.getLog().debug(e);
            }
            finally {
                this.close(inputStream);
            }
            return null;
        }
        JaxoGraph openedGraph = null;
        try {
            openedGraph = this.importGraph(inputStream);
        }
        catch (JaxoPluginExecutionException e) {
            String msg = e.getMessage();
            this.getLog().warn(msg);
            this.setFailure(e);
            if (e.getSource() != null) {
                this.getLog().debug("Source: " + e.getSource().toString());
            }
            this.showImportError(f, msg, "JaxoImport.import%0ImportFailed%1Message");
        }
        finally {
            this.close(inputStream);
        }
        if (openedGraph != null) {
            openedGraph.setSaveFileName(f.getAbsolutePath());
        }
        return openedGraph;
    }

    public JComponent getConfigurationPanel() {
        return CONF_PANEL;
    }

    public void commitConfiguration() {
    }

    private void showError(File f, String key, String title) {
        JOptionPane.showMessageDialog(this.getParentComponent(), JaxoLanguage.message(key, f), JaxoDialogs.translatedWindowTitle(title), 0);
    }

    private void showImportError(File f, String key) {
        this.showError(f, key, JaxoLanguage.message("JaxoIO.import%0ErrorTitle", new Object[]{f}));
    }

    private void showImportError(File f, String msg, String key) {
        JOptionPane.showMessageDialog(this.getParentComponent(), JaxoLanguage.message(key, new Object[]{f, msg}), this.errorDialogTitle(f), 0);
    }

    private String errorDialogTitle(File f) {
        return JaxoDialogs.translatedWindowTitle(JaxoLanguage.message("JaxoIO.import%0ErrorTitle", new Object[]{f}));
    }

    protected abstract JaxoGraph importGraph(InputStream var1) throws JaxoPluginExecutionException;
}

