/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.plugin;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.plugin.AbstractJaxoPlugin;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoExportPlugin
extends AbstractJaxoPlugin {
    private JaxoGraph graph;
    private Dimension canvasSize;

    public final void setGraph(JaxoGraph newGraph) {
        this.graph = newGraph.copyOf();
        this.graph.breakAllGroups();
    }

    public final JaxoGraph getGraph() {
        return this.graph;
    }

    @Deprecated
    public void setCanvasSize(Dimension value) {
        if (this.canvasSize == null) {
            this.canvasSize = new Dimension();
        }
        this.canvasSize.setSize(value);
    }

    @Deprecated
    protected Dimension getCanvasSize() {
        return this.canvasSize;
    }

    public final void export(String fileName) {
        block3: {
            this.setFailure(null);
            if (fileName.length() == 0) {
                return;
            }
            try {
                this.exportTo(fileName);
            }
            catch (JaxoPluginExecutionException e) {
                this.setFailure(e);
                if (e.getMessage() == null) break block3;
                this.showErrorDialog(e.getMessage());
            }
        }
    }

    public void export(JaxoGraph exportGraph, String fileName) {
        this.setGraph(exportGraph);
        this.export(fileName);
    }

    public void preview(JaxoPreview p) {
        this.preview(p, false);
    }

    protected void paintGraph(Graphics2D g2d, boolean printing) {
        JaxoGraphics2D g = new JaxoGraphics2D(g2d);
        g.setPrinting(printing);
        this.getGraph().paint(g);
    }

    protected void showErrorDialog(String message) {
        if (!this.isSilent()) {
            JaxoDialogs.showErrorDialog(this.getParentComponent(), message, JaxoDialogs.windowTitle("JaxoExport.exportErrorTitle"));
        }
    }

    protected String errorDialogMessage(String fileName) {
        return JaxoLanguage.message("JaxoExport.export%0Error", fileName);
    }

    public String getLaTeXTextWarning() {
        return JaxoLanguage.translate("JaxoExport.warning.LaTeXText");
    }

    public String getPSTextWarning() {
        return JaxoLanguage.translate("JaxoExport.warning.PSText");
    }

    public String getPSTextWarningForLaTeX() {
        return JaxoLanguage.translate("JaxoExport.warning.PSTextForLaTeX");
    }

    public String getColorSpaceWarningForLaTeX() {
        return JaxoLanguage.translate("JaxoExport.warning.ColorSpaceForLaTeX");
    }

    public abstract void commitConfiguration();

    public abstract JComponent getConfigurationPanel();

    protected abstract void exportTo(String var1) throws JaxoPluginExecutionException;

    public abstract void preview(JaxoPreview var1, boolean var2);

    public abstract String getWarningForGraph();
}

