/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.vertex.JaxoVertex;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoVertexT3
extends JaxoVertex {
    private static final long serialVersionUID = 314159L;
    private transient Rectangle2D square = new Rectangle2D.Float();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.square = new Rectangle2D.Float();
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoVertexT3) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        this.updateSquare();
        g2.setColor(this.getColor());
        g2.fill(this.square);
        g2.draw(this.square);
    }

    public Rectangle getBounds() {
        this.updateSquare();
        return this.getStroke().createStrokedShape(this.square).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        float xi = (float)center.getX() - radius;
        float yi = (float)center.getY() + radius;
        float xf = (float)center.getX() + radius;
        float yf = (float)center.getY() - radius;
        String tlc = JaxoColor.getColorName(this.getColor());
        return "\\CBox(" + D_FORMAT.format(xf) + "," + D_FORMAT.format(yf) + ")" + "(" + D_FORMAT.format(xi) + "," + D_FORMAT.format(yi) + ")" + "{" + tlc + "}" + "{" + tlc + "}" + "%%JaxoDrawID:Vertex";
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        this.prepareGenericPanel(editPanel, "vertexT3.png");
    }

    private void updateSquare() {
        double length = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        this.square.setFrame(-length + (double)this.getX(), -length + (double)this.getY(), 2.0 * length, 2.0 * length);
    }
}

