/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoFillColorObject;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.vertex.JaxoVertex;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoVertexT2
extends JaxoVertex
implements JaxoFillColorObject {
    private static final long serialVersionUID = 314159L;
    private transient Ellipse2D blob = new Ellipse2D.Float();
    private Color fillColor;
    private boolean filled = true;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.blob = new Ellipse2D.Float();
    }

    public final boolean isFilled() {
        return this.filled;
    }

    public final void setFilled(boolean value) {
        Boolean old = this.filled;
        this.filled = value;
        this.firePropertyChange("filled", old, this.filled);
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(Color color) {
        Color old = this.fillColor;
        this.fillColor = color;
        this.firePropertyChange("fillColor", old, this.fillColor);
    }

    public final void copyFrom(JaxoVertexT2 temp) {
        super.copyFrom(temp);
        this.setFillColor(temp.getFillColor());
        this.setFilled(temp.isFilled());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoVertexT2)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoVertexT2)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoVertexT2) {
            JaxoVertexT2 vertexT2 = (JaxoVertexT2)comp;
            if (super.isCopy(comp) && vertexT2.getFillColor().equals(this.getFillColor()) && vertexT2.isFilled() == this.isFilled()) {
                isCopy = true;
            }
        }
        return isCopy;
    }

    public boolean canBeSelected(int handle, int mode) {
        boolean active;
        boolean bl = active = handle == 0 || handle == 1;
        if (mode == 451) {
            active = handle == 1;
        }
        return active;
    }

    public void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
    }

    public final void paint(JaxoGraphics2D g2) {
        this.updateBlob();
        if (this.isFilled()) {
            g2.setColor(this.getFillColor());
            g2.fill(this.blob);
        }
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.blob);
        int sepx = (int)Math.round((double)this.getRelh() / Math.sqrt(2.0));
        int sepy = (int)Math.round((double)this.getRelw() / Math.sqrt(2.0));
        g2.drawLine(this.getX() + sepx, this.getY() - sepy, this.getX() - sepx, this.getY() + sepy);
        g2.drawLine(this.getX() - sepy, this.getY() - sepx, this.getX() + sepy, this.getY() + sepx);
    }

    public Rectangle getBounds() {
        this.updateBlob();
        return this.getStroke().createStrokedShape(this.blob).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        Point2D axes = this.getLaTexAxes(scale);
        String command = "";
        float angle = (float)Math.toDegrees(Math.atan2(this.getRelh(), this.getRelw()));
        String command1 = "";
        String tlc = JaxoColor.getColorName(this.getColor());
        if (this.isFilled()) {
            if (JaxoColor.isGrayScale(this.getFillColor())) {
                float grayScale = JaxoColor.getGrayScaleFloat(this.getFillColor());
                command1 = "\\GOval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")" + "(" + angle + ")" + "{" + GRAY_SCALE_FORMAT.format(grayScale) + "}";
            } else {
                String tfc = JaxoColor.getColorName(this.getFillColor());
                command1 = "\\COval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")" + "(" + angle + ")" + "{" + tlc + "}" + "{" + tfc + "}";
            }
        } else {
            command1 = "\\Oval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")" + "(" + angle + ")";
        }
        Point2D.Float invec1 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.5f)), (float)(center.getY() - (double)(radius * 0.5f)));
        Point2D.Float finvec1 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.5f)), (float)(center.getY() + (double)(radius * 0.5f)));
        Point2D.Float invec2 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.5f)), (float)(center.getY() + (double)(radius * 0.5f)));
        Point2D.Float finvec2 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.5f)), (float)(center.getY() - (double)(radius * 0.5f)));
        double theta = 0.7853981633974483 - Math.atan2(this.getRelh(), this.getRelw());
        AffineTransform at = new AffineTransform();
        at.rotate(theta, center.getX(), center.getY());
        Point2D invect1 = at.transform(invec1, null);
        Point2D finvect1 = at.transform(finvec1, null);
        Point2D invect2 = at.transform(invec2, null);
        Point2D finvect2 = at.transform(finvec2, null);
        String command2 = "\\Line(" + D_FORMAT.format(invect1.getX()) + "," + D_FORMAT.format(invect1.getY()) + ")" + "(" + D_FORMAT.format(finvect1.getX()) + "," + D_FORMAT.format(finvect1.getY()) + ")";
        String command3 = "\\Line(" + D_FORMAT.format(invect2.getX()) + "," + D_FORMAT.format(invect2.getY()) + ")" + "(" + D_FORMAT.format(finvect2.getX()) + "," + D_FORMAT.format(finvect2.getY()) + ")";
        command = command1 + command2 + command3;
        return command;
    }

    public void setPreferences() {
        super.setPreferences();
        this.setFilled(true);
        this.setFillColor(JaxoColor.WHITE);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        int r = (int)Math.round(this.getRadius());
        editPanel.addXYRPanel(this.getX(), this.getY(), r, 0, 0);
        editPanel.addRotationPanel(this.getRotationAngle(), 0, 1);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 2);
        editPanel.addFillLineColorPanels(this.getColor(), this.getFillColor(), this.isFilled(), 1, 1, 1, 0);
        editPanel.setTitleAndIcon("Vertex_parameters", "vertexT2.png");
    }

    private Point2D getLaTexAxes(float scaleFactor) {
        float wdt = (float)this.getRadius() / scaleFactor;
        return new Point2D.Float(wdt, wdt);
    }

    private void updateBlob() {
        double len = this.getRadius();
        this.blob.setFrame(-len + (double)this.getX(), -len + (double)this.getY(), 2.0 * len, 2.0 * len);
    }
}

