/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.text;

import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoRotationObject;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoTextObject
extends JaxoObject
implements JaxoRotationObject {
    private static final long serialVersionUID = 2L;
    private String textString;
    private int rotationAngle;

    public final String getTextString() {
        return this.textString;
    }

    public void setTextString(String string) {
        String old = this.textString;
        this.textString = string;
        this.firePropertyChange("textString", old, this.textString);
    }

    public final int getRotationAngle() {
        return this.rotationAngle;
    }

    public final void setRotationAngle(int angle) {
        Integer old = this.rotationAngle;
        this.rotationAngle = angle;
        this.firePropertyChange("rotationAngle", old, this.rotationAngle);
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoTextObject tmp;
        boolean isCopy = false;
        if (comp instanceof JaxoTextObject && (tmp = (JaxoTextObject)comp).getRotationAngle() == this.getRotationAngle() && tmp.getTextString().equals(this.getTextString()) && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoTextObject temp) {
        super.copyFrom(temp);
        this.setTextString(temp.getTextString());
        this.setRotationAngle(temp.getRotationAngle());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoTextObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoTextObject)o);
    }

    public final void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
    }

    public boolean canBeSelected(int handle, int mode) {
        boolean active;
        boolean bl = active = handle == 0;
        if (mode == 451) {
            active = false;
        }
        return active;
    }

    public final String latexWidth() {
        return "%";
    }

    public void rescaleObject(int orx, int ory, float scale) {
        Point2D newP = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        this.setLocation((int)Math.round(newP.getX()), (int)Math.round(newP.getY()));
    }

    public void setPreferences() {
        super.setPreferences();
        this.setRotationAngle(0);
        this.setTextString(null);
    }
}

