/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.loop;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoParticleObject;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoLoopObject
extends JaxoParticleObject {
    private static final long serialVersionUID = 2L;
    private static final int LP4 = 12;

    public final JaxoObject copy(JaxoLoopObject temp) {
        temp.copyFrom(this);
        return temp;
    }

    public boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoLoopObject) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public void paint(JaxoGraphics2D g2) {
        GeneralPath gp = this.getObjectPath();
        if (gp == null) {
            return;
        }
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(gp);
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    public Rectangle getBounds() {
        GeneralPath gp = this.getObjectPath();
        if (gp == null) {
            Rectangle bb = new Rectangle();
            bb.add(this.getX(), this.getY());
            bb.add(this.getX2(), this.getY2());
            return bb;
        }
        Rectangle bb = this.getStroke().createStrokedShape(gp).getBounds();
        if (this.isPaintArrow()) {
            bb.add(this.getArrow().getBounds(this.arrowCoordinates()));
        }
        return bb;
    }

    public String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        Point2D angles = this.getLaTexAngles();
        String options = this.getAxo4JOptions(scale);
        return "\\Arc" + options + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(radius) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + ")";
    }

    public final void paintVisualAid(JaxoGraphics2D g2) {
        int x = this.getX();
        int y = this.getY();
        g2.drawLine(x - 12, y, x + 12, y);
        g2.drawLine(x, y - 12, x, y + 12);
    }

    public JaxoArrow.Coordinates arrowCoordinates() {
        Point2D.Double ap = this.getLoopPoint(1.0f - this.getArrowPosition());
        double theta = Math.atan2(ap.y - (double)this.getY(), ap.x - (double)this.getX()) - 1.5707963267948966;
        if (this.isFlip()) {
            theta += Math.PI;
        }
        return new JaxoArrow.Coordinates(ap.x, ap.y, theta);
    }

    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D p = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        this.setLocation((int)Math.round(p.getX()), (int)Math.round(p.getY()));
        this.setX2(this.getX() + newRelWidth);
        this.setY2(this.getY() + newRelHeight);
        this.setWiggles(Math.round((float)this.getWiggles() * scale));
        this.setAmp(Math.round((float)this.getAmp() * scale));
    }

    protected Point2D getLaTexCenter(float scaleFactor, int canvasHeight) {
        return this.getLaTexLocation(scaleFactor, canvasHeight);
    }

    public final Point2D.Float[] getEquidistantPoints(int n) {
        Point2D.Float p0 = new Point2D.Float(this.getX(), this.getY());
        Point2D.Float p1 = new Point2D.Float(this.getX2(), this.getY2());
        double radius = this.getRadius();
        double dphi = Math.PI * 2 / (double)n;
        double phi1 = Math.atan2(p1.y - p0.y, p1.x - p0.x);
        Point2D.Float[] point = new Point2D.Float[n + 1];
        point[0] = p1;
        for (int i = 1; i <= n; ++i) {
            float px = p0.x + (float)(radius * Math.cos(phi1 + (double)i * dphi));
            float py = p0.y + (float)(radius * Math.sin(phi1 + (double)i * dphi));
            point[i] = new Point2D.Float(px, py);
        }
        return point;
    }

    private Point2D.Double getLoopPoint(double t) {
        double par = JaxoGeometry.curveParameter(t) * 2.0 * Math.PI;
        double phi1 = Math.atan2(this.getY2() - this.getY(), this.getX2() - this.getX()) + Math.PI;
        double radius = this.getRadius();
        double px = (double)this.getX() + radius * Math.cos(phi1 + par);
        double py = (double)this.getY() + radius * Math.sin(phi1 + par);
        return new Point2D.Double(px, py);
    }

    protected float getLaTexRadius(float scaleFactor) {
        return (float)this.getRadius() / scaleFactor;
    }

    protected Point2D getLaTexAngles() {
        int sAngle = (int)(-Math.round(Math.atan2(this.getRelh(), this.getRelw()) * 180.0 / Math.PI)) + 180;
        int eAngle = sAngle + 360;
        return new Point2D.Float(sAngle, eAngle);
    }

    protected abstract GeneralPath getObjectPath();

    protected abstract String getAxo4JOptions(float var1);
}

