/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.bezier;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.bezier.JaxoBezierObject;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoPBezier
extends JaxoBezierObject
implements JaxoWiggleObject {
    private static final long serialVersionUID = 2L;
    private transient float freq;
    private transient Point2D b2;
    private transient List<Double> renormsteps;
    private static final int TOLERANCE = 1;

    public JaxoPBezier() {
        this.initParams();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initParams();
    }

    private void initParams() {
        this.freq = 0.0f;
        this.b2 = new Point2D.Double();
        this.renormsteps = new ArrayList<Double>(50);
    }

    public final JaxoObject copy() {
        JaxoPBezier temp = new JaxoPBezier();
        temp.copyFrom(this);
        return temp;
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoPBezier) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public void copyFrom(JaxoPBezier temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoPBezier)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoPBezier)o);
    }

    public final void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getObjectPath());
    }

    public Rectangle getBounds() {
        return this.getStroke().createStrokedShape(new Area(this.getObjectPath())).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        this.initRenormSteps();
        String command = this.constructLatexString(scale, canvasDim.height);
        String jdIdentifier = "%JaxoID:PBez(" + this.getX() + "," + this.getY() + ")" + "(" + this.getX2() + "," + this.getY2() + ")" + "(" + this.getX3() + "," + this.getY3() + ")" + "(" + this.getX4() + "," + this.getY4() + ")" + "{" + this.getAmp() + "}" + "{" + this.getWiggles() + "}" + "[" + this.isNoFreqStretching() + "]";
        return command + jdIdentifier;
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        int n = (int)Math.round(this.getBezierLength() * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.getBezierLength());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setWigglesFromFrequency(0.05f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add4PointsPanel(this.getPoints(), 0, 0, 3);
        editPanel.addLineColorPanel(this.getColor(), 3, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 1);
        editPanel.addStretchingPanel(this.isNoFreqStretching(), 2, 1);
        editPanel.setTitleAndIcon("Photon_bezier_parameters", "bezierph.png");
    }

    private double setNextPoint(Point2D b1, double par, double tstep, boolean noFreqStretching) {
        double tpar = par;
        this.tryNextBezierPoint(tpar);
        if (noFreqStretching) {
            double reflength;
            double length = this.b2.distance(b1);
            if (length - (reflength = 1.0 / (double)this.getFrequency() / 2.0) > 1.0) {
                int alter = -1;
                for (int l = 1; l < 20; ++l) {
                    double rtpar = tpar + (double)alter * tstep / Math.pow(2.0, l);
                    this.tryNextBezierPoint(rtpar);
                    length = this.b2.distance(b1);
                    if (Math.abs(length - reflength) <= 1.0) {
                        tpar = rtpar;
                        break;
                    }
                    if (length - reflength > 1.0) {
                        alter = -1;
                        tpar = rtpar;
                        continue;
                    }
                    tpar = rtpar;
                    alter = 1;
                }
            } else if (length - reflength < -1.0) {
                double rtpar;
                int l;
                int alter = -1;
                boolean seconditer = true;
                for (l = 1; l < 10; ++l) {
                    rtpar = tpar + (double)l * tstep;
                    this.tryNextBezierPoint(rtpar);
                    length = this.b2.distance(b1);
                    if (Math.abs(length - reflength) <= 1.0) {
                        seconditer = false;
                        tpar = rtpar;
                        break;
                    }
                    if (length - reflength > 1.0) {
                        seconditer = true;
                        alter = -1;
                        tpar = rtpar;
                        break;
                    }
                    tpar = rtpar;
                }
                if (seconditer) {
                    for (l = 1; l < 20; ++l) {
                        rtpar = tpar + (double)alter * tstep / Math.pow(2.0, l);
                        this.tryNextBezierPoint(rtpar);
                        length = this.b2.distance(b1);
                        if (Math.abs(length - reflength) <= 1.0) {
                            tpar = rtpar;
                            break;
                        }
                        if (length - reflength > 1.0) {
                            alter = -1;
                            tpar = rtpar;
                            continue;
                        }
                        tpar = rtpar;
                        alter = 1;
                    }
                }
            }
        }
        this.renormsteps.add(tpar);
        return tpar;
    }

    private void tryNextBezierPoint(double t) {
        this.b2.setLocation(this.getPointOnCurve(t));
    }

    private GeneralPath getObjectPath() {
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        this.initRenormSteps();
        return this.drawingRoutine();
    }

    private GeneralPath drawingRoutine() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        Point2D.Double b1 = new Point2D.Double(this.getX(), this.getY());
        double arot = 1.5707963267948966;
        double c = 0.4244131815783876;
        double amp = 0.6666666666666666 * (double)this.getAmp();
        Point2D.Double parallel = new Point2D.Double();
        Point2D.Double perp1 = new Point2D.Double();
        Point2D.Double perp2 = new Point2D.Double();
        AffineTransform at = new AffineTransform();
        for (int t = 0; t < this.renormsteps.size(); ++t) {
            this.tryNextBezierPoint(this.renormsteps.get(t));
            double theta = Math.atan2(this.b2.getY() - ((Point2D)b1).getY(), this.b2.getX() - ((Point2D)b1).getX());
            double lx = amp * Math.cos(theta);
            double ly = amp * Math.sin(theta);
            double bxp1 = ((Point2D)b1).getX() + (this.b2.getX() - ((Point2D)b1).getX()) * 0.4244131815783876;
            double byp1 = ((Point2D)b1).getY() + (this.b2.getY() - ((Point2D)b1).getY()) * 0.4244131815783876;
            double bxp2 = ((Point2D)b1).getX() + (this.b2.getX() - ((Point2D)b1).getX()) * 0.5755868184216124;
            double byp2 = ((Point2D)b1).getY() + (this.b2.getY() - ((Point2D)b1).getY()) * 0.5755868184216124;
            at.setToIdentity();
            at.rotate(arot, bxp1, byp1);
            ((Point2D)parallel).setLocation(bxp1 - lx, byp1 - ly);
            ((Point2D)perp1).setLocation(0.0, 0.0);
            at.transform(parallel, perp1);
            at.setToIdentity();
            at.rotate(arot, bxp2, byp2);
            ((Point2D)parallel).setLocation(bxp2 - lx, byp2 - ly);
            ((Point2D)perp2).setLocation(0.0, 0.0);
            at.transform(parallel, perp2);
            gp.moveTo(((Point2D)b1).getX(), ((Point2D)b1).getY());
            gp.curveTo(((Point2D)perp1).getX(), ((Point2D)perp1).getY(), ((Point2D)perp2).getX(), ((Point2D)perp2).getY(), this.b2.getX(), this.b2.getY());
            arot = -arot;
            b1.setLocation(this.b2);
        }
        return gp;
    }

    private String constructLatexString(float scale, int canvasHeight) {
        StringBuffer command = new StringBuffer(128);
        Point2D.Double b1 = new Point2D.Double(this.getX(), this.getY());
        double arot = 1.5707963267948966;
        double c = 0.4244131815783876;
        double amp = 0.6666666666666666 * (double)this.getAmp();
        Point2D.Double parallel = new Point2D.Double();
        Point2D.Double perp1 = new Point2D.Double();
        Point2D.Double perp2 = new Point2D.Double();
        AffineTransform at = new AffineTransform();
        for (int t = 0; t < this.renormsteps.size(); ++t) {
            this.tryNextBezierPoint(this.renormsteps.get(t));
            double theta = Math.atan2(this.b2.getY() - ((Point2D)b1).getY(), this.b2.getX() - ((Point2D)b1).getX());
            double lx = amp * Math.cos(theta);
            double ly = amp * Math.sin(theta);
            double bxp1 = ((Point2D)b1).getX() + (this.b2.getX() - ((Point2D)b1).getX()) * 0.4244131815783876;
            double byp1 = ((Point2D)b1).getY() + (this.b2.getY() - ((Point2D)b1).getY()) * 0.4244131815783876;
            double bxp2 = ((Point2D)b1).getX() + (this.b2.getX() - ((Point2D)b1).getX()) * 0.5755868184216124;
            double byp2 = ((Point2D)b1).getY() + (this.b2.getY() - ((Point2D)b1).getY()) * 0.5755868184216124;
            at.setToIdentity();
            at.rotate(arot, bxp1, byp1);
            ((Point2D)parallel).setLocation(bxp1 - lx, byp1 - ly);
            ((Point2D)perp1).setLocation(0.0, 0.0);
            at.transform(parallel, perp1);
            at.setToIdentity();
            at.rotate(arot, bxp2, byp2);
            ((Point2D)parallel).setLocation(bxp2 - lx, byp2 - ly);
            ((Point2D)perp2).setLocation(0.0, 0.0);
            at.transform(parallel, perp2);
            Point2D latexP1 = JaxoPBezier.getLatexPoint(b1, scale, canvasHeight);
            Point2D latexP2 = JaxoPBezier.getLatexPoint(perp1, scale, canvasHeight);
            Point2D latexP3 = JaxoPBezier.getLatexPoint(perp2, scale, canvasHeight);
            Point2D latexP4 = JaxoPBezier.getLatexPoint(this.b2, scale, canvasHeight);
            command.append(' ').append(JaxoPBezier.bezierLatexCommand("", latexP1, latexP2, latexP3, latexP4));
            arot = -arot;
            b1.setLocation(this.b2);
        }
        return command.toString();
    }

    private void initRenormSteps() {
        this.renormsteps.clear();
        double length = this.getBezierLength();
        int wnumb = 2 * (int)Math.round(length * (double)this.getFrequency());
        double tstep = 1.0f / (float)wnumb;
        double lptol = this.isNoFreqStretching() ? 0.015 : 1.0E-4;
        Point2D.Double b1 = new Point2D.Double(this.getX(), this.getY());
        double tpar = tstep;
        while (tpar <= 1.0 + tstep && (!(Math.abs((tpar = this.setNextPoint(b1, tpar, tstep, this.isNoFreqStretching())) - 1.0 - tstep) < lptol) || !(Math.abs(this.b2.getX() - (double)this.getX()) > 0.1) && !(Math.abs(this.b2.getY() - (double)this.getY()) > 0.1))) {
            b1.setLocation(this.b2);
            tpar += tstep;
        }
        if (this.renormsteps.get(this.renormsteps.size() - 1) - 1.0 > 1.0E-7) {
            this.renormsteps.remove(this.renormsteps.size() - 1);
        }
        double corr = (1.0 - this.renormsteps.get(this.renormsteps.size() - 1)) / (double)this.renormsteps.size();
        for (int i = 0; i < this.renormsteps.size(); ++i) {
            double rvalue = this.renormsteps.get(i) + corr * (double)(i + 1);
            this.renormsteps.set(i, rvalue);
        }
    }
}

